/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.handlers;

import java.util.List;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import src.train.common.api.AbstractTrains;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.Locomotive;

public class LinkHandler {
    private World worldObj;
    private int numLaps;
    private float distanceBehindCart;

    public LinkHandler(World world) {
        this.worldObj = world;
        this.numLaps = 0;
    }

    public void handleStake(Entity entityOne, AxisAlignedBB customBoundingBox) {
        AxisAlignedBB box2 = null;
        double length = 5.0;
        box2 = customBoundingBox.func_72314_b(7.0, 5.0, 7.0);
        List lis = this.worldObj.func_72839_b(entityOne, box2);
        if (lis != null && lis.size() > 0) {
            for (int j1 = 0; j1 < lis.size(); ++j1) {
                Entity entity = (Entity)lis.get(j1);
                if (entityOne instanceof AbstractTrains && entity instanceof AbstractTrains) {
                    this.doesLink1StillExist(entityOne, lis);
                    this.doesLink2StillExist(entityOne, lis);
                }
                if (entity == entityOne.field_70153_n || !(entity instanceof AbstractTrains) || !((AbstractTrains)entityOne).isAttaching || !((AbstractTrains)entity).isAttaching) continue;
                this.addStake(entity, entityOne, true);
            }
        }
        if (((AbstractTrains)entityOne).cartLinked1 != null) {
            this.StakePhysic((Entity)((AbstractTrains)entityOne).cartLinked1, entityOne);
        }
        if (((AbstractTrains)entityOne).cartLinked2 != null) {
            this.StakePhysic((Entity)((AbstractTrains)entityOne).cartLinked2, entityOne);
        }
    }

    private void doesLink1StillExist(Entity entityOne, List lis) {
        for (int j1 = 0; j1 < lis.size(); ++j1) {
            Entity entity = (Entity)lis.get(j1);
            if (!(entity instanceof AbstractTrains) || (double)((AbstractTrains)entity).getID() != ((AbstractTrains)entityOne).Link1) continue;
            return;
        }
        if (((AbstractTrains)entityOne).Link1 != 0.0) {
            this.freeLink1(entityOne);
        }
        if (((AbstractTrains)entityOne).Link1 == -1.0) {
            this.freeLink1(entityOne);
        }
    }

    private void doesLink2StillExist(Entity entityOne, List lis) {
        for (int j1 = 0; j1 < lis.size(); ++j1) {
            Entity entity = (Entity)lis.get(j1);
            if (!(entity instanceof AbstractTrains) || (double)((AbstractTrains)entity).getID() != ((AbstractTrains)entityOne).Link2) continue;
            return;
        }
        if (((AbstractTrains)entityOne).Link2 != 0.0) {
            this.freeLink2(entityOne);
        }
        if (((AbstractTrains)entityOne).Link2 == -1.0) {
            this.freeLink2(entityOne);
        }
    }

    private void freeLink1(Entity entity) {
        ((AbstractTrains)entity).Link1 = 0.0;
        ((AbstractTrains)entity).cartLinked1 = null;
        ((EntityRollingStock)entity).RollingStock.clear();
    }

    private void freeLink2(Entity entity) {
        ((AbstractTrains)entity).Link2 = 0.0;
        ((AbstractTrains)entity).cartLinked2 = null;
        ((EntityRollingStock)entity).RollingStock.clear();
    }

    private void addLinkNumber(Entity entity) {
        ((EntityRollingStock)entity).linkageNumber = 0;
        if (((AbstractTrains)entity).Link1 != 0.0) {
            ++((EntityRollingStock)entity).linkageNumber;
        } else if (((EntityRollingStock)entity).linkageNumber > 0) {
            --((EntityRollingStock)entity).linkageNumber;
        }
        if (((AbstractTrains)entity).Link2 != 0.0) {
            ++((EntityRollingStock)entity).linkageNumber;
        } else if (((EntityRollingStock)entity).linkageNumber > 0) {
            --((EntityRollingStock)entity).linkageNumber;
        }
    }

    private void updateCartsNumber(Entity entity, Entity entityOne) {
        int j1;
        ++this.numLaps;
        if (this.numLaps > 700) {
            this.numLaps = 0;
            for (int i = 0; i < ((EntityRollingStock)entity).RollingStock.size(); ++i) {
                EntityRollingStock toClear = (EntityRollingStock)((EntityRollingStock)entity).RollingStock.get(i);
                toClear.linkhandler.numLaps = 0;
                toClear.numLaps2 = 0;
                toClear.RollingStock.clear();
            }
        }
        if (!((EntityRollingStock)entity).RollingStock.contains(entity) && !(entity instanceof Locomotive)) {
            ((EntityRollingStock)entity).RollingStock.add((EntityRollingStock)entity);
        }
        if (!((EntityRollingStock)entityOne).RollingStock.contains(entity) && !(entity instanceof Locomotive)) {
            ((EntityRollingStock)entityOne).RollingStock.add((EntityRollingStock)entity);
        }
        for (j1 = 0; j1 < ((EntityRollingStock)entity).RollingStock.size(); ++j1) {
            if (((EntityRollingStock)entityOne).RollingStock.contains(((EntityRollingStock)entity).RollingStock.get(j1))) continue;
            ((EntityRollingStock)entityOne).RollingStock.add(((EntityRollingStock)entity).RollingStock.get(j1));
        }
        for (j1 = 0; j1 < ((EntityRollingStock)entityOne).RollingStock.size(); ++j1) {
            if (((EntityRollingStock)entity).RollingStock.contains(((EntityRollingStock)entityOne).RollingStock.get(j1))) continue;
            ((EntityRollingStock)entity).RollingStock.add(((EntityRollingStock)entityOne).RollingStock.get(j1));
        }
        AxisAlignedBB bigBox = null;
        AxisAlignedBB customBoundingBox = ((EntityRollingStock)entityOne).field_70121_D;
        bigBox = customBoundingBox.func_72314_b(150.60000000298024, 150.60000000298024, 150.60000000298024);
        List listing = this.worldObj.func_72839_b(entityOne, bigBox);
        for (int j12 = 0; j12 < ((EntityRollingStock)entityOne).RollingStock.size(); ++j12) {
            if (!this.search((Entity)((EntityRollingStock)entityOne).RollingStock.get(j12), listing)) {
                EntityRollingStock entityToRemove = (EntityRollingStock)((EntityRollingStock)entityOne).RollingStock.get(j12);
                ((EntityRollingStock)entityOne).RollingStock.remove(entityToRemove);
                continue;
            }
            EntityRollingStock entityCheckLinks = (EntityRollingStock)((EntityRollingStock)entityOne).RollingStock.get(j12);
            if (entityCheckLinks.linkageNumber == 2) continue;
            ((EntityRollingStock)entityOne).RollingStock.remove(entityCheckLinks);
        }
    }

    private boolean search(Entity entity, List lis) {
        if (lis != null && lis.size() > 0) {
            return lis.contains(entity) && ((EntityRollingStock)entity).isAttached;
        }
        return false;
    }

    public void addStake(Entity entity, Entity entityOne, boolean byPlayer) {
        double d1;
        double d;
        double d2;
        this.distanceBehindCart = ((AbstractTrains)entity).getLinkageDistance((EntityMinecart)entity);
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (((AbstractTrains)entityOne).isAttaching && ((AbstractTrains)entity).isAttaching && entity instanceof AbstractTrains && (d2 = (double)MathHelper.func_76133_a((double)((d = entity.field_70165_t - entityOne.field_70165_t) * d + (d1 = entity.field_70161_v - entityOne.field_70161_v) * d1))) <= (double)this.distanceBehindCart) {
            EntityPlayer entityplayer;
            if (((AbstractTrains)entity).Link1 == 0.0) {
                ((AbstractTrains)entity).Link1 = ((AbstractTrains)entityOne).getID();
            } else if (((AbstractTrains)entity).Link2 == 0.0) {
                ((AbstractTrains)entity).Link2 = ((AbstractTrains)entityOne).getID();
            }
            if (((AbstractTrains)entity).cartLinked1 == null) {
                ((AbstractTrains)entity).cartLinked1 = (EntityRollingStock)entityOne;
            } else if (((AbstractTrains)entity).cartLinked2 == null) {
                ((AbstractTrains)entity).cartLinked2 = (EntityRollingStock)entityOne;
            }
            if (((AbstractTrains)entityOne).Link1 == 0.0) {
                ((AbstractTrains)entityOne).Link1 = ((AbstractTrains)entity).getID();
            } else if (((AbstractTrains)entityOne).Link2 == 0.0) {
                ((AbstractTrains)entityOne).Link2 = ((AbstractTrains)entity).getID();
            }
            if (((AbstractTrains)entityOne).cartLinked1 == null) {
                ((AbstractTrains)entityOne).cartLinked1 = (EntityRollingStock)entity;
            } else if (((AbstractTrains)entityOne).cartLinked2 == null) {
                ((AbstractTrains)entityOne).cartLinked2 = (EntityRollingStock)entity;
            }
            ((AbstractTrains)entityOne).isAttached = true;
            ((AbstractTrains)entityOne).isAttaching = false;
            ((AbstractTrains)entity).isAttaching = false;
            ((AbstractTrains)entity).isAttached = true;
            if (((AbstractTrains)entityOne).cartLinked1 != null && ((AbstractTrains)entityOne).cartLinked1.train != null) {
                EntityRollingStock cfr_ignored_0 = ((AbstractTrains)entityOne).cartLinked1;
                EntityRollingStock.allTrains.remove(((AbstractTrains)entityOne).cartLinked1.train);
                ((AbstractTrains)entityOne).cartLinked1.train.getTrains().clear();
            }
            if (((AbstractTrains)entityOne).cartLinked2 != null && ((AbstractTrains)entityOne).cartLinked2.train != null) {
                EntityRollingStock cfr_ignored_1 = ((AbstractTrains)entityOne).cartLinked2;
                EntityRollingStock.allTrains.remove(((AbstractTrains)entityOne).cartLinked2.train);
                ((AbstractTrains)entityOne).cartLinked2.train.getTrains().clear();
            }
            if ((entityplayer = entity.field_70170_p.func_72890_a(entity, 20.0)) != null && byPlayer) {
                entityplayer.func_71035_c("attached!");
            }
        }
    }

    public boolean areLinked(Entity cart1, Entity cart2) {
        if ((double)((AbstractTrains)cart2).getID() == ((AbstractTrains)cart1).Link1 || (double)((AbstractTrains)cart2).getID() == ((AbstractTrains)cart1).Link2) {
            return true;
        }
        return (double)((AbstractTrains)cart1).getID() == ((AbstractTrains)cart2).Link1 || (double)((AbstractTrains)cart1).getID() == ((AbstractTrains)cart2).Link2;
    }

    public float getOptimalDistance(Entity cart1, Entity cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof AbstractTrains ? (dist += ((AbstractTrains)cart1).getOptimalDistance((EntityMinecart)cart2)) : (dist += 0.78f);
        dist = cart2 instanceof AbstractTrains ? (dist += ((AbstractTrains)cart2).getOptimalDistance((EntityMinecart)cart1)) : (dist += 0.78f);
        return dist;
    }

    private boolean canCartBeAdjustedBy(Entity cart1, Entity cart2) {
        if (cart1 == cart2) {
            return false;
        }
        if (cart1 instanceof EntityRollingStock && !((EntityRollingStock)cart1).canBeAdjusted((EntityMinecart)cart2)) {
            return false;
        }
        return !RailTools.isCartLockedDown((EntityMinecart)cart1);
    }

    private void StakePhysic(Entity cart1, Entity cart2) {
        if (cart1 instanceof AbstractTrains && cart2 instanceof AbstractTrains && ((AbstractTrains)cart2).isAttached && ((AbstractTrains)cart1).isAttached && this.areLinked(cart2, cart1)) {
            if (this.worldObj.field_72995_K) {
                return;
            }
            boolean adj1 = this.canCartBeAdjustedBy(cart1, cart2);
            boolean adj2 = this.canCartBeAdjustedBy(cart2, cart1);
            double d = ((AbstractTrains)cart1).field_70165_t - ((AbstractTrains)cart2).field_70165_t;
            double d1 = ((AbstractTrains)cart1).field_70161_v - ((AbstractTrains)cart2).field_70161_v;
            double d2 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
            double vecX = ((AbstractTrains)cart1).field_70165_t - ((AbstractTrains)cart2).field_70165_t;
            double vecZ = ((AbstractTrains)cart1).field_70161_v - ((AbstractTrains)cart2).field_70161_v;
            double vecNorm = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
            double unitX = vecX / vecNorm;
            double unitZ = vecZ / vecNorm;
            float optDist = this.getOptimalDistance(cart1, cart2);
            double stretch = d2 - (double)optDist;
            double div = 0.2499999761581421;
            double springX = div * stretch * vecX * -1.0;
            double springZ = div * stretch * vecZ * -1.0;
            springX = this.limitForce(springX);
            springZ = this.limitForce(springZ);
            if (adj1) {
                ((AbstractTrains)cart1).field_70159_w += springX;
                ((AbstractTrains)cart1).field_70179_y += springZ;
            }
            if (adj2) {
                ((AbstractTrains)cart2).field_70159_w -= springX;
                ((AbstractTrains)cart2).field_70179_y -= springZ;
            }
            double speedVecX = ((AbstractTrains)cart1).field_70159_w - ((AbstractTrains)cart2).field_70159_w;
            double speedVecZ = ((AbstractTrains)cart1).field_70179_y - ((AbstractTrains)cart2).field_70179_y;
            double dot = speedVecX * unitX + speedVecZ * unitZ;
            double divider = 0.4f;
            double dampX = divider * dot * unitX * -1.0;
            double dampZ = divider * dot * unitZ * -1.0;
            dampX = this.limitForce(dampX);
            dampZ = this.limitForce(dampZ);
            if (adj1) {
                ((AbstractTrains)cart1).field_70159_w += dampX;
                ((AbstractTrains)cart1).field_70179_y += dampZ;
            }
            if (adj2) {
                ((AbstractTrains)cart2).field_70159_w -= dampX;
                ((AbstractTrains)cart2).field_70179_y -= dampZ;
            }
        }
    }

    private double limitForce(double force) {
        return Math.copySign(Math.abs(Math.min(Math.abs(force), 6.0)), force);
    }
}

