/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core;

import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.Locomotive;
import src.train.common.api.SteamTrain;

public class HandleOverheating {
    private int breakDelay = 0;
    public static int SMALL_STEAM_EU_HEATINGTIME = 140;
    public static int CHEREPANOV_HEATINGTIME = 120;
    public static int CHEREPANOV_EXPLOSION_RADIUS = 6;
    public static int CHME3_HEATINGTIME = 170;
    public static int CHME3_EXPLOSION_RADIUS = 10;
    public static int BR_E69_HEATINGTIME = 400;
    public static int BR_E69_EXPLOSION_RADIUS = 15;
    public static int GP40_HEATINGTIME = 250;
    public static int GP40_EXPLOSION_RADIUS = 20;
    public static int GP7_HEATINGTIME = 200;
    public static int GP7_EXPLOSION_RADIUS = 17;
    public static int HEAVY_STEAM_HEATINGTIME = 350;
    public static int HEAVY_STEAM_EXPLOSION_RADIUS = 23;
    public static int MINETRAIN_HEATINGTIME = 160;
    public static int MINETRAIN_EXPLOSION_RADIUS = 6;
    public static int SPEED_HEATINGTIME = 230;
    public static int SPEED_EXPLOSION_RADIUS = 10;
    public static int SPEED2_HEATINGTIME = 300;
    public static int SPEED2_EXPLOSION_RADIUS = 13;
    public static int SHUNTER_HEATINGTIME = 260;
    public static int SHUNTER_EXPLOSION_RADIUS = 20;
    public static int STEAM_HEATINGTIME = 190;
    public static int STEAM_EXPLOSION_RADIUS = 10;
    public static int SMALL_STEAM_HEATINGTIME = 160;
    public static int SMALL_STEAM_EXPLOSION_RADIUS = 6;
    public static int STEAM_BIG_HEATINGTIME = 160;
    public static int STEAM_BIG_EXPLOSION_RADIUS = 20;
    public static int TRAM_HEATINGTIME = 170;
    public static int TRAM_EXPLOSION_RADIUS = 7;
    public static int TRAM_WOOD_HEATINGTIME = 140;
    public static int TRAM_WOOD_EXPLOSION_RADIUS = 5;
    public static int TRAM_YELLOW_HEATINGTIME = 200;
    public static int TRAM_YELLOW_EXPLOSION_RADIUS = 6;
    public static int VL10_HEATINGTIME = 400;
    public static int VL10_EXPLOSION_RADIUS = 16;
    public static int MOGUL_HEATINGTIME = 180;
    public static int FORNEY_HEATINGTIME = 130;
    public static int BR01_HEATINGTIME = 300;
    public static int BR80_HEATINGTIME = 135;
    public static int SD70_HEATINGTIME = 200;
    public static int ER_USSR_HEATINGTIME = 200;
    public static int U57_HEATINGTIME = 200;

    public HandleOverheating(EntityRollingStock entity) {
    }

    public void HandleHeatLevel(EntityRollingStock entity) {
        entity.overheatLevel = entity.getOverheatLevel();
        if (entity instanceof Locomotive && entity.canOverheat()) {
            double locoMaxSpeed = entity.convertSpeed((Entity)entity);
            double locoActualSpeed = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            if (locoActualSpeed <= 0.05 && !entity.isBreaking && entity.overheatLevel > entity.getAverageOverheat() && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && ((Locomotive)entity).getState() != "broken") {
                --entity.overheatLevel;
            }
            if (locoActualSpeed <= 0.1 && !entity.isBreaking && entity.overheatLevel > entity.getAverageOverheat() && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && ((Locomotive)entity).getState() != "broken") {
                --entity.overheatLevel;
            }
            if (entity.fuelTrain < 1 && entity.overheatLevel > 0 && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && ((Locomotive)entity).getState() != "broken") {
                --entity.overheatLevel;
            }
            if (entity.overheatLevel > (entity.getOverheatTime() + 30) / 2 && entity.field_70170_p.field_73012_v.nextInt(30) == 0 && ((Locomotive)entity).getState() != "broken") {
                --entity.overheatLevel;
            }
            if (entity.fuelTrain > 1 && entity.overheatLevel < (entity.getOverheatTime() + 30) / 2 && entity.field_70170_p.field_73012_v.nextInt(7) == 0) {
                ++entity.overheatLevel;
            }
            if (entity.field_70170_p.field_73013_u >= 2) {
                if (entity.isBreaking) {
                    ++this.breakDelay;
                }
                if (entity.isBreaking && this.breakDelay > 40 && Math.abs(entity.field_70159_w) + Math.abs(entity.field_70179_y) > 0.05 && entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
                    entity.overheatLevel += 2;
                }
                if (!entity.isBreaking) {
                    this.breakDelay = 0;
                }
                if (!entity.isClimbing || !(locoActualSpeed >= locoMaxSpeed - 0.05) || entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
                    // empty if block
                }
                if (entity instanceof SteamTrain) {
                    int maxWaterLevel;
                    int waterLevel = ((SteamTrain)entity).getWater();
                    if (waterLevel < 1 && entity.fuelTrain > 10 && entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
                        entity.overheatLevel += 3;
                    }
                    if (waterLevel > (maxWaterLevel = ((SteamTrain)entity).getCartTankCapacity()) - maxWaterLevel / 2 && entity.overheatLevel > entity.getAverageOverheat() && ((Locomotive)entity).getState() != "broken") {
                        --entity.overheatLevel;
                    }
                }
            }
            if ((double)entity.overheatLevel < (double)entity.getAverageOverheat() - this.overheatRatio(17.0, entity)) {
                ((Locomotive)entity).setState("cold");
            }
            if ((double)entity.overheatLevel < (double)entity.getAverageOverheat() - this.overheatRatio(4.0, entity) && (double)entity.overheatLevel > (double)entity.getAverageOverheat() - this.overheatRatio(17.0, entity)) {
                ((Locomotive)entity).setState("warm");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() - this.overheatRatio(4.0, entity) && (double)entity.overheatLevel < (double)entity.getAverageOverheat() + this.overheatRatio(12.0, entity)) {
                ((Locomotive)entity).setState("hot");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() + this.overheatRatio(12.0, entity)) {
                ((Locomotive)entity).setState("very hot");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() + this.overheatRatio(17.0, entity)) {
                ((Locomotive)entity).setState("too hot");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() + this.overheatRatio(24.0, entity)) {
                ((Locomotive)entity).setState("broken");
            }
            entity.setOverheatLevel(entity.overheatLevel);
        }
    }

    private double overheatRatio(double pixels, EntityRollingStock entity) {
        double barSize = 50.0;
        return (double)entity.getOverheatTime() * (pixels / barSize);
    }
}

