/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.events.CartLockdownEvent;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import src.train.common.blocks.tracks.TrackBaseTraincraft;

public abstract class BlockTrackLockingBase
extends TrackBaseTraincraft
implements ITrackLockdown,
ITrackPowered {
    protected static double START_BOOST = 4.0E-4;
    protected static double BOOST_FACTOR = 1.0E-5;
    protected double prevSpeedX = 0.0;
    protected double prevSpeedZ = 0.0;
    protected boolean powered = false;
    private EntityMinecart lockedCart;
    protected byte prevDelay = 0;
    protected byte delay = 0;

    @Override
    public Icon getIcon() {
        if (this.isPowered() || this.delay > 0) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public EntityMinecart getCurrentCart() {
        return this.lockedCart;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        this.setCurrentCart(null);
    }

    protected void setCurrentCart(EntityMinecart cart) {
        if (this.prevSpeedX == 0.0 && cart != null) {
            this.prevSpeedX = cart.field_70159_w;
        }
        if (this.prevSpeedZ == 0.0 && cart != null) {
            this.prevSpeedZ = cart.field_70179_y;
        }
        this.lockedCart = cart;
    }

    protected void lockCart(EntityMinecart cart) {
        if (cart != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Lock(cart, this.getX(), this.getY(), this.getZ()));
        }
    }

    protected void releaseCart(EntityMinecart cart) {
        if (cart != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Release(cart, this.getX(), this.getY(), this.getZ()));
        }
    }

    protected void checkCart(EntityMinecart cart) {
        if (this.delay > 0 && cart != this.lockedCart) {
            this.delay = 0;
            this.setCurrentCart(cart);
        }
    }

    protected byte getDelayTime() {
        return 3;
    }

    @Override
    public void releaseCart() {
        this.delay = (byte)10;
    }

    @Override
    public boolean isCartLockedDown(EntityMinecart cart) {
        return !this.powered && this.lockedCart == cart && this.delay == 0;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.delay);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.delay = data.readByte();
        this.markBlockNeedsUpdate();
    }
}

