/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import src.train.common.api.Locomotive;
import src.train.common.blocks.tracks.SpeedControllerSteel;
import src.train.common.blocks.tracks.TrackBaseTraincraft;
import src.train.common.library.TrackIDs;

public class BlockLocomotiveSpeedControllerTrack
extends TrackBaseTraincraft {
    private int mode = 0;

    public BlockLocomotiveSpeedControllerTrack() {
        this.speedController = SpeedControllerSteel.getInstance();
    }

    @Override
    public TrackIDs getTrackType() {
        return TrackIDs.LOCO_SPEED_CONTROLLER;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            ++this.mode;
            if (this.mode > 4) {
                this.mode = 0;
            }
            if (this.mode == 0) {
                player.func_71035_c("20 percent of max speed");
            }
            if (this.mode == 1) {
                player.func_71035_c("40 percent of max speed");
            }
            if (this.mode == 2) {
                player.func_71035_c("60 percent of max speed");
            }
            if (this.mode == 3) {
                player.func_71035_c("80 percent of max speed");
            }
            if (this.mode == 4) {
                player.func_71035_c("100 percent of max speed");
            }
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (cart instanceof Locomotive) {
            double maxSpeed = ((Locomotive)cart).getMaxSpeed();
            if (this.mode == 0) {
                ((Locomotive)cart).speedLimiter = 0.2;
            }
            if (this.mode == 1) {
                ((Locomotive)cart).speedLimiter = 0.4;
            }
            if (this.mode == 2) {
                ((Locomotive)cart).speedLimiter = 0.6;
            }
            if (this.mode == 3) {
                ((Locomotive)cart).speedLimiter = 0.8;
            }
            if (this.mode == 4) {
                ((Locomotive)cart).speedLimiter = 1.0;
            }
            ((Locomotive)cart).field_70159_w *= 10.0;
            ((Locomotive)cart).field_70179_y *= 10.0;
        }
    }

    @Override
    public Icon getIcon() {
        return this.getIcon(0 + this.mode);
    }

    protected void notifyNeighbors() {
        int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_72898_h(this.getX(), this.getY(), this.getZ(), id);
        this.getWorld().func_72898_h(this.getX(), this.getY() - 1, this.getZ(), id);
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("mode", this.mode);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.mode = nbttagcompound.func_74762_e("mode");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.mode);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.mode = data.readInt();
        this.markBlockNeedsUpdate();
    }
}

