/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import src.train.common.Traincraft;
import src.train.common.api.Locomotive;
import src.train.common.blocks.tracks.BlockTrackLockingBase;
import src.train.common.library.TrackIDs;

public class BlockLocomotiveHoldingTrack
extends BlockTrackLockingBase
implements ITrackPowered,
ITrackLockdown {
    protected static float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;
    protected byte reset = 0;

    @Override
    public TrackIDs getTrackType() {
        return TrackIDs.LOCO_HOLDING_TRACK;
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().func_70089_S()) {
            this.setCurrentCart(null);
        }
        if (Traincraft.isHost(this.getWorld())) {
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                this.delay = (byte)(this.delay - 1);
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
            if (this.reset > 0) {
                this.reset = (byte)(this.reset - 1);
            }
        }
        if (this.prevDelay == 0 ^ this.delay == 0) {
            this.sendUpdateToClient();
        }
        this.prevDelay = this.delay;
    }

    @Override
    protected void checkCart(EntityMinecart cart) {
        if (this.delay > 0 && (cart != this.getCurrentCart() || this.reset == 0)) {
            this.delay = 0;
            this.setCurrentCart(cart);
            this.setLaunchDirection(cart);
        }
        this.reset = (byte)10;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (!(cart instanceof Locomotive) && cart.getClass().getSuperclass() != null && !cart.getClass().getSuperclass().getName().equals("EntityLocomotive")) {
            return;
        }
        this.checkCart(cart);
        int meta = this.tileEntity.func_70322_n();
        if (this.isPowered() || this.delay > 0) {
            this.releaseCart(cart);
            double boostX = Math.abs(this.prevSpeedX);
            double boostZ = Math.abs(this.prevSpeedZ);
            this.prevSpeedX = 0.0;
            this.prevSpeedZ = 0.0;
            if (meta == 0 || meta == 4 || meta == 5) {
                if (boostZ != 0.0) {
                    cart.field_70179_y = this.launchForward ? boostZ : -boostZ;
                }
            } else if ((meta == 1 || meta == 2 || meta == 3) && boostX != 0.0) {
                cart.field_70159_w = this.launchForward ? boostX : -boostX;
            }
        } else {
            if (this.getCurrentCart() == null) {
                this.setCurrentCart(cart);
                this.setLaunchDirection(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.field_70159_w = 0.0;
                cart.field_70179_y = 0.0;
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)this.tileEntity.field_70327_n + 0.5);
                } else {
                    cart.func_70107_b((double)this.tileEntity.field_70329_l + 0.5, cart.field_70163_u, cart.field_70161_v);
                }
            }
        }
    }

    protected void setLaunchDirection(EntityMinecart cart) {
        int meta = this.tileEntity.func_70322_n();
        double speed = CartTools.getCartSpeedUncapped(cart);
        if (speed > (double)DIR_THRESHOLD) {
            boolean launch = this.launchForward;
            if (meta == 0 || meta == 4 || meta == 5) {
                launch = cart.field_70179_y > 0.0;
            } else if (meta == 1 || meta == 2 || meta == 3) {
                boolean bl = launch = cart.field_70159_w > 0.0;
            }
            if (this.launchForward != launch) {
                this.launchForward = launch;
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("launchForward", this.launchForward);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.launchForward = data.func_74767_n("launchForward");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.launchForward);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.launchForward = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

