/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import src.train.common.api.ElectricTrain;
import src.train.common.api.EntityRollingStock;
import src.train.common.blocks.tracks.SpeedControllerSteel;
import src.train.common.blocks.tracks.TrackBaseTraincraft;
import src.train.common.core.handlers.EnergyNetHandler;
import src.train.common.library.TrackIDs;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public class BlockEnergyTrack
extends TrackBaseTraincraft
implements IVoltage {
    private byte delay = 0;
    public int energy = 0;
    public int maxEnergy = 1000;
    public int maxInput = 1000;
    public int output = 500;
    public int frequency = 0;
    public boolean isProvider = false;
    public boolean addedToEnergyNet = false;
    public static EnergyNetHandler network = new EnergyNetHandler();
    private Block thisBlock;
    private int updateTicks = 0;

    public BlockEnergyTrack() {
        this.speedController = SpeedControllerSteel.getInstance();
    }

    @Override
    public TrackIDs getTrackType() {
        return TrackIDs.ENERGY_TRACK;
    }

    private Block getThisBlock() {
        if (this.thisBlock == null) {
            int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
            this.thisBlock = Block.field_71973_m[id];
        }
        return this.thisBlock;
    }

    @Override
    public void updateEntity() {
        int output;
        ElectricityPack electricityPack;
        if (this.getWorld().field_72995_K) {
            return;
        }
        ++this.updateTicks;
        if (!this.addedToEnergyNet) {
            network.addToNetwork(this);
            this.addedToEnergyNet = true;
        }
        if (this.updateTicks % 200 == 0) {
            network.cleanNetwork();
        }
        if ((electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this.getTile(), this.getConsumingSides(), this.getRequest())) != null && electricityPack.getWatts() > 0.0) {
            this.isProvider = true;
            this.setEnergy((double)this.energy + electricityPack.getWatts());
        }
        if (this.updateTicks % 5 == 0 && network != null && network.getNetwork() != null && network.getNetwork().size() > 0 && (double)this.energy >= this.getMaxEnergy() - 1.0 && (output = Math.min(this.output, this.energy)) > 0) {
            this.energy = (short)(this.energy - this.sendEnergy(output));
        }
        if (this.updateTicks % 50 == 0) {
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public void onBlockRemoved() {
        if (network != null && network.getNetwork() != null) {
            network.getNetwork().remove(this);
        }
    }

    protected EnumSet getConsumingSides() {
        EnumSet<ForgeDirection> possibleSides = EnumSet.noneOf(ForgeDirection.class);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)i);
            possibleSides.add(direction);
        }
        return possibleSides;
    }

    private boolean isMinecartTrackAt(int par1, int par2, int par3) {
        return BlockRail.func_72180_d_((World)this.getWorld(), (int)par1, (int)par2, (int)par3) ? true : (BlockRail.func_72180_d_((World)this.getWorld(), (int)par1, (int)(par2 + 1), (int)par3) ? true : BlockRail.func_72180_d_((World)this.getWorld(), (int)par1, (int)(par2 - 1), (int)par3));
    }

    @Override
    public Icon getIcon() {
        int meta = this.tileEntity.func_70322_n();
        if (meta >= 6) {
            if (this.energy > 0) {
                return this.getIcon(3);
            }
            return this.getIcon(2);
        }
        if (this.energy > 0) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean isFlexibleRail() {
        return true;
    }

    private void notifyNeighbors() {
        int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_72898_h(this.getX(), this.getY(), this.getZ(), id);
        this.getWorld().func_72898_h(this.getX(), this.getY() - 1, this.getZ(), id);
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current == null) {
            if (this.frequency > 0 && player.func_70093_af()) {
                --this.frequency;
            }
            if (!player.func_70093_af()) {
                ++this.frequency;
            }
            player.func_71035_c("frequency: " + this.frequency);
            return true;
        }
        if (current != null && current.func_77973_b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)current.func_77973_b();
            player.func_71035_c("stored: " + this.energy + "/1000");
            player.func_71035_c("frequency: " + this.frequency);
            this.markBlockNeedsUpdate();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (!(cart instanceof ElectricTrain)) {
            return;
        }
        if (this.energy > 0 && ((ElectricTrain)cart).fuelTrain < ((ElectricTrain)cart).maxEnergy) {
            double transfered = (double)this.energy * 0.05;
            ((EntityRollingStock)cart).fuelTrain = (int)((double)((EntityRollingStock)cart).fuelTrain + transfered);
            this.energy = (int)((double)this.energy - transfered);
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
        nbttagcompound.func_74768_a("frequency", this.frequency);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
        this.frequency = nbttagcompound.func_74762_e("frequency");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.energy);
        data.writeInt(this.frequency);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.energy = data.readInt();
        this.frequency = data.readInt();
        this.markBlockNeedsUpdate();
    }

    public double getDistanceSq(double par1, double par3, double par5) {
        double var7 = (double)this.getX() - par1;
        double var9 = (double)this.getY() - par3;
        if (Math.abs(var9) == 1.0) {
            var9 = 0.0;
        }
        double var11 = (double)this.getZ() - par5;
        return Math.sqrt(var7 * var7 + var11 * var11);
    }

    public boolean isBeside(int x2, int y2, int z2) {
        if (this.getX() + 1 == x2 && this.getY() == y2 && this.getZ() == z2 || this.getX() + 1 == x2 && this.getY() + 1 == y2 && this.getZ() == z2 || this.getX() + 1 == x2 && this.getY() + 1 == y2 && this.getZ() == z2) {
            return true;
        }
        if (this.getX() - 1 == x2 && this.getY() == y2 && this.getZ() == z2 || this.getX() - 1 == x2 && this.getY() - 1 == y2 && this.getZ() == z2 || this.getX() - 1 == x2 && this.getY() - 1 == y2 && this.getZ() == z2) {
            return true;
        }
        if (this.getX() == x2 && this.getY() == y2 && this.getZ() + 1 == z2 || this.getX() == x2 && this.getY() + 1 == y2 && this.getZ() + 1 == z2 || this.getX() == x2 && this.getY() - 1 == y2 && this.getZ() + 1 == z2) {
            return true;
        }
        if (this.getX() == x2 && this.getY() == y2 && this.getZ() - 1 == z2 || this.getX() == x2 && this.getY() + 1 == y2 && this.getZ() - 1 == z2 || this.getX() == x2 && this.getY() - 1 == y2 && this.getZ() - 1 == z2) {
            return true;
        }
        if (this.getX() + 1 == x2 && this.getY() == y2 && this.getZ() + 1 == z2 || this.getX() + 1 == x2 && this.getY() + 1 == y2 && this.getZ() + 1 == z2 || this.getX() + 1 == x2 && this.getY() - 1 == y2 && this.getZ() + 1 == z2) {
            return true;
        }
        if (this.getX() - 1 == x2 && this.getY() == y2 && this.getZ() + 1 == z2 || this.getX() - 1 == x2 && this.getY() + 1 == y2 && this.getZ() + 1 == z2 || this.getX() - 1 == x2 && this.getY() - 1 == y2 && this.getZ() + 1 == z2) {
            return true;
        }
        if (this.getX() - 1 == x2 && this.getY() == y2 && this.getZ() - 1 == z2 || this.getX() - 1 == x2 && this.getY() + 1 == y2 && this.getZ() - 1 == z2 || this.getX() - 1 == x2 && this.getY() - 1 == y2 && this.getZ() - 1 == z2) {
            return true;
        }
        return this.getX() + 1 == x2 && this.getY() == y2 && this.getZ() - 1 == z2 || this.getX() + 1 == x2 && this.getY() + 1 == y2 && this.getZ() - 1 == z2 || this.getX() + 1 == x2 && this.getY() - 1 == y2 && this.getZ() - 1 == z2;
    }

    public int sendEnergy(int send) {
        for (int i = 0; i < network.getNetwork().size(); ++i) {
            if (network.getNetwork().get(i) == null || network.getNetwork().get(i).equals(this)) continue;
            int x2 = ((BlockEnergyTrack)network.getNetwork().get(i)).getX();
            int y2 = ((BlockEnergyTrack)network.getNetwork().get(i)).getY();
            int z2 = ((BlockEnergyTrack)network.getNetwork().get(i)).getZ();
            if (((BlockEnergyTrack)BlockEnergyTrack.network.getNetwork().get((int)i)).frequency != this.frequency || ((BlockEnergyTrack)BlockEnergyTrack.network.getNetwork().get((int)i)).isProvider || !this.isProvider || !(((BlockEnergyTrack)network.getNetwork().get(i)).getEnergy() < ((BlockEnergyTrack)network.getNetwork().get(i)).getMaxEnergy()) || !(this.getDistanceSq(x2, y2, z2) <= 50.0)) continue;
            double transfered = ((BlockEnergyTrack)network.getNetwork().get(i)).getMaxEnergy() - ((BlockEnergyTrack)network.getNetwork().get(i)).getEnergy();
            transfered = Math.min((double)this.output, transfered);
            ((BlockEnergyTrack)network.getNetwork().get(i)).setEnergy(transfered + ((BlockEnergyTrack)network.getNetwork().get(i)).getEnergy());
            if (!(transfered > 0.0)) continue;
            return (int)transfered;
        }
        return 0;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    public void setEnergy(double joules) {
        this.energy = (int)Math.max(Math.min(joules, this.getMaxEnergy()), 0.0);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack((this.getMaxEnergy() - this.getEnergy()) / this.getVoltage(), this.getVoltage());
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }
}

