/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import src.train.common.api.Freight;
import src.train.common.api.LiquidManager;

public abstract class Tender
extends Freight
implements ITankContainer {
    public ItemStack[] tenderItems;
    public int liquidId = 0;
    public int fuelSlot = 1;
    public int waterSlot = 1;
    private int maxTank;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private ILiquidTank[] tankArray = new ILiquidTank[1];
    private LiquidStack liquid;

    public Tender(World world, int liquidId, int quantity, int capacity) {
        this(new LiquidStack(liquidId, quantity), capacity, world, null);
    }

    public Tender(World world, int liquidId, int quantity, int capacity, LiquidStack filter) {
        this(new LiquidStack(liquidId, quantity), capacity, world, filter);
    }

    private Tender(LiquidStack liquid, int capacity, World world, LiquidStack filter) {
        super(world);
        this.liquid = liquid;
        this.maxTank = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(23, (Object)new Integer(0));
    }

    @Override
    public abstract int func_70302_i_();

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getLiquid() != null) {
            this.field_70180_af.func_75692_b(23, (Object)this.theTank.getLiquid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getLiquid().itemID);
        } else if (this.theTank != null && this.theTank.getLiquid() == null) {
            this.field_70180_af.func_75692_b(23, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
    }

    public int getWater() {
        return this.field_70180_af.func_75679_c(23);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public int getCartTankCapacity() {
        return this.maxTank;
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    private void placeInInvent(ItemStack itemstack1, Tender tender) {
        for (int i = 1; i < tender.tenderItems.length; ++i) {
            if (tender.tenderItems[i] == null) {
                tender.tenderItems[i] = itemstack1;
                return;
            }
            if (tender.tenderItems[i] != null && tender.tenderItems[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || tender.tenderItems[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)tender.tenderItems[i], (ItemStack)itemstack1)) {
                int var9 = tender.tenderItems[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= itemstack1.func_77976_d()) {
                    tender.tenderItems[i].field_77994_a = var9;
                } else if (tender.tenderItems[i].field_77994_a < itemstack1.func_77976_d()) {
                    ++tender.tenderItems[i].field_77994_a;
                }
                return;
            }
            if (i != tender.tenderItems.length - 1) continue;
            this.func_70054_a(itemstack1.func_77973_b().field_77779_bT, 1, 0.0f);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack, Tender tender) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this.theTank, itemstack, 0)) != null) {
            this.placeInInvent(result, tender);
        }
    }

    protected void checkInvent(ItemStack tenderInvent, Tender loco) {
        if (tenderInvent != null) {
            this.liquidInSlot(tenderInvent, loco);
        }
    }

    public void setLiquid(LiquidStack liquid) {
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.maxTank = capacity;
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.tankArray;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.theTank;
    }
}

