/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import src.train.common.api.Locomotive;
import src.train.common.entity.rollingStock.EntityLocoSpeed;
import src.train.common.entity.rollingStock.EntityLocoTram;
import src.train.common.entity.rollingStock.EntityLocoVL10;
import src.train.common.entity.rollingStock.EntityNewHighSpeedLoco;

public class SpeedHandler {
    public static double BR_E69 = 50.0;
    public static double CHME3 = 95.0;
    public static double GP40 = 70.0;
    public static double GP7 = 75.0;
    public static double HEAVYSTEAM = 90.0;
    public static double SHUNTER = 70.0;
    public static double HIGHSPEED = 237.0;
    public static double HIGHSPEED2 = 237.0;
    public static double STEAM = 50.0;
    public static double SMALLSTEAM = 45.0;
    public static double CHEREPANOV = 30.0;
    public static double MINETRAIN = 40.0;
    public static double TRAM = 65.0;
    public static double VL10 = 150.0;
    public static double STEAMBIG = 110.0;
    public static double MOGUL = 65.0;
    public static double FORNEY = 70.0;
    public static double BR01 = 120.0;
    public static double BR80 = 45.0;
    public static double SD70 = 80.0;
    public static double ER_USSR = 80.0;
    public static double U57 = 120.0;
    public static double KOF_DB = 57.0;

    public double handleSpeed(double railMaxSpeed, float maxSpeed, Entity entity) {
        if (railMaxSpeed >= 0.4 && railMaxSpeed <= 0.45 && entity instanceof Locomotive) {
            return this.convertSpeed(entity);
        }
        if (railMaxSpeed < 0.4 && entity instanceof Locomotive) {
            if (this.convertSpeed(entity) < railMaxSpeed) {
                return this.convertSpeed(entity);
            }
            return railMaxSpeed;
        }
        if (railMaxSpeed > 0.45 && entity instanceof Locomotive) {
            return this.convertSpeed(entity) + 0.2;
        }
        if (entity instanceof Locomotive) {
            return railMaxSpeed;
        }
        return 1.1;
    }

    private boolean isSpeedRail(Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        return SpeedHandler.isSpeedRailAt(entity.field_70170_p, i, j, k);
    }

    public static boolean isSpeedRailAt(World world, int i, int j, int k) {
        int id = world.func_72798_a(i, j, k);
        Block block = Block.field_71973_m[id];
        if (block != null && block.getClass().getName() == "IRailSpeed") {
            return true;
        }
        TileEntity tile = world.func_72796_p(i, j, k);
        return tile != null && tile.getClass().getName() == "IRailSpeed";
    }

    private boolean canGoFaster(Entity entity) {
        return entity instanceof EntityNewHighSpeedLoco || entity instanceof EntityLocoSpeed || entity instanceof EntityLocoTram || entity instanceof EntityLocoVL10;
    }

    public double speedXFromPitch(EntityPlayer player, double var3) {
        return (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI))) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    public double speedZFromPitch(EntityPlayer player, double var3) {
        return (double)MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    private double convertSpeed(Entity entity) {
        double speed = ((Locomotive)entity).getCustomSpeed();
        speed /= 6.0;
        speed /= 10.0;
        if (entity instanceof Locomotive && speed > 0.695 && ((Locomotive)entity).isAttached) {
            double max = 0.695;
            return max;
        }
        return speed;
    }
}

