/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.input.Keyboard;
import src.train.common.Traincraft;
import src.train.common.api.DieselTrain;
import src.train.common.api.ElectricTrain;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.LiquidManager;
import src.train.common.api.SteamTrain;
import src.train.common.core.HandleMaxAttachedCarts;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.core.handlers.FuelHandler;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.library.EnumSounds;

public abstract class Locomotive
extends EntityRollingStock
implements ISpecialInventory {
    public int numCargoSlots;
    public int numCargoSlots1;
    public int numCargoSlots2;
    public int inventorySize;
    public double speedDivider = 3.6;
    protected ItemStack[] locoInvent;
    protected int KEY_INV;
    protected static int KEY_ACC;
    protected static int KEY_DEC;
    protected static int KEY_TURNLEFT;
    protected static int KEY_TURNRIGHT;
    protected static int KEY_HORN;
    private int soundPosition = 0;
    public boolean parkingBrake = false;
    private int whistleDelay = 0;
    private int blowUpDelay = 0;
    private String lastRider = "";
    private Entity lastEntityRider;
    public boolean canBePulled = false;
    HandleMaxAttachedCarts maxAttached = new HandleMaxAttachedCarts();
    protected int fuelRate;
    private String locoState = "";
    protected boolean canBeAdjusted = false;
    public int currentNumCartsPulled = 0;
    public double currentMassPulled = 0.0;
    public double currentSpeedSlowDown = 0.0;
    public double currentAccelSlowDown = 0.0;
    public double currentBrakeSlowDown = 0.0;
    public double currentFuelConsumptionChange = 0.0;

    public abstract boolean isFuelled();

    public abstract int c(int var1);

    public Locomotive(World world) {
        super(world);
        this.setFuelConsumption(0);
        this.field_70180_af.func_75682_a(2, (Object)new Integer(0));
        this.mass = 0.0;
        this.setCustomSpeed(this.getMaxSpeed());
        this.field_70180_af.func_75682_a(3, (Object)new String(this.destination));
        this.field_70180_af.func_75682_a(22, (Object)new String(this.locoState));
        this.field_70180_af.func_75682_a(24, (Object)new Integer(this.fuelTrain));
        this.field_70180_af.func_75682_a(25, (Object)new Integer((int)this.convertSpeed(Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y))));
        this.field_70180_af.func_75682_a(26, (Object)new String(this.castToString(this.currentNumCartsPulled)));
        this.field_70180_af.func_75682_a(27, (Object)new String(this.castToString(this.currentMassPulled)));
        this.field_70180_af.func_75682_a(28, (Object)new String(this.castToString(Math.round(this.currentSpeedSlowDown))));
        this.field_70180_af.func_75682_a(29, (Object)new String(this.castToString(this.currentAccelSlowDown)));
        this.field_70180_af.func_75682_a(30, (Object)new String(this.castToString(this.currentBrakeSlowDown)));
        this.field_70180_af.func_75682_a(31, (Object)new String(this.castToString(this.currentFuelConsumptionChange)));
        this.field_70180_af.func_75682_a(15, (Object)new String(this.castToString(Math.round(this.getCustomSpeed() * 3.6))));
        this.setAccel(0.0);
        this.setBrake(0.0);
        this.field_70144_Y = 0.99f;
        try {
            if (Class.forName("org.lwjgl.input.Keyboard") != null && Keyboard.isCreated()) {
                KEY_ACC = ConfigHandler.Key_Acc;
                KEY_DEC = ConfigHandler.Key_Dec;
                this.KEY_INV = ConfigHandler.Key_Invent;
                KEY_HORN = ConfigHandler.Key_Horn;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private String castToString(double str) {
        return "" + str;
    }

    public abstract int setFuelConsumption(int var1);

    public abstract int getFuelConsumption();

    public abstract double getCustomSpeed();

    public abstract double getMaxSpeed();

    public abstract void setCustomSpeed(double var1);

    protected int getCurrentMaxSpeed() {
        return this.field_70180_af.func_75679_c(2);
    }

    protected void setCurrentMaxSpeed(int maxSpeed) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(2, (Object)maxSpeed);
        }
    }

    public abstract double setAccel(double var1);

    public abstract double setBrake(double var1);

    public abstract int getPower();

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("canBeAdjusted", this.canBeAdjusted);
        nbttagcompound.func_74757_a("canBePulled", this.canBePulled);
        nbttagcompound.func_74768_a("overheatLevel", this.getOverheatLevel());
        nbttagcompound.func_74778_a("lastRider", this.lastRider);
        nbttagcompound.func_74778_a("destination", this.destination);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.canBeAdjusted = nbttagcompound.func_74767_n("canBeAdjusted");
        this.canBePulled = nbttagcompound.func_74767_n("canBePulled");
        this.setOverheatLevel(nbttagcompound.func_74762_e("overheatLevel"));
        this.lastRider = nbttagcompound.func_74779_i("lastRider");
        this.destination = nbttagcompound.func_74779_i("destination");
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setCanBeAdjusted(boolean canBeAdj) {
        this.canBeAdjusted = canBeAdj;
    }

    public abstract void pressKey(int var1);

    public void keyHandlerFromPacket(int i) {
        this.pressKey(i);
        if (i == 8 && ConfigHandler.SOUNDS) {
            for (EnumSounds sounds : EnumSounds.values()) {
                if (sounds.getEntityClass() == null || !sounds.getEntityClass().equals(this.getClass()) || this.whistleDelay != 0) continue;
                this.field_70170_p.func_72956_a((Entity)this, sounds.getHornString(), sounds.getHornVolume().floatValue(), 1.0f);
                this.whistleDelay = 160;
            }
        }
        if (i == 4 && this.getFuel() > 0 && this.field_70146_Z.nextInt(4) == 0 && !this.field_70170_p.field_72995_K && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            int dir = MathHelper.func_76128_c((double)((double)(((EntityPlayer)this.field_70153_n).field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (dir == 2) {
                this.field_70179_y -= 0.01 * this.accelerate;
            }
            if (dir == 1) {
                this.field_70159_w -= 0.01 * this.accelerate;
            }
            if (dir == 0) {
                this.field_70179_y += 0.01 * this.accelerate;
            }
            if (dir == 3) {
                this.field_70159_w += 0.01 * this.accelerate;
            }
        }
        if (i == 5) {
            this.field_70159_w *= this.brake;
            this.field_70179_y *= this.brake;
        }
    }

    public void pressKeyLoco(int i) {
        this.keyHandler.sendKeyControlsPacket(i);
    }

    public String getCurrentNumCartsPulled() {
        return this.field_70180_af.func_75681_e(26);
    }

    public String getCurrentMassPulled() {
        return this.field_70180_af.func_75681_e(27);
    }

    public String getCurrentSpeedSlowDown() {
        return this.field_70180_af.func_75681_e(28);
    }

    public String getCurrentAccelSlowDown() {
        return this.field_70180_af.func_75681_e(29);
    }

    public String getCurrentBrakeSlowDown() {
        return this.field_70180_af.func_75681_e(30);
    }

    public String getCurrentFuelConsumptionChange() {
        return this.field_70180_af.func_75681_e(31);
    }

    public String getCustomSpeedGUI() {
        return this.field_70180_af.func_75681_e(15);
    }

    public String getDestinationGUI() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75681_e(3);
        }
        return this.destination;
    }

    private double convertSpeed(double speed) {
        speed *= 10.0;
        speed *= 6.0;
        return speed *= 3.6;
    }

    @Override
    public boolean isStorageCart() {
        return false;
    }

    public void pressKeyClient() {
        if (Traincraft.proxy.getCurrentScreen() == null && this.field_70153_n != null && this.field_70153_n.field_70154_o != null && this.field_70153_n.field_70154_o == this) {
            try {
                if (Class.forName("org.lwjgl.input.Keyboard") != null && Keyboard.isCreated()) {
                    if (Keyboard.isKeyDown((int)KEY_ACC)) {
                        this.pressKeyLoco(4);
                    }
                    if (Keyboard.isKeyDown((int)KEY_DEC)) {
                        this.pressKeyLoco(5);
                    }
                    if (Keyboard.isKeyDown((int)this.KEY_INV)) {
                        this.pressKeyLoco(7);
                    }
                    if (Keyboard.isKeyDown((int)KEY_HORN)) {
                        this.pressKeyLoco(8);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void func_70071_h_() {
        this.pressKeyClient();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(25, (Object)((int)this.convertSpeed(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))));
            this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
            this.field_70180_af.func_75692_b(20, (Object)this.overheatLevel);
            this.field_70180_af.func_75692_b(22, (Object)this.locoState);
            this.field_70180_af.func_75692_b(3, (Object)this.destination);
            this.field_70180_af.func_75692_b(26, (Object)this.castToString(this.currentNumCartsPulled));
            this.field_70180_af.func_75692_b(27, (Object)(this.castToString(this.currentMassPulled) + " tons"));
            this.field_70180_af.func_75692_b(28, (Object)(this.castToString((int)this.currentSpeedSlowDown) + " km/h"));
            this.field_70180_af.func_75692_b(29, (Object)this.castToString((double)Math.round(this.currentAccelSlowDown * 1000.0) / 1000.0));
            this.field_70180_af.func_75692_b(30, (Object)this.castToString((double)Math.round(this.currentBrakeSlowDown * 1000.0) / 1000.0));
            this.field_70180_af.func_75692_b(31, (Object)("1c/" + this.castToString((int)this.currentFuelConsumptionChange) + " per tick"));
            this.field_70180_af.func_75692_b(15, (Object)(this.castToString((int)(this.getCustomSpeed() * 3.6)) + " km/h"));
        }
        if (!this.field_70170_p.field_72995_K && this.updateTicks % 20 == 0) {
            this.maxAttached.PullPhysic((Entity)this);
        }
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            this.lastRider = ((EntityPlayer)this.field_70153_n).field_71092_bJ;
            this.lastEntityRider = this.field_70153_n;
        }
        if (!this.field_70170_p.field_72995_K && this.getParkingBrakeFromPacket() && this.getState() != "broken") {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (ConfigHandler.SOUNDS) {
            for (EnumSounds sounds : EnumSounds.values()) {
                if (sounds.getEntityClass() == null || !sounds.getEntityClass().equals(this.getClass())) continue;
                if (this.getFuel() <= 0) break;
                double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (speed > -0.001 && speed < 0.01 && this.soundPosition == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, sounds.getIdleString(), sounds.getIdleVolume().floatValue(), 0.001f);
                    this.soundPosition = sounds.getIdleSoundLenght();
                }
                if (sounds.getSoundChangeWithSpeed()) {
                    if (speed > 0.01 && speed < 0.06 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.1f);
                        this.soundPosition = sounds.getRunSoundLenght();
                    } else if (speed > 0.06 && speed < 0.2 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.4f);
                        this.soundPosition = sounds.getRunSoundLenght() / 2;
                    } else if (speed > 0.2 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.5f);
                        this.soundPosition = sounds.getRunSoundLenght() / 3;
                    }
                } else if (speed > 0.01 && this.soundPosition == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.4f);
                    this.soundPosition = sounds.getRunSoundLenght();
                }
                if (this.soundPosition <= 0) break;
                --this.soundPosition;
                break;
            }
        }
        if (this.getState() == "cold") {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() >= this.getMaxSpeed() * 0.6) {
                this.field_70159_w *= 0.0;
                this.field_70179_y *= 0.0;
            }
        }
        if (this.getState() == "warm") {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() >= this.getMaxSpeed() * 0.7) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        }
        if (this.getState() == "hot") {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() <= this.getMaxSpeed()) {
                // empty if block
            }
        }
        if (this.getState() == "very hot") {
            // empty if block
        }
        if (this.getState() == "too hot") {
            this.field_70159_w *= 0.95;
            this.field_70179_y *= 0.95;
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (this.getState() == "broken") {
            this.func_70015_d(8);
            this.setCustomSpeed(0.0);
            this.setAccel(1.0E-6);
            this.setBrake(1.0);
            this.field_70159_w *= 0.97;
            this.field_70179_y *= 0.97;
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
            ++this.blowUpDelay;
            if (this.blowUpDelay > 80) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, false);
                    this.func_70106_y();
                }
                if (!this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.lastEntityRider != null && this.lastEntityRider instanceof EntityPlayer) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_92062_k(((EntityPlayer)this.lastEntityRider).field_71092_bJ + " blew " + this.trainOwner + "'s locomotive");
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.statsEventHandler.trainExplode(this.uniqueID, this.trainName, this.trainType, this.trainCreator, new String((int)this.field_70165_t + ";" + (int)this.field_70163_u + ";" + (int)this.field_70161_v));
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected void applyDragAndPushForces() {
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    @Override
    public double getDragAir() {
        return 1.0;
    }

    public boolean getParkingBrakeFromPacket() {
        return this.parkingBrake;
    }

    public void sendParkingBrakePacket(boolean packet) {
        PacketHandler.setParkingBrake(this.field_70153_n, (Entity)this, packet);
    }

    public void setParkingBrakeFromPacket(boolean set) {
        this.parkingBrake = set;
    }

    public double getSpeed() {
        return this.field_70180_af.func_75679_c(25);
    }

    @Override
    public int getOverheatLevel() {
        return this.field_70180_af.func_75679_c(20);
    }

    public String getState() {
        return this.field_70180_af.func_75681_e(22);
    }

    public void setState(String state) {
        this.locoState = state;
        this.field_70180_af.func_75692_b(22, (Object)state);
    }

    public int getFuel() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24);
        }
        return this.fuelTrain;
    }

    public boolean getIsFuelled() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) > 0;
        }
        return this.fuelTrain > 0;
    }

    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / 1200;
        }
        return this.fuelTrain * i / 1200;
    }

    private int placeInSpecialInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.locoInvent[i] == null) {
            if (doAdd) {
                this.locoInvent[i] = itemstack1;
            }
            return itemstack1.field_77994_a;
        }
        if (this.locoInvent[i] != null && this.locoInvent[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.locoInvent[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.locoInvent[i], (ItemStack)itemstack1)) {
            int var9 = this.locoInvent[i].field_77994_a + itemstack1.field_77994_a;
            if (var9 <= itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.locoInvent[i].field_77994_a = var9;
                }
                return var9;
            }
            if (this.locoInvent[i].field_77994_a < itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.locoInvent[i].field_77994_a = this.locoInvent[i].func_77976_d();
                }
                return Math.abs(this.locoInvent[i].func_77976_d() - this.locoInvent[i].field_77994_a - itemstack1.field_77994_a);
            }
        }
        return itemstack1.field_77994_a;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (this instanceof SteamTrain) {
            if (FuelHandler.steamFuelLast(stack) > 0) {
                return this.placeInSpecialInvent(stack, 0, doAdd);
            }
            if (LiquidManager.getInstance().isContainer(stack)) {
                return this.placeInSpecialInvent(stack, 1, doAdd);
            }
        }
        if (this instanceof DieselTrain && LiquidManager.getInstance().isDieselLocoFuel(stack)) {
            return this.placeInSpecialInvent(stack, 0, doAdd);
        }
        if (this instanceof ElectricTrain && (stack.func_77973_b().field_77779_bT == Item.field_77767_aC.field_77779_bT || stack.func_77973_b() instanceof IElectricItem)) {
            return this.placeInSpecialInvent(stack, 0, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, int i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10);
        if (this.func_70491_i() > 40) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            this.dropCartAsItem();
        }
        return true;
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        if (ticket != null) {
            this.destination = Locomotive.getTicketDestination(ticket);
            return true;
        }
        return false;
    }
}

