/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.LiquidManager;

public class LiquidTank
extends EntityRollingStock
implements ITankContainer,
ISpecialInventory {
    private LiquidStack liquid;
    private int capacity;
    protected ItemStack[] cargoItems;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private ILiquidTank[] tankArray = new ILiquidTank[1];

    public LiquidTank(World world, int liquidId, int quantity, int capacity) {
        this(new LiquidStack(liquidId, quantity), capacity, world, null);
    }

    public LiquidTank(World world, int liquidId, int quantity, int capacity, LiquidStack filter) {
        this(new LiquidStack(liquidId, quantity), capacity, world, filter);
    }

    private LiquidTank(LiquidStack liquid, int capacity, World world, LiquidStack filter) {
        super(world);
        this.liquid = liquid;
        this.capacity = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(22, (Object)new String(""));
    }

    public int getAmount() {
        return this.field_70180_af.func_75679_c(18);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public String getLiquidName() {
        return this.field_70180_af.func_75681_e(22);
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getLiquid() != null) {
            this.field_70180_af.func_75692_b(18, (Object)this.theTank.getLiquid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getLiquid().itemID);
            this.field_70180_af.func_75692_b(22, (Object)this.theTank.getLiquidName());
        } else if (this.theTank != null && this.theTank.getLiquid() == null) {
            this.field_70180_af.func_75692_b(18, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
            this.field_70180_af.func_75692_b(22, (Object)"");
        }
    }

    public ItemStack checkInvent(ItemStack itemstack) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return itemstack;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer(this, 0, this.theTank, itemstack, 0)) != null) {
            this.func_70099_a(result, 0.0f);
        }
        return itemstack;
    }

    public void setLiquid(LiquidStack liquid) {
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.tankArray;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.theTank;
    }

    private int placeInSpecialInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.cargoItems[i] == null) {
            if (doAdd) {
                this.cargoItems[i] = itemstack1;
            }
            return itemstack1.field_77994_a;
        }
        if (this.cargoItems[i] != null && this.cargoItems[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.cargoItems[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.cargoItems[i], (ItemStack)itemstack1)) {
            int var9 = this.cargoItems[i].field_77994_a + itemstack1.field_77994_a;
            if (var9 <= itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.cargoItems[i].field_77994_a = var9;
                }
                return var9;
            }
            if (this.cargoItems[i].field_77994_a < itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.cargoItems[i].field_77994_a = this.cargoItems[i].func_77976_d();
                }
                return Math.abs(this.cargoItems[i].func_77976_d() - this.cargoItems[i].field_77994_a - itemstack1.field_77994_a);
            }
        }
        return itemstack1.field_77994_a;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (LiquidManager.getInstance().isContainer(stack)) {
            return this.placeInSpecialInvent(stack, 0, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public String func_70303_b() {
        return null;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public List getItemsDropped() {
        return null;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, int i) {
        super.func_70097_a(damagesource, i);
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10);
        if (this.func_70491_i() > 40) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            this.dropCartAsItem();
        }
        return true;
    }
}

