/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.recipes.RefineryRecipe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.fuel.FuelManager;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import src.train.common.library.ItemIDs;

public class LiquidManager {
    public static final int BUCKET_VOLUME = 1000;
    private static LiquidManager instance;
    public static LiquidStack WATER_FILTER;
    public static LiquidStack LAVA_FILTER;
    public static LiquidStack oil;
    public static LiquidStack steam;
    public static LiquidStack fuel;
    public static LiquidStack refinedFuel;
    public static LiquidStack creosoteOil;
    public static LiquidStack biomass;
    public static LiquidStack biofuel;
    public static LiquidStack seedoil;
    public static LiquidStack honey;
    public static LiquidStack juice;
    public static LiquidStack diesel;

    public static LiquidManager getInstance() {
        if (instance == null) {
            instance = new LiquidManager();
        }
        return instance;
    }

    public void registerLiquids() {
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(new LiquidStack(ItemIDs.dieselLiquid.item, 1000), new ItemStack(ItemIDs.diesel.item), new ItemStack(ItemIDs.emptyCanister.item)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(new LiquidStack(ItemIDs.refinedFuelLiquid.item, 1000), new ItemStack(ItemIDs.refinedFuel.item), new ItemStack(ItemIDs.emptyCanister.item)));
        LiquidDictionary.getOrCreateLiquid((String)"Diesel", (LiquidStack)new LiquidStack(ItemIDs.dieselLiquid.item, 1));
        LiquidDictionary.getOrCreateLiquid((String)"RefinedFuel", (LiquidStack)new LiquidStack(ItemIDs.refinedFuelLiquid.item, 1));
        LiquidManager.dieselFilter();
        FuelManager.addBoilerFuel(new LiquidStack(ItemIDs.dieselLiquid.item, 1000), 60000);
        FuelManager.addBoilerFuel(new LiquidStack(ItemIDs.refinedFuelLiquid.item, 1000), 96000);
        IronEngineFuel.fuels.add(new IronEngineFuel(new LiquidStack(ItemIDs.dieselLiquid.item, 1000), 3.0f, 200000));
        IronEngineFuel.fuels.add(new IronEngineFuel(new LiquidStack(ItemIDs.refinedFuelLiquid.item, 1000), 6.0f, 100000));
        RefineryRecipe.registerRefineryRecipe(new RefineryRecipe(LiquidDictionary.getLiquid((String)"Diesel", (int)1), null, new LiquidStack(ItemIDs.refinedFuelLiquid.item, 1), 6, 1));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.CLIENT) {
            return;
        }
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94155_m) {
            LiquidDictionary.getCanonicalLiquid((String)"Diesel").setRenderingIcon(ItemIDs.dieselLiquid.item.func_77617_a(0)).setTextureSheet("/gui/items.png");
            LiquidDictionary.getCanonicalLiquid((String)"RefinedFuel").setRenderingIcon(ItemIDs.refinedFuelLiquid.item.func_77617_a(0)).setTextureSheet("/gui/items.png");
        }
    }

    public static void getLiquidsFromDictionnary() {
        oil = LiquidDictionary.getLiquid((String)"Oil", (int)1);
        diesel = LiquidDictionary.getLiquid((String)"Diesel", (int)1);
        steam = LiquidDictionary.getLiquid((String)"Steam", (int)1);
        fuel = LiquidDictionary.getLiquid((String)"Fuel", (int)1);
        refinedFuel = LiquidDictionary.getLiquid((String)"RefinedFuel", (int)1);
        creosoteOil = LiquidDictionary.getLiquid((String)"Creosote Oil", (int)1);
        biomass = LiquidDictionary.getLiquid((String)"biomass", (int)1);
        biofuel = LiquidDictionary.getLiquid((String)"biofuel", (int)1);
        seedoil = LiquidDictionary.getLiquid((String)"seedoil", (int)1);
        honey = LiquidDictionary.getLiquid((String)"honey", (int)1);
        juice = LiquidDictionary.getLiquid((String)"juice", (int)1);
    }

    public boolean isDieselLocoFuel(ItemStack stack) {
        LiquidStack bucketLiquid = this.getLiquidInContainer(stack);
        LiquidManager.getInstance();
        LiquidStack[] multiFilter = LiquidManager.dieselFilter();
        if (multiFilter != null) {
            for (int i = 0; i < multiFilter.length; ++i) {
                if (multiFilter[i] != null && bucketLiquid != null && multiFilter[i].isLiquidEqual(bucketLiquid.asItemStack())) {
                    return true;
                }
                if (!this.isEmptyContainer(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static LiquidStack[] dieselFilter() {
        LiquidStack[] fuels = new LiquidStack[]{diesel, biofuel, fuel, refinedFuel};
        return fuels;
    }

    public boolean isBucket(ItemStack stack) {
        return LiquidContainerRegistry.isBucket((ItemStack)stack);
    }

    public boolean isContainer(ItemStack stack) {
        return LiquidContainerRegistry.isContainer((ItemStack)stack);
    }

    public boolean isFilledContainer(ItemStack stack) {
        return LiquidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public boolean isEmptyContainer(ItemStack stack) {
        return LiquidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public ItemStack fillLiquidContainer(LiquidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        return LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (ItemStack)empty);
    }

    public LiquidStack getLiquidInContainer(ItemStack stack) {
        return LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack);
    }

    public boolean containsLiquid(ItemStack stack, LiquidStack liquid) {
        return LiquidContainerRegistry.containsLiquid((ItemStack)stack, (LiquidStack)liquid);
    }

    public boolean isLiquidEqual(LiquidStack L1, LiquidStack L2) {
        if (L1 == null || L2 == null) {
            return false;
        }
        return L1.isLiquidEqual(L2);
    }

    public ItemStack processContainer(IInventory inventory, ITankContainer tank, ItemStack itemstack, int tankIndex) {
        ItemStack filled;
        LiquidStack bucketLiquid = this.getLiquidInContainer(itemstack);
        ItemStack emptyItem = itemstack.func_77973_b().getContainerItemStack(itemstack);
        if (bucketLiquid != null && emptyItem == null) {
            int used = tank.fill(tankIndex, bucketLiquid, false);
            if (used >= bucketLiquid.amount) {
                tank.fill(tankIndex, bucketLiquid, true);
                inventory.func_70298_a(0, 1);
                return emptyItem;
            }
        } else if (LiquidManager.getInstance().isEmptyContainer(itemstack) && (filled = LiquidManager.getInstance().fillLiquidContainer(tank.getTanks(ForgeDirection.UNKNOWN)[tankIndex].getLiquid(), itemstack)) != null) {
            LiquidStack liquid = this.getLiquidInContainer(filled);
            LiquidStack drain = tank.drain(tankIndex, liquid.amount, false);
            if (drain != null && drain.amount > 0) {
                tank.drain(tankIndex, liquid.amount, true);
                inventory.func_70298_a(0, 1);
                return filled;
            }
        }
        return null;
    }

    public ItemStack processContainer(IInventory inventory, int inventoryIndex, StandardTank tank, ItemStack itemstack, int tankIndex) {
        ItemStack filled;
        LiquidStack bucketLiquid = this.getLiquidInContainer(itemstack);
        ItemStack emptyItem = itemstack.func_77973_b().getContainerItemStack(itemstack);
        if (bucketLiquid != null) {
            int used = tank.fill(bucketLiquid, false);
            if (used >= bucketLiquid.amount) {
                tank.fill(bucketLiquid, true);
                inventory.func_70298_a(inventoryIndex, 1);
                return emptyItem;
            }
        } else if (LiquidManager.getInstance().isEmptyContainer(itemstack) && (filled = LiquidManager.getInstance().fillLiquidContainer(tank.getLiquid(), itemstack)) != null) {
            LiquidStack liquid = this.getLiquidInContainer(filled);
            LiquidStack drain = tank.drain(liquid.amount, false);
            if (drain != null && drain.amount > 0) {
                tank.drain(liquid.amount, true);
                inventory.func_70298_a(inventoryIndex, 1);
                return filled;
            }
        }
        return null;
    }

    static {
        WATER_FILTER = new LiquidStack(Block.field_71943_B, 0);
        LAVA_FILTER = new LiquidStack(Block.field_71938_D, 0);
    }

    public class FilteredTank
    extends StandardTank {
        private final LiquidStack filter;
        private final LiquidStack[] multiFilter;

        public FilteredTank(int capacity, LiquidStack filter) {
            super(capacity);
            this.filter = filter;
            this.multiFilter = null;
        }

        public FilteredTank(int capacity, LiquidStack filter, int pressure) {
            this(capacity, filter);
            this.setTankPressure(pressure);
        }

        public FilteredTank(int capacity, LiquidStack[] filter) {
            super(capacity);
            this.multiFilter = filter;
            this.filter = null;
        }

        public FilteredTank(int capacity, LiquidStack[] filter, int pressure) {
            this(capacity, filter);
            this.setTankPressure(pressure);
        }

        public int fill(LiquidStack resource, boolean doFill) {
            if (this.multiFilter != null) {
                for (int i = 0; i < this.multiFilter.length; ++i) {
                    if (this.multiFilter[i] == null || !LiquidManager.this.isLiquidEqual(this.multiFilter[i], resource)) continue;
                    return super.fill(resource, doFill);
                }
            } else if (this.filter.isLiquidEqual(resource)) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        public LiquidStack getFilter() {
            return this.filter.copy();
        }

        public boolean liquidMatchesFilter(LiquidStack resource) {
            if (resource == null || this.filter == null) {
                return false;
            }
            return this.filter.isLiquidEqual(resource);
        }
    }

    public class StandardTank
    extends LiquidTank {
        private int tankIndex;

        public StandardTank(int capacity) {
            super(capacity);
        }

        public void setTankIndex(int index) {
            this.tankIndex = index;
        }

        public int getTankIndex() {
            return this.tankIndex;
        }

        public boolean isEmpty() {
            return this.getLiquid() == null || this.getLiquid().amount <= 0;
        }
    }
}

