/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import org.lwjgl.input.Keyboard;
import src.train.client.core.handlers.KeyHandlerClient;
import src.train.client.core.handlers.SoundUpdaterRollingStock;
import src.train.common.Traincraft;
import src.train.common.api.AbstractTrains;
import src.train.common.api.AbstractWorkCart;
import src.train.common.api.DieselTrain;
import src.train.common.api.ElectricTrain;
import src.train.common.api.Freight;
import src.train.common.api.IPassenger;
import src.train.common.api.LiquidTank;
import src.train.common.api.Locomotive;
import src.train.common.api.SpeedHandler;
import src.train.common.api.Tender;
import src.train.common.api.TrainsOnClick;
import src.train.common.core.HandleOverheating;
import src.train.common.core.handlers.CollisionHandler;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.core.handlers.FuelHandler;
import src.train.common.core.handlers.LinkHandler;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.core.handlers.TrainHandler;

public class EntityRollingStock
extends AbstractTrains
implements ILinkableCart {
    public int fuelTrain;
    protected boolean linked = false;
    protected static final int[][][] field_855_j = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    protected EntityPlayer playerEntity;
    public AxisAlignedBB boundingBoxSmall;
    protected boolean field_856_i;
    private ItemStack itemstack;
    public float maxSpeed;
    public float railMaxSpeed;
    public double speedLimiter = 1.0;
    public ItemStack item;
    public int oldfuel;
    public float rotation;
    public int rail;
    public int meta;
    public double d6;
    public double d7;
    protected int rollingturnProgress;
    protected double rollingX;
    protected double rollingY;
    protected double rollingZ;
    protected double rollingYaw;
    public double rotationYawClient;
    protected double rollingPitch;
    protected float renderYaw;
    @SideOnly(value=Side.CLIENT)
    protected double rollingVelocityX;
    @SideOnly(value=Side.CLIENT)
    protected double rollingVelocityY;
    @SideOnly(value=Side.CLIENT)
    protected double rollingVelocityZ;
    private CollisionHandler collisionhandler;
    private CollisionHandler collisionhandlerBack;
    public LinkHandler linkhandler;
    protected LinkHandler linkhandlerBack;
    private TrainsOnClick trainsOnClick;
    public KeyHandlerClient keyHandler;
    protected SpeedHandler speedhandler;
    public boolean isBreaking;
    public boolean isClimbing;
    public int overheatLevel;
    public int linkageNumber;
    protected Side side;
    @SideOnly(value=Side.CLIENT)
    protected SoundManager theSoundManager;
    @SideOnly(value=Side.CLIENT)
    protected SoundUpdaterRollingStock sndUpdater;
    public static ArrayList allTrains = new ArrayList();
    protected int updateTicks = 0;
    private HandleOverheating handleOverheating;
    public ArrayList RollingStock;
    public TrainHandler train;
    private int numLaps;
    public int numLaps2;
    private int ticksSinceHeld = 0;
    private boolean cartLocked = false;

    public EntityRollingStock(World world) {
        super(world);
        this.initRollingStock(world);
    }

    public EntityRollingStock(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public void initRollingStock(World world) {
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(21, (Object)new Integer(0));
        this.field_856_i = false;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.keyHandler = new KeyHandlerClient();
        this.func_70105_a(0.98f, 0.7f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.field_70139_V = 0.98f;
        this.linkageNumber = 0;
        this.field_70144_Y = 0.8f;
        this.boundingBoxSmall = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0);
        this.setBoundingBoxSmall(0.0, 0.0, 0.0, 2.0f, 1.0f);
        this.RollingStock = new ArrayList();
        this.handleOverheating = new HandleOverheating(this);
        this.collisionhandler = new CollisionHandler(world);
        this.linkhandler = new LinkHandler(world);
        this.trainsOnClick = new TrainsOnClick();
        this.speedhandler = new SpeedHandler();
        this.maxSpeedAirLateral = defaultMaxSpeedAirLateral;
        this.maxSpeedAirVertical = defaultMaxSpeedAirVertical;
        this.dragAir = defaultDragAir;
        if (ConfigHandler.FLICKERING) {
            this.field_70158_ak = true;
        }
        this.side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.side == Side.CLIENT) {
            this.sndUpdater = new SoundUpdaterRollingStock();
        }
    }

    public void setInformation(String trainType, String trainOwner, String trainCreator, String trainName, int uniqueID) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(5, (Object)this.ID);
            this.field_70180_af.func_75692_b(6, (Object)trainType);
            this.field_70180_af.func_75692_b(7, (Object)trainOwner);
            this.field_70180_af.func_75692_b(9, (Object)trainName);
            this.field_70180_af.func_75692_b(11, (Object)uniqueID);
            if (trainCreator != null && trainCreator.length() > 0) {
                this.field_70180_af.func_75692_b(13, (Object)trainCreator);
            }
        }
    }

    public String getTrainName() {
        return this.field_70180_af.func_75681_e(9);
    }

    public String getTrainType() {
        return this.field_70180_af.func_75681_e(6);
    }

    public String getTrainOwner() {
        return this.field_70180_af.func_75681_e(7);
    }

    public String getTrainCreator() {
        return this.field_70180_af.func_75681_e(13);
    }

    public int getIDForServer() {
        return this.field_70180_af.func_75679_c(5);
    }

    public int getNumberOfTrainsForServer() {
        return this.field_70180_af.func_75679_c(10);
    }

    public int getUniqueID() {
        return this.field_70180_af.func_75679_c(11);
    }

    @Override
    public int getID() {
        return this.ID;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Override
    public boolean isLocomotive() {
        return this instanceof Locomotive;
    }

    @Override
    public boolean isPassenger() {
        return this instanceof IPassenger;
    }

    @Override
    public boolean isFreightCart() {
        return this instanceof Freight || this instanceof LiquidTank;
    }

    @Override
    public boolean isFreightOrPassenger() {
        return this instanceof Freight || this instanceof IPassenger || this instanceof LiquidTank;
    }

    @Override
    public boolean isBuilder() {
        return this.getClass().equals("EntityTracksBuilder");
    }

    @Override
    public boolean isTender() {
        return this instanceof Tender;
    }

    @Override
    public boolean isWorkCart() {
        return this instanceof AbstractWorkCart;
    }

    @Override
    public boolean isElectricTrain() {
        return this instanceof ElectricTrain;
    }

    protected int steamFuelLast(ItemStack it) {
        return FuelHandler.steamFuelLast(it);
    }

    public boolean func_70097_a(DamageSource damagesource, int i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (damagesource.func_76346_g() instanceof EntityPlayer) {
            this.func_70494_i(-this.func_70493_k());
            this.func_70497_h(10);
            this.func_70018_K();
            if (damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.func_70492_c(1000);
            }
            this.func_70492_c(this.func_70491_i() + i * 10);
            if (this.func_70491_i() > 40) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.statsEventHandler.trainDestroy(this.uniqueID, this.trainName, this.trainType, this.trainCreator, ((EntityPlayer)damagesource.func_76346_g()).field_71092_bJ, new String(this.field_70165_t + ";" + this.field_70163_u + ";" + this.field_70161_v));
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70492_c(this.func_70491_i() + this.func_70491_i() * 10);
    }

    public void func_70106_y() {
        if (this.train != null && this.train.getTrains() != null) {
            for (int i2 = 0; i2 < this.train.getTrains().size(); ++i2) {
                if ((EntityRollingStock)this.train.getTrains().get(i2) instanceof Locomotive) {
                    ((EntityRollingStock)this.train.getTrains().get((int)i2)).cartLinked1 = null;
                    ((EntityRollingStock)this.train.getTrains().get((int)i2)).Link1 = 0.0;
                    ((EntityRollingStock)this.train.getTrains().get((int)i2)).cartLinked2 = null;
                    ((EntityRollingStock)this.train.getTrains().get((int)i2)).Link2 = 0.0;
                }
                if ((EntityRollingStock)this.train.getTrains().get(i2) == this || this.train == null || this.train.getTrains() == null || this.train.getTrains().get(i2) == null || ((EntityRollingStock)this.train.getTrains().get((int)i2)).train == null || ((EntityRollingStock)this.train.getTrains().get((int)i2)).train.getTrains() == null) continue;
                ((EntityRollingStock)this.train.getTrains().get((int)i2)).train.getTrains().clear();
            }
        }
        if (this.train != null && this.train.getTrains().size() <= 1) {
            this.train.getTrains().clear();
            allTrains.remove(this.train);
        }
        this.field_70128_L = true;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            this.soundUpdater();
        }
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void pressKeyTrain(int i) {
        this.keyHandler.sendKeyControlsPacket(i);
    }

    private void handleTrain() {
        if (this instanceof Locomotive && this.train != null) {
            for (int i2 = 0; i2 < this.train.getTrains().size(); ++i2) {
                if (RailTools.isCartLockedDown((EntityMinecart)this.train.getTrains().get(i2))) {
                    this.cartLocked = true;
                    this.ticksSinceHeld = 40;
                    if (!((Locomotive)this).canBeAdjusted) {
                        ((Locomotive)this).setCanBeAdjusted(true);
                    }
                }
                this.cartLocked = false;
            }
            if (this.ticksSinceHeld > 0 && !this.cartLocked) {
                --this.ticksSinceHeld;
            }
            if (this.ticksSinceHeld <= 0 && !this.cartLocked && ((Locomotive)this).canBeAdjusted && !((Locomotive)this).canBePulled) {
                ((Locomotive)this).setCanBeAdjusted(false);
            }
        }
        if (this.updateTicks % 40 != 0) {
            return;
        }
        if (allTrains.size() == 0) {
            if (this.cartLinked1 != null || this.cartLinked2 != null) {
                this.train = new TrainHandler(this);
            }
        } else if ((this.train == null || this.train != null && this.train.getTrains().size() == 0) && (this.cartLinked1 != null || this.cartLinked2 != null)) {
            if (this.cartLinked1 != null && this.cartLinked1.train != null && this.cartLinked1.train.getTrains() != null && this.cartLinked1.train.getTrains().size() != 0) {
                this.train = this.cartLinked1.train;
                return;
            }
            if (this.cartLinked2 != null && this.cartLinked2.train != null && this.cartLinked2.train.getTrains() != null && this.cartLinked2.train.getTrains().size() != 0) {
                this.train = this.cartLinked2.train;
                return;
            }
            this.train = new TrainHandler(this);
        }
        if (this.train != null && this.train.getTrains().size() > 1) {
            if (this instanceof Locomotive && !((Locomotive)this).canBeAdjusted && this.getDestination().length() > 0) {
                for (int i = 0; i < this.train.getTrains().size(); ++i) {
                    if (this.train.getTrains().get(i) != null && !((EntityRollingStock)this.train.getTrains().get(i)).equals(this)) {
                        ((EntityRollingStock)this.train.getTrains().get((int)i)).destination = this.getDestination();
                    }
                    CartTools.setCartOwner((EntityMinecart)this.train.getTrains().get(i), CartTools.getCartOwner(this));
                }
            }
        } else if (!(this instanceof Locomotive)) {
            this.destination = "";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.rollingX = par1;
        this.rollingY = par3;
        this.rollingZ = par5;
        this.rollingYaw = par7;
        this.rollingPitch = par8;
        this.rollingturnProgress = par9 + 2;
        this.field_70159_w = this.rollingVelocityX;
        this.field_70181_x = this.rollingVelocityY;
        this.field_70179_y = this.rollingVelocityZ;
    }

    @Override
    public void func_70071_h_() {
        double var49;
        int k;
        int j;
        Side side;
        super.func_70071_h_();
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0) {
            this.func_70492_c(this.func_70491_i() - 1);
        }
        int a = MathHelper.func_76128_c((double)this.field_70165_t);
        int b = MathHelper.func_76128_c((double)this.field_70163_u);
        int c = MathHelper.func_76128_c((double)this.field_70161_v);
        this.isBreaking = false;
        if (Traincraft.proxy.getCurrentScreen() == null && this.field_70153_n != null && this.field_70153_n.field_70154_o != null && this.field_70153_n.field_70154_o == this) {
            try {
                if (Class.forName("org.lwjgl.input.Keyboard") != null && Keyboard.isCreated() && Keyboard.isKeyDown((int)ConfigHandler.Key_Dec)) {
                    this.isBreaking = true;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            MinecraftServer var1 = ((WorldServer)this.field_70170_p).func_73046_m();
            int var2 = this.func_82145_z();
            if (this.field_71087_bX) {
                if (var1.func_71255_r()) {
                    if (this.field_70154_o == null && this.field_82153_h++ >= var2) {
                        this.field_82153_h = var2;
                        this.field_71088_bW = this.func_82147_ab();
                        int var3 = this.field_70170_p.field_73011_w.field_76574_g == -1 ? 0 : -1;
                        this.func_71027_c(var3);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT) {
            this.soundUpdater();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.rollingturnProgress > 0) {
                double var45 = this.field_70165_t + (this.rollingX - this.field_70165_t) / (double)this.rollingturnProgress;
                double var46 = this.field_70163_u + (this.rollingY - this.field_70163_u) / (double)this.rollingturnProgress;
                double var5 = this.field_70161_v + (this.rollingZ - this.field_70161_v) / (double)this.rollingturnProgress;
                double var7 = MathHelper.func_76138_g((double)(this.rollingYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)this.rotationYawClient;
                this.field_70125_A = (float)((double)this.field_70125_A + (this.rollingPitch - (double)this.field_70125_A) / (double)this.rollingturnProgress);
                --this.rollingturnProgress;
                this.func_70107_b(var45, var46, var5);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (BlockRailBase.func_72180_d_((World)this.field_70170_p, (int)i, (int)((j = MathHelper.func_76128_c((double)this.field_70163_u)) - 1), (int)(k = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            --j;
        }
        double d4 = 0.0078125;
        int l = this.field_70170_p.func_72798_a(i, j, k);
        if (this.canUseRail() && BlockRailBase.func_72184_d((int)l)) {
            int i1;
            Vec3 vec3d = this.func_514_g(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.meta = i1 = ((BlockRailBase)Block.field_71973_m[l]).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, i, j, k);
            this.field_70163_u = j;
            boolean flag = false;
            boolean flag1 = false;
            if (l == Block.field_71954_T.field_71990_ca) {
                flag = (this.field_70170_p.func_72805_g(i, j, k) & 8) != 0;
                boolean bl = flag1 = !flag;
                if (i1 == 8) {
                    i1 = 0;
                }
                if (i1 == 9) {
                    i1 = 1;
                }
            }
            if (i1 >= 2 && i1 <= 5) {
                this.field_70163_u = j + 1;
            }
            this.adjustSlopeVelocities(i1);
            int[][] ai = field_855_j[i1];
            double d9 = ai[1][0] - ai[0][0];
            double d10 = ai[1][2] - ai[0][2];
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            double d12 = this.field_70159_w * d9 + this.field_70179_y * d10;
            if (d12 < 0.0) {
                d9 = -d9;
                d10 = -d10;
            }
            double d13 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70159_w = d13 * d9 / d11;
            this.field_70179_y = d13 * d10 / d11;
            if (flag1 && this.shouldDoRailFunctions()) {
                double d16 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (d16 < 0.03) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                } else {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.0;
                    this.field_70179_y *= 0.5;
                }
            }
            double d17 = 0.0;
            double d18 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d19 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d20 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d21 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            d9 = d20 - d18;
            d10 = d21 - d19;
            if (d9 == 0.0) {
                this.field_70165_t = (double)i + 0.5;
                d17 = this.field_70161_v - (double)k;
            } else if (d10 == 0.0) {
                this.field_70161_v = (double)k + 0.5;
                d17 = this.field_70165_t - (double)i;
            } else {
                double d26;
                double d22 = this.field_70165_t - d18;
                double d24 = this.field_70161_v - d19;
                d17 = d26 = (d22 * d9 + d24 * d10) * 2.0;
                double derailSpeed = 0.46;
                if (this instanceof Locomotive && d13 > derailSpeed && i1 >= 6) {
                    if (d9 > 0.0 && d10 < 0.0) {
                        d10 *= 0.0;
                        d9 += 2.0;
                    } else if (d9 < 0.0 && d10 > 0.0) {
                        d9 = 0.0;
                        d10 += 2.0;
                    } else if (d10 < 0.0 && d9 < 0.0) {
                        d10 -= 2.0;
                        d9 = 0.0;
                    } else if (d9 > 0.0 && d10 > 0.0) {
                        d10 += 2.0;
                        d9 = 0.0;
                    }
                    if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_92062_k(((EntityPlayer)this.field_70153_n).field_71092_bJ + " derailed " + this.trainOwner + "'s locomotive");
                    }
                }
            }
            this.field_70165_t = d18 + d9 * d17;
            this.field_70161_v = d19 + d10 * d17;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M, this.field_70161_v);
            this.moveMinecartOnRail(i, j, k, 0.0);
            if (ai[0][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - i == ai[0][0] && MathHelper.func_76128_c((double)this.field_70161_v) - k == ai[0][2]) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)ai[0][1], this.field_70161_v);
            } else if (ai[1][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - i == ai[1][0] && MathHelper.func_76128_c((double)this.field_70161_v) - k == ai[1][2]) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)ai[1][1], this.field_70161_v);
            }
            this.applyDragAndPushForces();
            Vec3 vec3d1 = this.func_514_g(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (vec3d1 != null && vec3d != null) {
                double d14;
                double d28 = (vec3d.field_72448_b - vec3d1.field_72448_b) * 0.05;
                if (this instanceof Locomotive) {
                    d28 = 0.0;
                }
                if ((d14 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.0) {
                    this.field_70159_w = this.field_70159_w / d14 * (d14 + d28);
                    this.field_70179_y = this.field_70179_y / d14 * (d14 + d28);
                }
                this.func_70107_b(this.field_70165_t, vec3d1.field_72448_b, this.field_70161_v);
            }
            int k1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int l1 = MathHelper.func_76128_c((double)this.field_70161_v);
            if (k1 != i || l1 != k) {
                double d15 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                this.field_70159_w = d15 * (double)(k1 - i);
                this.field_70179_y = d15 * (double)(l1 - k);
            }
            if (this.shouldDoRailFunctions()) {
                ((BlockRailBase)Block.field_71973_m[l]).onMinecartPass(this.field_70170_p, (EntityMinecart)this, i, j, k);
            }
            if (flag && this.shouldDoRailFunctions()) {
                double d31 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (d31 > 0.01) {
                    double d32 = 0.06;
                    this.field_70159_w += this.field_70159_w / d31 * d32;
                    this.field_70179_y += this.field_70179_y / d31 * d32;
                } else if (i1 == 1) {
                    if (this.field_70170_p.func_72809_s(i - 1, j, k)) {
                        this.field_70159_w = 0.02;
                    } else if (this.field_70170_p.func_72809_s(i + 1, j, k)) {
                        this.field_70159_w = -0.02;
                    }
                } else if (i1 == 0) {
                    if (this.field_70170_p.func_72809_s(i, j, k - 1)) {
                        this.field_70179_y = 0.02;
                    } else if (this.field_70170_p.func_72809_s(i, j, k + 1)) {
                        this.field_70179_y = -0.02;
                    }
                }
            }
        } else {
            this.moveMinecartOffRail(i, j, k);
        }
        ++this.updateTicks;
        this.d6 = this.field_70169_q - this.field_70165_t;
        this.d7 = this.field_70166_s - this.field_70161_v;
        this.field_70125_A = 0.0f;
        if (this.d6 * this.d6 + this.d7 * this.d7 > 0.001) {
            this.field_70177_z = (float)(Math.atan2(this.d7, this.d6) * 180.0 / Math.PI);
            if (this.field_70499_f) {
                this.field_70177_z += 180.0f;
            }
        }
        if ((var49 = (double)MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B))) < -170.0 || var49 >= 170.0) {
            this.field_70177_z += 180.0f;
            this.field_70499_f = !this.field_70499_f;
        }
        float rotationYawServer = 0.0f;
        if (this.updateTicks % 5 == 0) {
            PacketHandler.sendPacketToClients(PacketHandler.setRotationPacket((Entity)this, this.field_70177_z), this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 400.0);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.cartLinked1 == null && this.Link1 != 0.0 || this.cartLinked2 == null && this.Link2 != 0.0) {
            AxisAlignedBB box2 = null;
            box2 = this.field_70121_D.func_72314_b(6.0, 6.0, 6.0);
            List lis = this.field_70170_p.func_72839_b((Entity)this, box2);
            if (lis != null && lis.size() > 0) {
                for (int j1 = 0; j1 < lis.size(); ++j1) {
                    Entity entity = (Entity)lis.get(j1);
                    if (!(entity instanceof AbstractTrains)) continue;
                    if ((double)((AbstractTrains)entity).getID() == this.Link1) {
                        this.cartLinked1 = (EntityRollingStock)entity;
                    }
                    if ((double)((AbstractTrains)entity).getID() != this.Link2) continue;
                    this.cartLinked2 = (EntityRollingStock)entity;
                }
            }
        }
        this.handleTrain();
        this.handleOverheating.HandleHeatLevel(this);
        this.linkhandler.handleStake((Entity)this, this.field_70121_D);
        this.collisionhandler.handleCollisions((Entity)this, this.field_70121_D);
        this.func_70017_D();
        MinecraftForge.EVENT_BUS.post((Event)new MinecartUpdateEvent((EntityMinecart)this, (float)i, (float)j, (float)k));
        this.setBoundingBoxSmall(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.98f, 0.7f);
        ++this.numLaps;
        if (this instanceof Locomotive) {
            int consumption = ((Locomotive)this).getFuelConsumption();
            if (this instanceof DieselTrain) {
                consumption /= 5;
            }
            if (this.numLaps >= consumption) {
                this.numLaps = 0;
                this.updateFuelTrain();
            }
        }
        ++this.numLaps2;
        if (this instanceof Locomotive && this.Link1 == 0.0 && this.Link2 == 0.0 && this.numLaps > 700) {
            this.numLaps2 = 0;
            this.RollingStock.clear();
        }
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            if (this.field_70153_n.field_70154_o == this) {
                this.field_70153_n.field_70154_o = null;
            }
            this.field_70153_n = null;
        }
        this.field_70180_af.func_75692_b(14, (Object)((int)(this.field_70159_w * 100.0)));
        this.field_70180_af.func_75692_b(21, (Object)((int)(this.field_70179_y * 100.0)));
    }

    protected void moveMinecartOffRail(int i, int j, int k) {
        double d2 = this.getMaxCartSpeedOnRail();
        if (!this.field_70122_E) {
            d2 = this.getMaxSpeedAirLateral();
        }
        if (this.field_70159_w < -d2) {
            this.field_70159_w = -d2;
        }
        if (this.field_70159_w > d2) {
            this.field_70159_w = d2;
        }
        if (this.field_70179_y < -d2) {
            this.field_70179_y = -d2;
        }
        if (this.field_70179_y > d2) {
            this.field_70179_y = d2;
        }
        double moveY = this.field_70181_x;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.field_70181_x > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.field_70159_w) < (double)0.3f && Math.abs(this.field_70179_y) < (double)0.3f) {
                this.field_70181_x = moveY = (double)0.15f;
            }
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(this.field_70159_w, moveY, this.field_70179_y);
        if (!this.field_70122_E) {
            this.field_70159_w *= this.getDragAir();
            this.field_70181_x *= this.getDragAir();
            this.field_70179_y *= this.getDragAir();
        }
    }

    public Vec3 func_514_g(double d, double d1, double d2) {
        int l;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)d);
        if (BlockRailBase.func_72180_d_((World)this.field_70170_p, (int)i, (int)((j = MathHelper.func_76128_c((double)d1)) - 1), (int)(k = MathHelper.func_76128_c((double)d2)))) {
            --j;
        }
        if (BlockRailBase.func_72184_d((int)(l = this.field_70170_p.func_72798_a(i, j, k)))) {
            int i1 = ((BlockRailBase)Block.field_71973_m[l]).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, i, j, k);
            d1 = j;
            if (l == Block.field_71954_T.field_71990_ca) {
                if (i1 == 8) {
                    i1 = 0;
                }
                if (i1 == 9) {
                    i1 = 1;
                }
            }
            if (i1 >= 2 && i1 <= 5) {
                d1 = j + 1;
            }
            int[][] ai = field_855_j[i1];
            double d3 = 0.0;
            double d4 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d5 = (double)j + 0.5 + (double)ai[0][1] * 0.5;
            double d6 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d7 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d8 = (double)j + 0.5 + (double)ai[1][1] * 0.5;
            double d9 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            double d10 = d7 - d4;
            double d11 = (d8 - d5) * 2.0;
            double d12 = d9 - d6;
            if (d10 == 0.0) {
                d = (double)i + 0.5;
                d3 = d2 - (double)k;
            } else if (d12 == 0.0) {
                d2 = (double)k + 0.5;
                d3 = d - (double)i;
            } else {
                double d15;
                double d13 = d - d4;
                double d14 = d2 - d6;
                d3 = d15 = (d13 * d10 + d14 * d12) * 2.0;
            }
            d = d4 + d10 * d3;
            d1 = d5 + d11 * d3;
            d2 = d6 + d12 * d3;
            if (d11 < 0.0) {
                d1 += 1.0;
            }
            if (d11 > 0.0) {
                d1 += 0.5;
            }
            return Vec3.field_82592_a.func_72345_a(d, d1, d2);
        }
        return null;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74780_a("speedLimiter", this.speedLimiter);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.speedLimiter = nbttagcompound.func_74769_h("speedLimiter");
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (super.func_70085_c(entityplayer)) {
            return true;
        }
        this.playerEntity = entityplayer;
        this.itemstack = entityplayer.field_71071_by.func_70448_g();
        if (this.itemstack != null && this.itemstack.func_77973_b() instanceof IToolCrowbar && this instanceof Locomotive && entityplayer.func_70093_af() && !this.field_70170_p.field_72995_K) {
            this.destination = "";
            entityplayer.func_71035_c("Destination reseted");
            return true;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, entityplayer))) {
            return true;
        }
        if (this.itemstack != null && this.itemstack.func_77942_o() && EntityRollingStock.getTicketDestination(this.itemstack) != null && EntityRollingStock.getTicketDestination(this.itemstack).length() > 0) {
            this.setDestination(this.itemstack);
            ItemStack ticket = GameRegistry.findItemStack((String)"Railcraft", (String)"railcraft.routing.ticket", (int)1);
            if (ticket != null && ticket.func_77973_b() != null && this.itemstack.func_77973_b().field_77779_bT == ticket.func_77973_b().field_77779_bT && this.itemstack != null && --this.itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, (ItemStack)null);
            }
            return true;
        }
        if (this.itemstack != null && this.itemstack.func_77973_b() instanceof ItemDye) {
            if (this.acceptedColors != null && this.acceptedColors.size() > 0) {
                for (int i = 0; i < this.acceptedColors.size(); ++i) {
                    if (this.itemstack.func_77960_j() != ((Integer)this.acceptedColors.get(i)).intValue()) continue;
                    this.setColor(this.itemstack.func_77960_j());
                    --this.itemstack.field_77994_a;
                    if (!this.field_70170_p.field_72995_K) {
                        this.statsEventHandler.trainPaint(this.uniqueID, this.trainName, this.trainType, this.trainCreator, entityplayer.field_71092_bJ, AbstractTrains.getColorAsString(this.itemstack.func_77960_j()), new String(this.field_70165_t + ";" + this.field_70163_u + ";" + this.field_70161_v));
                    }
                    return true;
                }
                if (this.field_70170_p.field_72995_K && ConfigHandler.SHOW_POSSIBLE_COLORS) {
                    String concatColors = ": ";
                    for (int t = 0; t < this.acceptedColors.size(); ++t) {
                        concatColors = concatColors.concat(AbstractTrains.getColorAsString((Integer)this.acceptedColors.get(t)) + ", ");
                    }
                    entityplayer.func_71035_c("Possible colors" + concatColors);
                    entityplayer.func_71035_c("To paint, click me with the right dye");
                    return true;
                }
            } else if (this.acceptedColors != null && this.acceptedColors.size() == 0) {
                entityplayer.func_71035_c("No other colors available");
            }
        } else if (this.trainsOnClick.onClickWithStake(this, this.itemstack, this.playerEntity, this.field_70170_p)) {
            return true;
        }
        return this.field_70170_p.field_72995_K;
    }

    @SideOnly(value=Side.CLIENT)
    private void soundUpdater() {
        if (FMLClientHandler.instance().getClient() != null) {
            this.theSoundManager = FMLClientHandler.instance().getClient().field_71416_A;
        }
        if (FMLClientHandler.instance().getClient() != null && this.theSoundManager != null && FMLClientHandler.instance().getClient().field_71439_g != null && this.sndUpdater != null) {
            this.sndUpdater.update(FMLClientHandler.instance().getClient().field_71416_A, this, (EntityPlayerSP)FMLClientHandler.instance().getClient().field_71439_g);
        }
    }

    public void func_70108_f(Entity par1Entity) {
    }

    public void func_70492_c(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    public int func_70491_i() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void func_70497_h(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void func_70494_i(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_75679_c(18);
    }

    @Override
    public boolean isLinkable() {
        return false;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        return true;
    }

    @Override
    public boolean hasTwoLinks() {
        return true;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        float dist = this.getOptimalDistance(cart) + 2.4f;
        return dist;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        float dist = this.getOptimalDistance(cart);
        return dist;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return true;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
        this.linked = true;
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
        this.linked = false;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    public ItemStack getCartItem() {
        return (ItemStack)this.getItemsDropped().get(0);
    }

    public boolean isPoweredCart() {
        return this.isLocomotive();
    }

    public boolean isStorageCart() {
        return this.isFreightCart();
    }

    public boolean canBeRidden() {
        return this.isLocomotive() || this.isPassenger() || this.isWorkCart();
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean use) {
        this.canUseRail = use;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    protected void applyDragAndPushForces() {
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    public double getDragAir() {
        return 0.98;
    }

    public void moveMinecartOnRail(int i, int j, int k, double d) {
        int id = this.field_70170_p.func_72798_a(i, j, k);
        if (!BlockRailBase.func_72184_d((int)id)) {
            return;
        }
        this.railMaxSpeed = ((BlockRailBase)Block.field_71973_m[id]).getRailMaxSpeed(this.field_70170_p, (EntityMinecart)this, i, j, k);
        this.maxSpeed = Math.min(this.railMaxSpeed, this.getMaxCartSpeedOnRail());
        this.maxSpeed = (float)this.speedhandler.handleSpeed(this.railMaxSpeed, this.maxSpeed, (Entity)this);
        if (this.speedLimiter != 0.0) {
            this.maxSpeed = (float)((double)this.maxSpeed * this.speedLimiter);
        }
        if (!this.isLocomotive()) {
            this.field_70159_w *= 0.99;
            this.field_70179_y *= 0.99;
        } else {
            this.field_70159_w *= 1.0;
            this.field_70179_y *= 1.0;
        }
        if (this.field_70159_w < (double)(-this.maxSpeed)) {
            this.field_70159_w = -this.maxSpeed;
        }
        if (this.field_70159_w > (double)this.maxSpeed) {
            this.field_70159_w = this.maxSpeed;
        }
        if (this.field_70179_y < (double)(-this.maxSpeed)) {
            this.field_70179_y = -this.maxSpeed;
        }
        if (this.field_70179_y > (double)this.maxSpeed) {
            this.field_70179_y = this.maxSpeed;
        }
        this.func_70091_d(this.field_70159_w, 0.0, this.field_70179_y);
    }

    protected void adjustSlopeVelocities(int i1) {
        if (this instanceof Locomotive) {
            return;
        }
        double d4 = 0.0058125;
        if (i1 == 2) {
            this.field_70159_w -= d4;
        }
        if (i1 == 3) {
            this.field_70159_w += d4;
        }
        if (i1 == 4) {
            this.field_70179_y += d4;
        }
        if (i1 == 5) {
            this.field_70179_y -= d4;
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        return entityplayer.func_70068_e((Entity)this) <= 300.0;
    }

    protected void updateFuelTrain() {
        if (this.fuelTrain < 0) {
            this.field_70159_w *= 0.8;
            this.field_70179_y *= 0.8;
        } else {
            --this.fuelTrain;
        }
    }

    public float getMaxCartSpeedOnRail() {
        return this.maxSpeed;
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    @Override
    public boolean canOverheat() {
        return false;
    }

    @Override
    public int getOverheatTime() {
        return 0;
    }

    public int getAverageOverheat() {
        return (this.getOverheatTime() + 30) / 2;
    }

    public void setOverheatLevel(int overheatLevel) {
        this.overheatLevel = overheatLevel;
        this.field_70180_af.func_75692_b(20, (Object)overheatLevel);
    }

    public int getOverheatLevel() {
        return this.field_70180_af.func_75679_c(20);
    }

    public double convertSpeed(Entity entity) {
        double speed = ((Locomotive)entity).getCustomSpeed();
        speed /= 6.0;
        return speed /= 10.0;
    }

    public int getMotionXClient() {
        return this.field_70180_af.func_75679_c(14);
    }

    public int getMotionZClient() {
        return this.field_70180_af.func_75679_c(21);
    }

    protected void func_70017_D() {
        int var6;
        int var5;
        int var4;
        int var3;
        int var2;
        int var1 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72340_a + 0.001));
        if (this.field_70170_p.func_72904_c(var1, var2 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72338_b + 0.001)), var3 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72339_c + 0.001)), var4 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72336_d - 0.001)), var5 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72337_e - 0.001)), var6 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72334_f - 0.001)))) {
            for (int var7 = var1; var7 <= var4; ++var7) {
                for (int var8 = var2; var8 <= var5; ++var8) {
                    for (int var9 = var3; var9 <= var6; ++var9) {
                        int var10 = this.field_70170_p.func_72798_a(var7, var8, var9);
                        if (var10 <= 0) continue;
                        Block.field_71973_m[var10].func_71869_a(this.field_70170_p, var7, var8, var9, (Entity)this);
                    }
                }
            }
        }
    }

    public void setBoundingBoxSmall(double par1, double par3, double par5, float width, float height) {
        float var7 = width / 2.0f;
        float var8 = height;
        this.boundingBoxSmall.func_72324_b(par1 - (double)var7, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - (double)var7, par1 + (double)var7, par3 - (double)this.field_70129_M + (double)this.field_70139_V + (double)var8, par5 + (double)var7);
    }

    public float getYaw() {
        return this.field_70177_z;
    }

    public float getPitch() {
        return this.field_70125_A;
    }

    public float getRoll() {
        return this.field_70177_z;
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public int func_94087_l() {
        return 0;
    }

    @Override
    public List getItemsDropped() {
        return null;
    }
}

