/*
 * Decompiled with CFR 0.152.
 */
package src.train.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.logging.Logger;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.world.World;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import src.train.common.api.LiquidManager;
import src.train.common.blocks.TCBlocks;
import src.train.common.core.CommonProxy;
import src.train.common.core.CreativeTabTraincraft;
import src.train.common.core.TrainModCore;
import src.train.common.core.handlers.AchievementHandler;
import src.train.common.core.handlers.ChunkHandler;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.core.handlers.CraftingHandler;
import src.train.common.core.handlers.EntityHandler;
import src.train.common.core.handlers.KeyServerHandler;
import src.train.common.core.handlers.OreHandler;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.core.handlers.PlayerTracker;
import src.train.common.core.handlers.RecipeHandler;
import src.train.common.generation.WorldGenWorld;
import src.train.common.items.TCItems;
import src.train.common.mysql.mysqlLogInterface;
import src.train.common.mysql.mysqlLogger;
import src.train.common.recipes.AssemblyTableRecipes;

@Mod(modid="TC", name="Traincraft", version="4.0.1_002")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, versionBounds="[4.0.1_002]", channels={"Traincraft"}, packetHandler=PacketHandler.class, connectionHandler=KeyServerHandler.class)
public class Traincraft {
    @Mod.Instance(value="TC")
    public static Traincraft instance;
    @SidedProxy(clientSide="src.train.client.core.ClientProxy", serverSide="src.train.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger tcLog;
    public static CreativeTabs tcTab;
    public EnumArmorMaterial armor = EnumHelper.addArmorMaterial((String)"Armor", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)25);
    public EnumArmorMaterial armorCloth = EnumHelper.addArmorMaterial((String)"TCcloth", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)25);
    public EnumArmorMaterial armorCompositeSuit = EnumHelper.addArmorMaterial((String)"TCsuit", (int)70, (int[])new int[]{5, 12, 8, 5}, (int)50);
    public static int trainArmor;
    public static int trainCloth;
    public static int trainCompositeSuit;
    private mysqlLogInterface logMysql = new mysqlLogger();
    public static boolean mysqlLoggerEnabled;

    public static boolean isHost(World world) {
        return !world.field_72995_K;
    }

    public static boolean isNotHost(World world) {
        return world.field_72995_K;
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        proxy.registerSounds();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)ChunkHandler.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)ChunkHandler.getInstance());
        tcLog.setParent(FMLLog.getLogger());
        tcLog.info("Starting Traincraft 4.0.1_002!");
        ConfigHandler.init(new File(event.getModConfigurationDirectory(), "Traincraft.cfg"));
        proxy.getKeysFromProperties();
        proxy.registerKeyBindingHandler();
        proxy.registerTileEntities();
        EntityHandler.init();
        proxy.registerRenderInformation();
        trainArmor = proxy.addArmor("armor");
        trainCloth = proxy.addArmor("Paintable");
        trainCompositeSuit = proxy.addArmor("CompositeSuit");
        tcTab = new CreativeTabTraincraft(CreativeTabs.getNextID(), "Traincraft");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenWorld());
        GameRegistry.registerPlayerTracker((IPlayerTracker)new PlayerTracker());
        TrainModCore.RegisterNewTracks();
        TCBlocks.init();
        TCItems.init();
        AchievementHandler.load();
        proxy.localizations();
        AchievementPage.registerAchievementPage((AchievementPage)AchievementHandler.tmPage);
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        GameRegistry.registerCraftingHandler((ICraftingHandler)new CraftingHandler());
        OreHandler.registerOres();
        RecipeHandler.initBlockRecipes();
        RecipeHandler.initItemRecipes();
        AssemblyTableRecipes.recipes();
        LiquidManager.getInstance().registerLiquids();
        proxy.registerTextureFX();
        if (ConfigHandler.MYSQL_ENABLE) {
            mysqlLoggerEnabled = this.logMysql.enableLogger();
        }
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        TrainModCore.ModsLoaded();
        LiquidManager.getLiquidsFromDictionnary();
    }

    static {
        tcLog = Logger.getLogger("TC");
    }
}

