/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import src.train.client.render.RenderEnum;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.Locomotive;
import src.train.common.entity.rollingStock.EntityTracksBuilder;

@SideOnly(value=Side.CLIENT)
public class RenderRollingStock
extends Render {
    private Random random = new Random();
    private double serverYaw = 0.0;

    public RenderRollingStock() {
        this.field_76989_e = 0.5f;
    }

    public void renderTheMinecart(EntityRollingStock cart, double x, double y, double z, float yaw, float time) {
        GL11.glPushMatrix();
        long var10 = (long)cart.field_70157_k * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float var12 = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float var13 = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float var14 = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GL11.glTranslatef((float)var12, (float)var13, (float)var14);
        double var15 = cart.field_70142_S + (cart.field_70165_t - cart.field_70142_S) * (double)time;
        double var17 = cart.field_70137_T + (cart.field_70163_u - cart.field_70137_T) * (double)time;
        double var19 = cart.field_70136_U + (cart.field_70161_v - cart.field_70136_U) * (double)time;
        double var21 = 0.3f;
        Vec3 var23 = cart.func_70489_a(var15, var17, var19);
        float pitch = cart.field_70127_C + (cart.field_70125_A - cart.field_70127_C) * time;
        if (var23 != null) {
            Vec3 var25 = cart.func_70495_a(var15, var17, var19, var21);
            Vec3 var26 = cart.func_70495_a(var15, var17, var19, -var21);
            if (var25 == null) {
                var25 = var23;
            }
            if (var26 == null) {
                var26 = var23;
            }
            x += var23.field_72450_a - var15;
            y += (var25.field_72448_b + var26.field_72448_b) / 2.0 - var17;
            z += var23.field_72449_c - var19;
            Vec3 var27 = var26.func_72441_c(-var25.field_72450_a, -var25.field_72448_b, -var25.field_72449_c);
            if (var27.func_72433_c() != 0.0) {
                var27 = var27.func_72432_b();
                yaw = (float)(Math.atan2(var27.field_72449_c, var27.field_72450_a) / Math.PI) * 180.0f;
                pitch = (float)(Math.atan(var27.field_72448_b) * 73.0);
            }
        }
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        yaw += 360.0f;
        this.serverYaw = cart.field_70177_z;
        this.serverYaw += 180.0;
        this.serverYaw %= 360.0;
        if (this.serverYaw < 0.0) {
            this.serverYaw += 360.0;
        }
        this.serverYaw += 360.0;
        if (Math.abs((double)yaw - this.serverYaw) > 90.0) {
            yaw += 180.0f;
            pitch = -pitch;
        }
        cart.setRenderYaw(yaw);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        float var28 = (float)cart.func_70496_j() - time;
        float var30 = (float)cart.func_70491_i() - time;
        if (var30 < 0.0f) {
            var30 = 0.0f;
        }
        if (var28 > 0.0f) {
            float angle = MathHelper.func_76126_a((float)var28) * var28 * var30 / 10.0f;
            angle = Math.min(angle, 0.8f);
            angle = Math.copySign(angle, cart.func_70493_k());
            GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        for (RenderEnum renders : RenderEnum.values()) {
            if (renders.getEntityClass() == null || !renders.getEntityClass().equals(cart.getClass())) continue;
            this.func_76985_a(this.getTextureFile(renders.getTexture(), renders.getIsMultiTextured(), cart));
            GL11.glTranslatef((float)renders.getTrans()[0], (float)renders.getTrans()[1], (float)renders.getTrans()[2]);
            if (renders.getRotate() != null) {
                GL11.glRotatef((float)renders.getRotate()[0], (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)renders.getRotate()[1], (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)renders.getRotate()[2], (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (renders.getScale() != null) {
                GL11.glScalef((float)renders.getScale()[0], (float)renders.getScale()[1], (float)renders.getScale()[2]);
            }
            renders.getModel().func_78088_a((Entity)cart, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            if (renders.hasSmoke()) {
                this.renderSmokeFX(cart, yaw, pitch, renders.getSmokeType(), renders.getSmokeFX(), renders.getSmokeIterations(), time);
            }
            if (!renders.hasExplosion()) continue;
            this.renderExplosionFX(cart, yaw, pitch, renders.getExplosionType(), renders.getExplosionFX(), renders.getExplosionFXIterations());
        }
        GL11.glPopMatrix();
    }

    private String getTextureFile(String texture, boolean multiTexture, EntityRollingStock cart) {
        if (multiTexture) {
            return "/src/train/Resources/Trains/" + texture + cart.getColorAsString() + ".png";
        }
        return "/src/train/Resources/Trains/" + texture + ".png";
    }

    private void renderSmokeFX(EntityRollingStock cart, float yaw, float pitch, String smokeType, ArrayList smokeFX, int smokeIterations, float time) {
        double rads = (double)yaw * Math.PI / 180.0;
        double pitchRads = (double)pitch * Math.PI / 180.0;
        if (cart instanceof Locomotive && ((Locomotive)cart).getFuel() > 0 || cart instanceof EntityTracksBuilder && ((EntityTracksBuilder)cart).getFuel() > 0) {
            int r = this.random.nextInt(10 * smokeIterations);
            double spread = this.random.nextDouble() * 0.1 - this.random.nextDouble() * 0.1;
            if (spread >= 1.0) {
                spread -= 1.0;
            } else if (spread <= -1.0) {
                spread += 1.0;
            }
            double speed = 0.0;
            if (cart instanceof Locomotive) {
                speed = ((Locomotive)cart).getSpeed();
            }
            if ((double)r < (double)(smokeIterations * 4) + speed * 5.0) {
                for (int j = 0; j < smokeIterations; ++j) {
                    float x = (float)cart.field_70165_t + this.random.nextFloat() * 0.2f;
                    float z = (float)cart.field_70161_v + this.random.nextFloat() * 0.2f;
                    double yCorrectDown = 0.0;
                    double xCorrect = 0.0;
                    double zCorrect = 0.0;
                    for (int i = 0; i < smokeFX.size(); ++i) {
                        if (pitchRads < 0.0) {
                            yCorrectDown = Math.tan(pitchRads);
                        }
                        if (((double[])smokeFX.get(i))[0] < 0.0) {
                            yCorrectDown = Math.tan(-pitchRads);
                        }
                        xCorrect = Math.cos(rads) * (Math.tan(-pitchRads) * ((double[])smokeFX.get(i))[1]);
                        zCorrect = Math.sin(rads) * (Math.tan(-pitchRads) * ((double[])smokeFX.get(i))[1]);
                        cart.field_70170_p.func_72869_a(smokeType, (double)x + Math.cos(rads) * ((double[])smokeFX.get(i))[0] + xCorrect, cart.field_70163_u + ((double[])smokeFX.get(i))[1] + Math.tan(pitchRads) * ((double[])smokeFX.get(i))[1] / 4.0 + yCorrectDown, (double)z + Math.sin(rads) * ((double[])smokeFX.get(i))[0] + zCorrect, spread, Math.abs(spread), spread);
                    }
                }
            }
        }
    }

    private void renderExplosionFX(EntityRollingStock cart, float yaw, float pitch, String explosionType, ArrayList explosionFX, int explosionFXIterations) {
        int r;
        float yawMod = yaw % 360.0f;
        double rads = (double)yaw * Math.PI / 180.0;
        double pitchRads = (double)pitch * Math.PI / 180.0;
        if (cart instanceof Locomotive && ((Locomotive)cart).getFuel() > 0 && (r = this.random.nextInt(300)) < explosionFXIterations * 10) {
            for (int j = 0; j < explosionFXIterations; ++j) {
                int i;
                if (yawMod == 180.0f) {
                    for (i = 0; i < explosionFX.size(); ++i) {
                        cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t - ((double[])explosionFX.get(i))[0], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v + ((double[])explosionFX.get(i))[2], 0.0, 0.0, 0.0);
                        cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t - ((double[])explosionFX.get(i))[0], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v - ((double[])explosionFX.get(i))[2], 0.0, 0.0, 0.0);
                    }
                    continue;
                }
                if (yawMod == 90.0f) {
                    for (i = 0; i < explosionFX.size(); ++i) {
                        cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t + ((double[])explosionFX.get(i))[2], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v + ((double[])explosionFX.get(i))[0], 0.0, 0.0, 0.0);
                        cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t - ((double[])explosionFX.get(i))[2], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v + ((double[])explosionFX.get(i))[0], 0.0, 0.0, 0.0);
                    }
                    continue;
                }
                if (yawMod == 0.0f) {
                    for (i = 0; i < explosionFX.size(); ++i) {
                        cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t + ((double[])explosionFX.get(i))[0], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v + ((double[])explosionFX.get(i))[2], 0.0, 0.0, 0.0);
                        cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t + ((double[])explosionFX.get(i))[0], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v - ((double[])explosionFX.get(i))[2], 0.0, 0.0, 0.0);
                    }
                    continue;
                }
                if (yawMod != 270.0f) continue;
                for (i = 0; i < explosionFX.size(); ++i) {
                    cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t + ((double[])explosionFX.get(i))[2], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v - ((double[])explosionFX.get(i))[0], 0.0, 0.0, 0.0);
                    cart.field_70170_p.func_72869_a(explosionType, cart.field_70165_t - ((double[])explosionFX.get(i))[2], cart.field_70163_u + ((double[])explosionFX.get(i))[1] + Math.tan(pitchRads) * -((double[])explosionFX.get(i))[1] * 6.0, cart.field_70161_v - ((double[])explosionFX.get(i))[0], 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void func_76986_a(Entity par1Entity, double x, double y, double d2, float yaw, float time) {
        this.renderTheMinecart((EntityRollingStock)par1Entity, x, y, d2, yaw, time);
    }
}

