/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.gui.sideTabs;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;
import src.train.client.core.helpers.SessionHelper;
import src.train.client.gui.GuiCrafterTier;

@SideOnly(value=Side.CLIENT)
public abstract class SideTab {
    private boolean open;
    private boolean openX;
    private boolean openY;
    protected boolean side;
    protected int overlayColor = 0xFFFFFF;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected int limitWidth = 128;
    protected int maxWidth = 124;
    protected int minWidth;
    protected int currentWidth = this.minWidth = 24;
    protected int maxHeight = 24;
    protected int minHeight;
    protected int currentHeight = this.minHeight = 24;
    public GuiCrafterTier gui;
    protected static FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
    protected static SoundManager soundManager = FMLClientHandler.instance().getClient().field_71416_A;

    public SideTab(GuiCrafterTier gui, boolean side, boolean x, boolean y) {
        this.gui = gui;
        this.openX = x;
        this.openY = y;
        this.side = side;
    }

    public void update() {
        int offset = 2;
        if (this.openX && this.openY || !this.openX && !this.openY) {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += offset;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= offset;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += offset;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= offset;
            }
        } else if (this.openX && !this.openY) {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += offset;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= offset;
            }
        } else if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += offset;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= offset;
        }
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public abstract void draw(int var1, int var2);

    public abstract String getTooltip();

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.side ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight() : mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionHelper.setOpenedLedger(null);
        } else {
            this.open = true;
            SessionHelper.setOpenedLedger(this.getClass());
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    public void drawBackground(int x, int y) {
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        if (this.side) {
            String texture = "/src/train/Resources/GUI/sideTab_left.png";
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b(texture);
            this.gui.func_73729_b(x + 24 - this.currentWidth, y + 2, 0, 256 - this.currentHeight + 2, 4, this.currentHeight - 2);
            this.gui.func_73729_b(x + 28 - this.currentWidth, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.gui.func_73729_b(x + 24 - this.currentWidth, y, 0, 0, 4, 4);
            this.gui.func_73729_b(x + 28 - this.currentWidth, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            String texture = "/src/train/Resources/GUI/sideTab_right.png";
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b(texture);
            this.gui.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            this.gui.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.gui.func_73729_b(x, y, 0, 0, 4, 4);
            this.gui.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawIcon(String texture, int iconIndex, int x, int y) {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b(texture);
        if (this.side) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textureRow = iconIndex >> 4;
            int textureColumn = iconIndex - 16 * textureRow;
            this.gui.func_73729_b(x + 24 - this.currentWidth, y, 16 * textureColumn, 16 * textureRow, 16, 16);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textureRow = iconIndex >> 4;
            int textureColumn = iconIndex - 16 * textureRow;
            this.gui.func_73729_b(x, y, 16 * textureColumn, 16 * textureRow, 16, 16);
        }
    }
}

