/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.src.ModLoader;
import org.lwjgl.opengl.GL11;
import src.train.common.api.DieselTrain;
import src.train.common.api.Locomotive;
import src.train.common.api.SteamTrain;

public class HUDloco
extends GuiScreen {
    private Minecraft game;
    private int windowWidth;
    private int wave = 0;
    private int windowHeight;
    private int sizeX = 137;
    private int sizeY = 90;
    private int j;
    private int k;

    public HUDloco(Minecraft game) {
        this.game = game;
        this.field_73886_k = ModLoader.getMinecraftInstance().field_71466_p;
    }

    public void renderSkillHUD(Locomotive rcCar) {
        this.windowWidth = new ScaledResolution(this.game.field_71474_y, this.game.field_71443_c, this.game.field_71440_d).func_78326_a();
        this.windowHeight = new ScaledResolution(this.game.field_71474_y, this.game.field_71443_c, this.game.field_71440_d).func_78328_b();
        this.j = (this.windowWidth - this.sizeX) / 2;
        this.k = (this.windowHeight - this.sizeY) / 2;
        this.renderText(rcCar);
        this.renderBG(rcCar);
        if (rcCar instanceof SteamTrain) {
            this.renderWaterBar(rcCar);
        }
        if (rcCar.canOverheat()) {
            this.renderOverheating(rcCar);
        }
        this.renderSpeedometer(rcCar);
        this.renderFuelBar(rcCar);
    }

    private void renderBG(Locomotive rcCar) {
        this.game = ModLoader.getMinecraftInstance();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        this.field_73735_i = -90.0f;
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (rcCar instanceof SteamTrain) {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/loco_hud_steam.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/locohud.png"));
        }
        this.func_73729_b(0, this.windowHeight / 2 - 0, 0, 150, 137, 90);
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderText(Locomotive loco) {
        double speed = loco.getSpeed();
        int h = loco instanceof SteamTrain ? 15 : 13;
        this.field_73886_k.func_78261_a("Speed:", 96, this.windowHeight / 2 + 7 + h, 0xFFFFFF);
        this.field_73886_k.func_78261_a("  " + (int)Math.abs((float)speed) + "", 96, this.windowHeight / 2 + 18 + h, 0xFFFFFF);
        this.field_73886_k.func_78261_a(" Km/h", 96, this.windowHeight / 2 + 29 + h, 0xFFFFFF);
        if (loco.canOverheat()) {
            this.field_73886_k.func_78261_a("State: " + loco.getState(), 40, this.windowHeight / 2 + 80, 0xFFFFFF);
        }
    }

    private void renderFuelBar(Locomotive loco) {
        int l;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (loco instanceof DieselTrain) {
            l = ((DieselTrain)loco).getDiesel();
            l = Math.abs(l * 70 / ((DieselTrain)loco).getCartTankCapacity());
        } else {
            l = loco.getFuelDiv(70);
        }
        if (l > 70) {
            l = 70;
        }
        if (l < 0) {
            l = 0;
        }
        int t = 70 - l;
        if (loco instanceof SteamTrain) {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/loco_hud_steam.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/locohud.png"));
        }
        if (!(loco instanceof SteamTrain)) {
            this.func_73729_b(18, this.windowHeight / 2 + 11, 148, 150 + l, 7, t);
        } else {
            this.func_73729_b(24, this.windowHeight / 2 + 17, 154, 170 + l, 9, t);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWaterBar(Locomotive loco) {
        int l = ((SteamTrain)loco).getWater();
        int l_Scaled = Math.abs(l * 49 / ((SteamTrain)loco).getCartTankCapacity());
        if (l_Scaled > 49) {
            l_Scaled = 49;
        }
        if (l_Scaled < 0) {
            l_Scaled = 0;
        }
        int t = 49 - l_Scaled;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(60, this.windowHeight / 2 + 17, 190, 169 + l_Scaled, 6, t);
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        if (l <= 1 && loco.getIsFuelled()) {
            this.func_73733_a(0, 0, this.windowWidth, this.windowHeight, 0x60500000, -1602211792);
        }
    }

    private void renderSpeedometer(Locomotive loco) {
        double speed = loco.getSpeed();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (loco instanceof SteamTrain) {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/loco_hud_steam.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/locohud.png"));
        }
        double speedScaled = Math.abs(speed * 49.0 / 280.0);
        if (speedScaled > 49.0) {
            speedScaled = 49.0;
        }
        if (!(loco instanceof SteamTrain)) {
            this.func_73729_b(65, this.windowHeight / 2 + 37 - (int)speedScaled + 20, 163, 150, 30, 5);
        } else {
            this.func_73729_b(74, this.windowHeight / 2 + 37 - (int)speedScaled + 20, 177, 149, 16, 8);
        }
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderOverheating(Locomotive loco) {
        double overheatLevel = loco.getOverheatLevel();
        if (overheatLevel > (double)(loco.getOverheatTime() + 30)) {
            overheatLevel = loco.getOverheatTime() + 30;
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (loco instanceof SteamTrain) {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/loco_hud_steam.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.game.field_71446_o.func_78341_b("/src/train/Resources/GUI/locohud.png"));
        }
        double overheatScaled = Math.abs(overheatLevel * 49.0 / (double)(loco.getOverheatTime() + 30));
        if (overheatScaled > 49.0) {
            overheatScaled = 49.0;
        }
        int t = (int)(49.0 - overheatScaled);
        if (!(loco instanceof SteamTrain)) {
            this.func_73729_b(48, this.windowHeight / 2 + 37 - (int)overheatScaled + 20, 169, 158, 23, 5);
        } else {
            this.func_73729_b(46, this.windowHeight / 2 + 17, 176, (int)(169.0 + overheatScaled), 5, t);
        }
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void func_73874_b() {
    }
}

