/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import src.train.client.core.handlers.RecipeBookHandler;
import src.train.client.gui.GuiButtonNextPage;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.core.managers.TierRecipe;
import src.train.common.core.managers.TierRecipeManager;
import src.train.common.inventory.TrainCraftingManager;
import src.train.common.items.ItemRollingStock;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;
import src.train.common.recipes.ShapedTrainRecipes;
import src.train.common.recipes.ShapelessTrainRecipe;

@SideOnly(value=Side.CLIENT)
public class GuiRecipeBook
extends GuiScreen {
    private final EntityPlayer editingPlayer;
    private final ItemStack itemstackBook;
    private int bookImageWidth = 206;
    private int bookImageHeight = 200;
    public static int bookTotalPages = 100;
    private int currPage;
    private int currRecipe;
    public ArrayList leftPage = new ArrayList();
    public ArrayList leftPageImage = new ArrayList();
    public ArrayList leftPageItemStacks = new ArrayList();
    public ArrayList rightPage = new ArrayList();
    public ArrayList rightPageImage = new ArrayList();
    public ArrayList rightPageItemStacks = new ArrayList();
    private List recipeListWB = RecipeBookHandler.workbenchListCleaner(TrainCraftingManager.getInstance().getRecipeList());
    private List recipeList = RecipeBookHandler.assemblyListCleaner(TierRecipeManager.getInstance().getRecipeList());
    private GuiButtonNextPage buttonRead;
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private GuiButtonNextPage buttonBack;
    private RenderItem renderItem = new RenderItem();

    public GuiRecipeBook(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack) {
        this.editingPlayer = par1EntityPlayer;
        this.itemstackBook = par2ItemStack;
        NBTTagCompound var3 = this.itemstackBook.func_77978_p();
        this.currPage = this.itemstackBook.func_77978_p().func_74762_e("currPage");
        this.currRecipe = this.itemstackBook.func_77978_p().func_74762_e("currRecipe");
        this.addPage("", "", "left", null);
        this.addPage("", "", "right", null);
        this.addPage("Welcome to the Traincraft guide! \n \nThis book contains everything you need to know about Traincraft.\nAuthors: Spitfire4466, Mrbrutal\nBukkit port: DV8FromTheWorld.\n\nModelers: DAYdiecast, helldiver, BlockStormTwo, ChandlerBingUA.\nThanks to CovertJaguar for his help and a great API.\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoBR80_DB.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(BlockIDs.trainWorkbench.block), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartCabooseWork.item), 60, 175));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartTankWagon_DB.item), 80, 175));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFlatCartRail_DB.item), 100, 175));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWagon_DB.item), 120, 175));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartPassengerBlue.item), 140, 175));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartV60_DB.item), 160, 175));
            }
        });
        this.addPage("World generation:\n\n By default, petrol and oil sands will be generated in the world. If you don't want them, open Traincraft.cfg and change the line ENABLE_ORE_SPAWN from true to false.Only the new ores will generate, the old ones can be transformed into the new ones in a crafting table.", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(BlockIDs.OreTC.block, 1, 1), 60, 150));
                this.add(new StackToDraw(new ItemStack(BlockIDs.OreTC.block, 1, 2), 120, 150));
            }
        });
        this.addPage("Keys:\nTo interact with the trains (e.g. enter/leave, display the inventory) click above the shadow the train is casting on the ground.\nInside the locomotive press R to open up the GUI: This is where you can put fuel, water, additional cargo, set brakes, etc.\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Item.field_77705_m), 60, 160));
                this.add(new StackToDraw(new ItemStack(Item.field_77786_ax), 120, 160));
            }
        });
        this.addPage("Use the W and S keys to move the locomotive forwards or backwards, respectively.\nPress H in the locomotive to activate the whistle.\nIn the Work Carts, press R to open up the Crafting Table and F for the Furnace.\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoBR80_DB.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartGP7Red.item), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoCherepanov.item), 40, 145));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartWork.item), 60, 145));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartCabooseWork.item), 80, 145));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoForneyRed.item), 100, 145));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartShunter.item), 120, 145));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoBR01_DB.item), 140, 145));
            }
        });
        this.addPage("Zeppelin:\nRight click on the Zeppelin to enter/leave it. \nInside, press R to open its GUI. \nUse the WASD keys to move the zeppelin around. \nPress once Y to ascend or X to descend, To lock altitude, press C. \n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.zeppelin.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.balloon.item), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.propeller.item), 40, 135));
                this.add(new StackToDraw(new ItemStack(ItemIDs.steamengine.item), 60, 135));
                this.add(new StackToDraw(new ItemStack(Item.field_77769_aE), 120, 135));
                this.add(new StackToDraw(new ItemStack(Item.field_77669_D), 140, 135));
            }
        });
        this.addPage("Fuel:\nSteam locomotives need coal and water.\nTenders can only hold coal and water. Attach them to a steam locomotive, they will provide fuel and water for the loco.\nDiesel locos need diesel canisters (from distillation tower) or fuel from BC and Forestry.\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartTender.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocomogulBlue.item), 170, 16));
                this.add(new StackToDraw(new ItemStack(Item.field_77705_m), 40, 155));
                this.add(new StackToDraw(new ItemStack(Item.field_77786_ax), 60, 155));
                this.add(new StackToDraw(new ItemStack(Block.field_71988_x), 80, 155));
                this.add(new StackToDraw(new ItemStack(Item.field_77731_bo), 100, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.diesel.item), 120, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.refinedFuel.item), 140, 155));
            }
        });
        this.addPage("Electric locomotives need redstone or Re-Batteries, the can also be powered by Electric tracks (requires Universal Electricity).\n\nHeat:\nHeat level is indicated by the heat bar in the HUD.\nHeat level will go to a normal state when the train is fueled but don't forget to put water in steam locomotive or it will overheat very fast.\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBR_E69.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(Item.field_77767_aC), 170, 16));
            }
        });
        this.addPage("Heat level will go down to cold when there is no more fuel:\nWait until the locomotive has heated up before trying to move.\nBe carefull, overheating will cause explosions...\n\nRouting:\nTC locomotives can be routed using Railcraft routing track. Destination will show in the GUI. There is no space for tickets in the GUI. Not 'Color=' compatible. Sneak+Crowbar to reset 'Dest:'", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.firebox.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(Block.field_72091_am), 170, 16));
            }
        });
        this.addPage("Minecraft Horse Power - Mhp:\n\nLocomotives have different pulling abilities represented by their 'power' in Mhp.\nEach cart has a mass in tons which will affect the locomotive depending on its power.\nMass pulled affects the maximum speed, the brake rate and accelerate rate, as well as fuel consumption.\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoBR01_DB.item), 40, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 60, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightCart2.item), 80, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 100, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightClosed.item), 120, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 140, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartWatertransp.item), 160, 165));
            }
        });
        this.addPage("Derailment:\n\nDo not go too fast on turns or your locomotives will derail!\n\nIt is recommended to slow down under 90km/h before turning or you will find yourself crashing off tracks.", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Item.field_82799_bQ, 1, 1), 20, 16));
            }
        });
        this.addPage("Pulling:\nRight click both carts with a stake in your hand, it will say 'Attaching mode on', then make them collide and it will say 'Attached'.\nLocomotives have pulling capabilities, don't make too long trains with weak locomotives. Stats of the locomotive will be affected. (they can be seen on the top left corner when you open the locomotive's inventory).\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartCaboose.item), 40, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 60, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBoxCartUS.item), 80, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 100, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFlatCartLogs_DB.item), 120, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 140, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartGP40alaska.item), 160, 165));
            }
        });
        this.addPage("Chunk Loading:\n\nEach rolling stock can load one chunk around itself.\nTo start chunk loading, right click with chunk loader activator on the rolling stock.\nTo stop chunk loading, right click again.\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.chunkLoaderActivator.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(Item.field_77730_bn), 170, 16));
            }
        });
        this.addPage("Colors:\n\nSome rolling stock has several textures and can be painted with dyes.\nThe rolling stock that can be painted will show the possible colors in the chat once placed in the world.\nTo paint, simply right click with the correct dye.\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Item.field_77756_aW, 1, 1), 20, 16));
                this.add(new StackToDraw(new ItemStack(Item.field_77756_aW, 1, 11), 170, 16));
            }
        });
        this.addPage("Stock car:\n\nThe stock car is the only rolling stock that can be ridden by any animals and mobs.\nTo fill the stock car, either collide the animal with the car or use the animal/mob boarding tracks (Railcraft required).\nTo empty the car, right click it (bare hand) or use the disembark track (Railcraft required).\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartStockCar.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(Item.field_82799_bQ, 1, 4), 170, 16));
            }
        });
        this.addPage("A word about tracks I:\nCopper tracks will slows trains down.\nSteel tracks allow trains to go faster.\nSpeed controller track allows to change the locomotive's max speed (hit with crowbar).\nThe energy track can be plugged to UE network and will power electric trains, energy will flow wirelessly. To tune frequency hit with bare hand.\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 16));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 32));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 48));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 64));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 80));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 96));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 112));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 128));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 144));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 17, 160));
                this.add(new StackToDraw(new ItemStack(Block.field_71954_T), 170, 16));
            }
        });
        this.addPage("A word about tracks II:\nTo check the current charge click it with a crowbar.\nOne track connected to UE network will provide wireless power 50 blocks away in any direction. Tracks have to be on the same frequency to receive power obviously.\nLocomotive holding track will only hold TC locomotives. No boost is given, the previous speed is restored once released.\nAll tracks require Railcraft to be installed.", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Block.field_94337_cv), 17, 16));
                this.add(new StackToDraw(new ItemStack(Block.field_71954_T), 170, 16));
            }
        });
        this.addPage("Steel rails parts and copper rails parts are crafted inside RC Rolling Machine, tracks are assembled in vanilla workbench.\nTC boarding/disembarking track are designed to work only on the Stock Car. Animal boarding will take any nearby animal and put it inside a passing Stock Car. Mob boarding will affect any mob.\nDisembark will eject any mob inside the Stock Car.", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Block.field_71953_U), 17, 16));
                this.add(new StackToDraw(new ItemStack(Block.field_71954_T), 170, 16));
            }
        });
        this.addPage("Builder I:\n\nThe tracks builder has a very special inventory, in order to start it you must provide:\nBallast in the slot under it (planks, gravel, stone, ...).\nCoal in the fuel slot, Tracks in the slot under the fuel slot.The slot on the right of the builder will activate tunnel function when provided (not all blocks are accepted).\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBuilder.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBuilder.item), 60, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 80, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightClosed.item), 100, 165));
            }
        });
        this.addPage("Builder II:\n\nThe slots on top of the builder are roof slots, the builder will build a roof when provided (not all blocks are accepted).If you attach a freight cart to the builder, it will dump things in it.\n\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBuilder.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBuilder.item), 60, 125));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 80, 125));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightClosed.item), 100, 125));
            }
        });
        this.addPage("Limitations:\n\nVERY IMPORTANT:\nLong trains imply limitations: Do not try to make sharp 180 turns, leave 6 spaces between each 90 turn. Otherwise weird stuff will happen especially with SD70 and very long carts.\n\nAlways PULL carts!, bounding boxes are bugged <=> push is crapy !", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Block.field_71953_U), 20, 16));
                this.add(new StackToDraw(new ItemStack(Block.field_72056_aG), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartPower.item), 40, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFlatCartWoodUS.item), 60, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBoxCartUS.item), 80, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartPassenger9_2class_DB.item), 100, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFlatCartLogs_DB.item), 120, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightCart2.item), 140, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartCaboose.item), 160, 165));
            }
        });
        this.addPage("Crafting:\nAll train parts are crafted in the train workbench,\n\nthen trains have to be assembled in the assembly tables.\n\nThere are three assembly tables:\n\nTierI - Iron age\nTierII - Steel age\nTierIII - Advanced age\n", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(BlockIDs.trainWorkbench.block), 20, 16));
                this.add(new StackToDraw(new ItemStack(BlockIDs.assemblyTableI.block), 40, 165));
                this.add(new StackToDraw(new ItemStack(BlockIDs.assemblyTableII.block), 80, 165));
                this.add(new StackToDraw(new ItemStack(BlockIDs.assemblyTableIII.block), 140, 165));
            }
        });
        this.addPage("Crafting steel:\nSteel is now crafted in Open Hearth Furnace, supply iron ingots and graphite in the top slots, fuel in the bottom slot \nand it will cook slowly into steel.\nYou can also use steel from other mods or use this steel in other mods.\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(BlockIDs.openFurnaceIdle.block), 20, 16));
                this.add(new StackToDraw(new ItemStack(BlockIDs.openFurnaceActive.block), 80, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.graphite.item), 70, 135));
                this.add(new StackToDraw(new ItemStack(Item.field_77703_o), 90, 135));
                this.add(new StackToDraw(new ItemStack(Item.field_77705_m), 80, 175));
                this.add(new StackToDraw(new ItemStack(ItemIDs.steel.item), 120, 155));
            }
        });
        this.addPage("Making diesel:\nDiesel is made in a distillation tower using petroleum or oil sands found in the world.\nInsert petroleum in the top slot and fuel in the bottom slot, also try reed.\nIt will cook into liquid diesel and give you plastic with a random chance depending on the input.\nTo get diesel into canisters, you must first craft them using plastic. Then put an empty one in the top right slot.", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(BlockIDs.distilIdle.block), 20, 16));
                this.add(new StackToDraw(new ItemStack(BlockIDs.distilActive.block), 150, 40));
                this.add(new StackToDraw(new ItemStack(BlockIDs.OreTC.block, 1, 1), 150, 20));
                this.add(new StackToDraw(new ItemStack(Item.field_77705_m), 150, 60));
                this.add(new StackToDraw(new ItemStack(ItemIDs.diesel.item), 167, 40));
                this.add(new StackToDraw(new ItemStack(ItemIDs.rawPlastic.item), 182, 40));
            }
        });
        this.addPage("Special pull I: \nYou can attach two locomotives together.\n\nTo do that: shift+click the locomotive you want to PULL with a stake in your hand. Then fuel it and wait until it heats up.\n\nNow put both locomotives in attaching mode. Then move attach them by moving one locomotive towards the other.", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLocoBR80_DB.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartCabooseWork.item), 40, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartTankWagon_DB.item), 60, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFlatCartRail_DB.item), 80, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWagon_DB.item), 100, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartGP40alaska.item), 120, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartGP40alaska.item), 140, 165));
            }
        });
        this.addPage("Special pull II: \nLocomotives have two states: 'Can pull' and 'Can be pulled'.\n'Can pull' means that the locomotive is able to pull any attach cart. But it can't be pulled.\n'Can be pulled' means that the locomotive behaves like a cart and can be pulled by another locomotive (which is in 'can pull' state). Attached locomotives share power.", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartLoco3.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.stake.item), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartGP40alaska.item), 40, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWagon_DB.item), 60, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWagon_DB.item), 80, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWagon_DB.item), 100, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWagon_DB.item), 120, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartGP40alaska.item), 140, 165));
            }
        });
        this.addPage("Armors I: \nThere are several armors in the mod.\nThree of them are mostly skins (engineer, ticket man and driver) with same caracteristics as leather armor.\nOn the contrary, the composite suit is an armor with special capabilities and strong resistance and durability.\nSee next page for details.", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.hat.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.hat_ticketMan_paintable.item), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.hat_driver_paintable.item), 40, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.jacket_driver_paintable.item), 90, 165));
                this.add(new StackToDraw(new ItemStack(ItemIDs.pants_driver_paintable.item), 140, 165));
            }
        });
        this.addPage("Armors II: \nThe helmet cures poisons, helps you breathe under water, and gives night vision in dark places (not when riding an entity)\nThe chest regen half a heart every 5s.\nThe pants protect you against fire damages.\nThe boots absorb fall damages.\nTicket man, driver and composite armors are paintable (in train workbench)", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.helmet_suit_paintable.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.reinforcedPlates.item), 170, 16));
            }
        });
        this.addPage("Known bugs:\n- Sharp turns are not supported (close 180 turns)\n- Bounding boxes don't fit some trains properly. Sometimes they don't orient properly (generally when the entity is spawned).\n- Attached cart may bounce when stopped on a corner. This is due to the length of some models and because the physics is calculated from the center.\n- RE batteries empty instantly in electric trains\n", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(Item.field_82799_bQ, 1, 4), 20, 16));
                this.add(new StackToDraw(new ItemStack(Item.field_82799_bQ, 1, 4), 170, 16));
            }
        });
        this.addPage("Advices:\nDue to the bounding box issues, carts have to be attached and PULLED. Don't try to push\n\nRailcraft pull system has been deactivated on Traincraft trains. Use TC's system. \nAlso always attach carts to the back of the locomotive for aesthetic purpose...", "", "left", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartTankWagon_DB.item), 20, 16));
                this.add(new StackToDraw(new ItemStack(BlockIDs.OreTC.block), 170, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartCaboose3.item), 40, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartFreightWellcar.item), 60, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartOpenWagon.item), 80, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartStockCar.item), 100, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartOpenWagon.item), 120, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.minecartBR_E69.item), 140, 155));
            }
        });
        this.addPage("On the next pages you will find all the train workbench recipes and assembly table recipes.\nIt is however strongly suggested to try to discover the recipes by yourself...\n\nWe hope you will enjoy the mod!\n\nSpitfire4466 and MrBrutal", "", "right", new ArrayList(){
            {
                this.add(new StackToDraw(new ItemStack(BlockIDs.trainWorkbench.block), 20, 16));
                this.add(new StackToDraw(new ItemStack(ItemIDs.hat.item), 40, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.jacket.item), 90, 155));
                this.add(new StackToDraw(new ItemStack(ItemIDs.overalls.item), 140, 155));
            }
        });
        if (this.rightPage != null && this.recipeList != null && this.recipeListWB != null) {
            bookTotalPages = this.rightPage.size() + this.recipeList.size() / 2 + this.recipeListWB.size() / 2;
        }
    }

    private void addPage(String text, String image, String side, ArrayList stacks) {
        if (side.equals("left")) {
            this.leftPage.add(text);
            this.leftPageImage.add(image);
            this.leftPageItemStacks.add(stacks);
        }
        if (side.equals("right")) {
            this.rightPage.add(text);
            this.rightPageImage.add(image);
            this.rightPageItemStacks.add(stacks);
        }
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        int var1 = this.field_73880_f / 2;
        int var2 = this.field_73881_g / 2;
        this.buttonBack = new GuiButtonNextPage(4, var1 + 150, var2 + 80, 23, 13, true);
        this.field_73887_h.add(this.buttonBack);
        this.buttonRead = new GuiButtonNextPage(3, var1 - 8, var2 + 98, 40, 20, true);
        this.field_73887_h.add(this.buttonRead);
        this.buttonNextPage = new GuiButtonNextPage(1, var1 + 150, var2 + 80, 23, 13, true);
        this.field_73887_h.add(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage(2, var1 - 180, var2 + 80, 23, 13, false);
        this.field_73887_h.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    /*
     * Unable to fully structure code
     */
    private void updateButtons() {
        this.buttonBack.field_73748_h = this.currPage == GuiRecipeBook.bookTotalPages - 1;
        this.buttonBack.showButton = true;
        this.buttonRead.field_73748_h = this.currPage == 0;
        this.buttonRead.showButton = false;
        if (this.currPage <= 0) ** GOTO lbl-1000
        if (this.currPage < GuiRecipeBook.bookTotalPages - 1) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = this.buttonNextPage.field_73748_h = false;
        }
        if (this.currPage <= 0) ** GOTO lbl-1000
        if (this.currPage < GuiRecipeBook.bookTotalPages - 1) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        this.buttonNextPage.showButton = v1;
        this.buttonPreviousPage.field_73748_h = this.currPage > 0;
        this.buttonPreviousPage.showButton = this.currPage > 0;
    }

    protected void func_73875_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_73742_g) {
            if (par1GuiButton.field_73741_f == 1) {
                if (this.currPage < bookTotalPages - 1) {
                    ++this.currPage;
                    this.currRecipe += 2;
                }
            } else if (par1GuiButton.field_73741_f == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                    this.currRecipe -= 2;
                }
            } else if (par1GuiButton.field_73741_f == 3) {
                if (this.currPage == 0) {
                    ++this.currPage;
                    this.currRecipe += 2;
                }
            } else if (par1GuiButton.field_73741_f == 4 && this.currPage == bookTotalPages - 1) {
                this.currPage = 0;
                this.currRecipe = 0;
            }
            this.updateButtons();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int var5 = this.field_73880_f / 2;
        int var6 = this.field_73881_g / 2 - this.bookImageHeight / 2;
        if (this.currPage > 0) {
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/src/train/Resources/GUI/book/bookright.png");
            this.func_73729_b(var5, var6, 0, 0, this.bookImageWidth, this.bookImageHeight + 20);
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/src/train/Resources/GUI/book/bookleft.png");
            this.func_73729_b(var5 -= this.bookImageWidth, var6, 256 - this.bookImageWidth, 0, this.bookImageWidth, this.bookImageHeight);
        } else {
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/src/train/Resources/GUI/book/bookcover.png");
            this.func_73729_b(var5 - 55, var6 - 15, 0, 0, 256, 256);
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.currPage + 1;
        objectArray[1] = bookTotalPages;
        String pageIndic = String.format(StatCollector.func_74838_a((String)"book.pageIndicator"), objectArray);
        int var9 = this.field_73886_k.func_78256_a(pageIndic);
        if (this.currPage > 0) {
            this.field_73886_k.func_78276_b(pageIndic, var5 - var9 + this.bookImageWidth - 44, var6 + 7, 0);
        }
        super.func_73863_a(par1, par2, par3);
        if (this.currPage < this.rightPage.size()) {
            int t;
            int var10 = this.field_73886_k.func_78256_a((String)this.leftPage.get(this.currPage));
            this.field_73886_k.func_78279_b((String)this.leftPage.get(this.currPage), var5 + 36, var6 + 16 + 16, 140, 0);
            int var11 = this.field_73886_k.func_78256_a((String)this.rightPage.get(this.currPage));
            this.field_73886_k.func_78279_b((String)this.rightPage.get(this.currPage), var5 + 250, var6 + 16 + 16, 140, 0);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            if (this.leftPageItemStacks != null && this.leftPageItemStacks.get(this.currPage) != null && ((ArrayList)this.leftPageItemStacks.get(this.currPage)).get(0) != null) {
                for (t = 0; t < ((ArrayList)this.leftPageItemStacks.get(this.currPage)).size(); ++t) {
                    if (((ArrayList)this.leftPageItemStacks.get(this.currPage)).get(t) == null) continue;
                    this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, ((StackToDraw)((ArrayList)this.leftPageItemStacks.get(this.currPage)).get(t)).getItemStack(), var5 + ((StackToDraw)((ArrayList)this.leftPageItemStacks.get(this.currPage)).get(t)).getX(), var6 + ((StackToDraw)((ArrayList)this.leftPageItemStacks.get(this.currPage)).get(t)).getY());
                }
            }
            if (this.rightPageItemStacks != null && this.rightPageItemStacks.get(this.currPage) != null && ((ArrayList)this.rightPageItemStacks.get(this.currPage)).get(0) != null) {
                for (t = 0; t < ((ArrayList)this.rightPageItemStacks.get(this.currPage)).size(); ++t) {
                    if (((ArrayList)this.rightPageItemStacks.get(this.currPage)).get(t) == null) continue;
                    this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, ((StackToDraw)((ArrayList)this.rightPageItemStacks.get(this.currPage)).get(t)).getItemStack(), var5 + ((StackToDraw)((ArrayList)this.rightPageItemStacks.get(this.currPage)).get(t)).getX() + 210, var6 + ((StackToDraw)((ArrayList)this.rightPageItemStacks.get(this.currPage)).get(t)).getY());
                }
            }
            GL11.glDisable((int)32826);
        }
        if (this.currPage > this.rightPage.size() - 1) {
            int page = this.currRecipe - this.rightPage.size() * 2 + 1;
            if (page <= this.recipeListWB.size() - 1) {
                this.drawWorkBenchBackground(this.recipeListWB, var5, var6, 0, var9, "right");
                this.drawWorkBenchBackground(this.recipeListWB, var5, var6, 0, var9, "left");
                RenderHelper.func_74520_c();
                this.drawWorkBenchRecipe(this.recipeListWB, var5, var6, page - 1, var9, "right");
                this.drawWorkBenchRecipe(this.recipeListWB, var5, var6, page, var9, "left");
            } else if (page - this.recipeListWB.size() >= 0 && page - this.recipeListWB.size() < this.recipeList.size() && this.recipeList.get(page - this.recipeListWB.size()) != null) {
                this.drawAssemblyBackground(this.recipeList, var5 - 125, var6 - 33, page - this.recipeListWB.size(), var9, "right");
                this.drawAssemblyBackground(this.recipeList, var5 - 50, var6 - 33, page - this.recipeListWB.size() - 1, var9, "left");
                RenderHelper.func_74520_c();
                this.drawAssemblyRecipe(this.recipeList, var5 - 125, var6 - 33, page - this.recipeListWB.size(), var9, "right");
                this.drawAssemblyRecipe(this.recipeList, var5 - 50, var6 - 33, page - this.recipeListWB.size() - 1, var9, "left");
            }
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    private void drawAssemblyBackground(List recipeList, int var5, int var6, int page, int var9, String side) {
        if (page < 0) {
            return;
        }
        int tier = ((TierRecipe)recipeList.get(page)).getTier();
        if (tier == 1) {
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/src/train/Resources/GUI/gui_tierI_ironAge.png");
        }
        if (tier == 2) {
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/src/train/Resources/GUI/gui_tierII_steelAge.png");
        }
        if (tier == 3) {
            FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/src/train/Resources/GUI/gui_tierIII_advancedAge.png");
        }
        if (side.equals("left")) {
            this.func_73729_b(var5 + 70, var6 + 50, 0, 0, 177, 163);
        }
        if (side.equals("right")) {
            this.func_73729_b(var5 + 340, var6 + 50, 0, 0, 177, 163);
        }
    }

    private void drawWorkBenchBackground(List recipeListWB, int var5, int var6, int page, int var9, String side) {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/gui/crafting.png");
        if (side.equals("left")) {
            this.func_73729_b(var5 + 20, var6 + 50, 0, 0, 177, 80);
        }
        if (side.equals("right")) {
            this.func_73729_b(var5 + 215, var6 + 50, 0, 0, 177, 80);
        }
    }

    private void drawWorkBenchRecipe(List recipeList, int var5, int var6, int page, int var9, String side) {
        if (recipeList.get(page) == null) {
            return;
        }
        ItemStack[] itemList = new ItemStack[9];
        ItemStack itemOutput = null;
        if (recipeList.get(page) instanceof ShapedTrainRecipes) {
            itemList = ((ShapedTrainRecipes)recipeList.get((int)page)).recipeItems;
            itemOutput = ((ShapedTrainRecipes)recipeList.get(page)).getRecipeOutput();
        }
        if (recipeList.get(page) instanceof ShapelessTrainRecipe) {
            List itemListShapeless = ((ShapelessTrainRecipe)recipeList.get((int)page)).recipeItems;
            for (int t = 0; t < itemListShapeless.size(); ++t) {
                if (itemListShapeless == null || itemListShapeless.get(t) == null) continue;
                itemList[t] = (ItemStack)itemListShapeless.get(t);
            }
            itemOutput = ((ShapelessTrainRecipe)recipeList.get(page)).getRecipeOutput();
        }
        int offset = 0;
        if (side.equals("right")) {
            offset = 194;
        }
        GL11.glEnable((int)32826);
        if (itemList[0] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[0], var5 + 50 + offset, var6 + 67);
        }
        if (itemList[1] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[1], var5 + 68 + offset, var6 + 67);
        }
        if (itemList[2] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[2], var5 + 86 + offset, var6 + 67);
        }
        if (itemList[3] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[3], var5 + 50 + offset, var6 + 85);
        }
        if (itemList[4] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[4], var5 + 68 + offset, var6 + 85);
        }
        if (itemList[5] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[5], var5 + 86 + offset, var6 + 85);
        }
        if (itemList[6] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[6], var5 + 50 + offset, var6 + 103);
        }
        if (itemList[7] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[7], var5 + 68 + offset, var6 + 103);
        }
        if (itemList[8] != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemList[8], var5 + 86 + offset, var6 + 103);
        }
        if (itemOutput != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemOutput, var5 + 145 + offset, var6 + 85);
        }
        if (itemOutput != null) {
            this.field_73886_k.func_78276_b(itemOutput.func_77973_b().func_77628_j(itemOutput), var5 + 20 + offset, var6 + 40, 0);
        }
        if (itemOutput != null) {
            this.field_73886_k.func_78276_b("Crafted in: Train Workbench", var5 + 20 + offset, var6 + 130, 0);
        }
        if (itemOutput != null) {
            for (int z = 0; z < RecipeBookHandler.vanillaWorkTableRecipes.length; ++z) {
                if (itemOutput == null || itemOutput.func_77973_b() == null || RecipeBookHandler.vanillaWorkTableRecipes[z] == null || !RecipeBookHandler.vanillaWorkTableRecipes[z].equals(itemOutput.func_77973_b().func_77628_j(itemOutput))) continue;
                this.field_73886_k.func_78276_b("Also crafted in: Crafting Table", var5 + 20 + offset, var6 + 140, 0);
                break;
            }
        }
        GL11.glDisable((int)32826);
    }

    private void drawAssemblyRecipe(List recipeList, int var5, int var6, int page, int var9, String side) {
        ItemStack output;
        if (page < 0) {
            return;
        }
        int tier = ((TierRecipe)recipeList.get(page)).getTier();
        List itemList = ((TierRecipe)recipeList.get(page)).getInput();
        int offset = 0;
        if (side.equals("right")) {
            offset = 271;
        }
        GL11.glEnable((int)32826);
        if (itemList.get(0) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(0), var5 + 94 + offset, var6 + 76);
        }
        if (itemList.get(0) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(0), var5 + 94 + offset, var6 + 76);
        }
        if (itemList.get(1) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(1), var5 + 113 + offset, var6 + 143);
        }
        if (itemList.get(1) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(1), var5 + 113 + offset, var6 + 143);
        }
        if (itemList.get(2) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(2), var5 + 148 + offset, var6 + 143);
        }
        if (itemList.get(2) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(2), var5 + 148 + offset, var6 + 143);
        }
        if (itemList.get(3) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(3), var5 + 214 + offset, var6 + 143);
        }
        if (itemList.get(3) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(3), var5 + 214 + offset, var6 + 143);
        }
        if (itemList.get(4) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(4), var5 + 148 + offset, var6 + 77);
        }
        if (itemList.get(4) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(4), var5 + 148 + offset, var6 + 77);
        }
        if (itemList.get(5) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(5), var5 + 184 + offset, var6 + 77);
        }
        if (itemList.get(5) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(5), var5 + 184 + offset, var6 + 77);
        }
        if (itemList.get(6) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(6), var5 + 149 + offset, var6 + 110);
        }
        if (itemList.get(6) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(6), var5 + 149 + offset, var6 + 110);
        }
        if (itemList.get(7) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(7), var5 + 185 + offset, var6 + 110);
        }
        if (itemList.get(7) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(7), var5 + 185 + offset, var6 + 110);
        }
        if (itemList.get(8) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(8), var5 + 94 + offset, var6 + 110);
        }
        if (itemList.get(8) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(8), var5 + 94 + offset, var6 + 110);
        }
        if (itemList.get(9) != null) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(9), var5 + 214 + offset, var6 + 77);
        }
        if (itemList.get(9) != null) {
            this.renderItem.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)itemList.get(9), var5 + 214 + offset, var6 + 77);
        }
        if ((output = ((TierRecipe)recipeList.get(page)).getOutput()) != null && side.equals("left")) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, output, var5 + 162, var6 + 177);
        }
        if (output != null && side.equals("right")) {
            this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, output, var5 + 432, var6 + 177);
        }
        String name = "";
        if (output != null && output.func_77973_b() instanceof ItemRollingStock) {
            name = ((ItemRollingStock)output.func_77973_b()).getTrainName();
        }
        if (side.equals("left")) {
            this.field_73886_k.func_78276_b(name, var5 - var9 + this.bookImageWidth - 55, var6 + 56, 0xFFFFFF);
        }
        if (side.equals("right")) {
            this.field_73886_k.func_78276_b(name, var5 - var9 + this.bookImageWidth + 215, var6 + 56, 0xFFFFFF);
        }
        if (side.equals("left")) {
            this.field_73886_k.func_78276_b("Tier: " + tier, var5 - var9 + this.bookImageWidth - 56, var6 + 40, 0);
        }
        if (side.equals("right")) {
            this.field_73886_k.func_78276_b("Tier: " + tier, var5 - var9 + this.bookImageWidth + 338, var6 + 40, 0);
        }
        GL11.glDisable((int)32826);
    }

    public void func_73874_b() {
        NBTTagCompound var3 = this.itemstackBook.func_77978_p();
        PacketHandler.setBookPage((Entity)this.editingPlayer, this.currPage, this.currRecipe);
        this.itemstackBook.func_77978_p().func_74768_a("currPage", this.currPage);
        this.itemstackBook.func_77978_p().func_74768_a("currRecipe", this.currRecipe);
        super.func_73874_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    public class StackToDraw {
        private ItemStack stack;
        private int x;
        private int y;

        public StackToDraw(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }

        public ItemStack getItemStack() {
            return this.stack;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

