/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.core.helpers;

import java.util.concurrent.ConcurrentHashMap;
import src.train.client.core.handlers.CapesUsers;

public class CapesHelper {
    private static CapesHelper mccapes;
    private static ConcurrentHashMap users;

    private CapesHelper() {
        users = new ConcurrentHashMap();
    }

    public static CapesHelper getMCCapes() {
        if (mccapes == null) {
            mccapes = new CapesHelper();
        }
        return mccapes;
    }

    public void addUser(String username) {
        if (this.getUser(username) != null) {
            return;
        }
        CapesUsers user = new CapesUsers(username);
        if (user != null) {
            users.put(username, user);
            CapesHelper.getMCCapes().obtainImageData(username);
        }
    }

    public CapesUsers getUser(String username) {
        return (CapesUsers)users.get(username);
    }

    public String getCurrentCapeImage(String username) {
        CapesUsers user = this.getUser(username);
        if (user != null) {
            return user.getCurrentCapeImage();
        }
        return null;
    }

    public void obtainImageData(String username) {
        CapesUsers user = (CapesUsers)users.get(username);
        if (user != null) {
            user.obtainImageData();
        }
    }

    public void releaseImageData(String username) {
        CapesUsers user = (CapesUsers)users.get(username);
        if (user != null) {
            user.releaseImageData();
        }
    }
}

