/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.core.handlers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;

public class CapesUsers {
    public String username;
    public boolean staticCapeEnabled = false;
    public boolean animatedCapeEnabled = false;
    public String staticCapeUrl;
    public ArrayList animatedCapeFrameUrls;
    public int currentCapeFrame;
    public long lastCapeFrameTime;
    public int capeAnimationInterval = 500;
    private ArrayList staticUsers;
    private ArrayList animatedUsers;

    public CapesUsers(String username) {
        try {
            String line;
            URL url = new URL("https://dl.dropbox.com/u/26029386/traincraft_cape.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("userStatic:")) {
                    if (this.staticUsers == null) {
                        this.staticUsers = new ArrayList();
                    }
                    this.staticUsers.add(line.substring(11));
                    continue;
                }
                if (line.startsWith("userAnimated:")) {
                    if (this.animatedUsers == null) {
                        this.animatedUsers = new ArrayList();
                    }
                    this.animatedUsers.add(line.substring(13));
                    continue;
                }
                if (line.startsWith("staticCapeUrl:") && this.isUserRegistered(this.staticUsers, username)) {
                    this.staticCapeEnabled = true;
                    this.staticCapeUrl = line.substring(14);
                    continue;
                }
                if (line.startsWith("animatedCapeFrameUrl:") && this.isUserRegistered(this.animatedUsers, username)) {
                    this.animatedCapeEnabled = true;
                    if (this.animatedCapeFrameUrls == null) {
                        this.animatedCapeFrameUrls = new ArrayList();
                    }
                    this.animatedCapeFrameUrls.add(line.substring(21));
                    continue;
                }
                if (!line.startsWith("capeAnimationInterval:")) continue;
                this.capeAnimationInterval = Integer.parseInt(line.substring(22)) * 10;
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isUserRegistered(ArrayList list, String currentUsername) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!currentUsername.toLowerCase().equals(list.get(i).toString().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public String getCurrentCapeImage() {
        if (this.animatedCapeEnabled) {
            long time = Minecraft.func_71386_F();
            if (time > this.lastCapeFrameTime + (long)this.capeAnimationInterval) {
                this.lastCapeFrameTime = time;
                ++this.currentCapeFrame;
                if (this.currentCapeFrame >= this.animatedCapeFrameUrls.size()) {
                    this.currentCapeFrame = 0;
                }
            }
            return (String)this.animatedCapeFrameUrls.get(this.currentCapeFrame);
        }
        if (this.staticCapeEnabled) {
            return this.staticCapeUrl;
        }
        return null;
    }

    public void obtainImageData() {
        if (this.animatedCapeEnabled) {
            for (int i = 0; i < this.animatedCapeFrameUrls.size(); ++i) {
                String url = (String)this.animatedCapeFrameUrls.get(i);
                Minecraft.func_71410_x().field_71446_o.func_78356_a(url, (IImageBuffer)new ImageBufferDownload());
            }
        } else if (this.staticCapeEnabled) {
            Minecraft.func_71410_x().field_71446_o.func_78356_a(this.staticCapeUrl, (IImageBuffer)new ImageBufferDownload());
        }
    }

    public void releaseImageData() {
        if (this.animatedCapeEnabled) {
            for (int i = 0; i < this.animatedCapeFrameUrls.size(); ++i) {
                String url = (String)this.animatedCapeFrameUrls.get(i);
                Minecraft.func_71410_x().field_71446_o.func_78347_c(url);
            }
        } else if (this.staticCapeEnabled) {
            Minecraft.func_71410_x().field_71446_o.func_78347_c(this.staticCapeUrl);
        }
    }
}

