/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksObfuscation;
import invtweaks.api.ContainerGUI;
import invtweaks.api.ContainerSection;
import invtweaks.api.InventoryGUI;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class InvTweaksModCompatibility {
    private final InvTweaksObfuscation obf;

    public InvTweaksModCompatibility(InvTweaksObfuscation invTweaksObfuscation) {
        this.obf = invTweaksObfuscation;
    }

    public boolean isSpecialChest(GuiScreen guiScreen) {
        return InvTweaksModCompatibility.getContainerGUIAnnotation(guiScreen.getClass()) != null || InvTweaksModCompatibility.is(guiScreen, "GuiAlchChest") || InvTweaksModCompatibility.is(guiScreen, "GuiCondenser") || InvTweaksModCompatibility.is(guiScreen, "GUIChest") || InvTweaksModCompatibility.is(guiScreen, "GuiMultiPageChest") || InvTweaksModCompatibility.is(guiScreen, "GuiGoldSafe") || InvTweaksModCompatibility.is(guiScreen, "GuiLocker") || InvTweaksModCompatibility.is(guiScreen, "GuiDualLocker") || InvTweaksModCompatibility.is(guiScreen, "GuiSafe") || InvTweaksModCompatibility.is(guiScreen, "GuiCabinet") || InvTweaksModCompatibility.is(guiScreen, "GuiTower") || InvTweaksModCompatibility.is(guiScreen, "GuiBufferChest") || InvTweaksModCompatibility.is(guiScreen, "GuiRetriever") || InvTweaksModCompatibility.is(guiScreen, "GuiItemDetect") || InvTweaksModCompatibility.is(guiScreen, "GuiAlloyFurnace") || InvTweaksModCompatibility.is(guiScreen, "GuiDeploy") || InvTweaksModCompatibility.is(guiScreen, "GuiSorter") || InvTweaksModCompatibility.is(guiScreen, "GuiFilter") || InvTweaksModCompatibility.is(guiScreen, "GuiAdvBench") || InvTweaksModCompatibility.is(guiScreen, "GuiEject") || InvTweaksModCompatibility.is(guiScreen, "GuiBag") || InvTweaksModCompatibility.is(guiScreen, "GuiPersonalChest") || InvTweaksModCompatibility.is(guiScreen, "GuiNuclearReactor") || InvTweaksModCompatibility.is(guiScreen, "GuiEnderChest") || InvTweaksModCompatibility.is(guiScreen, "GuiColorBox") || InvTweaksModCompatibility.is(guiScreen, "GuiLinkedColorBox") || InvTweaksModCompatibility.is(guiScreen, "FC_GuiChest") || InvTweaksModCompatibility.is(guiScreen, "FM_GuiMintStorage") || InvTweaksModCompatibility.is(guiScreen, "GuiChestTFC") || InvTweaksModCompatibility.is(guiScreen, "GuiBackpack") || InvTweaksModCompatibility.isExact(guiScreen, "com.pahimar.ee3.client.gui.inventory.GuiPortableCrafting") || InvTweaksModCompatibility.isExact(guiScreen, "codechicken.enderstorage.storage.item.GuiEnderItemStorage") || InvTweaksModCompatibility.isExact(guiScreen, "net.mcft.copy.betterstorage.client.GuiReinforcedChest");
    }

    public int getSpecialChestRowSize(GuiContainer guiContainer, int n) {
        ContainerGUI containerGUI = InvTweaksModCompatibility.getContainerGUIAnnotation(guiContainer.getClass());
        if (containerGUI != null) {
            Method method = InvTweaksModCompatibility.getAnnotatedMethod(guiContainer.getClass(), new Class[]{ContainerGUI.RowSizeCallback.class}, 0, Integer.TYPE);
            if (method != null) {
                try {
                    return (Integer)method.invoke((Object)guiContainer, new Object[0]);
                }
                catch (Exception exception) {
                    return containerGUI.rowSize();
                }
            }
            return containerGUI.rowSize();
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiAlchChest") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiCondenser")) {
            return 13;
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GUIChest")) {
            try {
                return (Integer)guiContainer.getClass().getMethod("getRowLength", new Class[0]).invoke((Object)guiContainer, new Object[0]);
            }
            catch (Exception exception) {
                return n;
            }
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiMultiPageChest")) {
            return 13;
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiLocker") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiDualLocker") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiTower")) {
            return 8;
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiBufferChest")) {
            return 4;
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiSorter")) {
            return 8;
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiRetriever") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiItemDetect") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiAlloyFurnace") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiDeploy") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiFilter") || InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiEject")) {
            return 3;
        }
        if (InvTweaksModCompatibility.is((GuiScreen)guiContainer, "GuiNuclearReactor")) {
            return (this.obf.getSlots(this.obf.getContainer(guiContainer)).size() - 36) / 6;
        }
        if (InvTweaksModCompatibility.isExact((GuiScreen)guiContainer, "net.mcft.copy.betterstorage.client.GuiReinforcedChest")) {
            try {
                return (Integer)guiContainer.getClass().getMethod("getNumColumns", new Class[0]).invoke((Object)guiContainer, new Object[0]);
            }
            catch (Exception exception) {
                return n;
            }
        }
        return n;
    }

    public boolean isChestWayTooBig(GuiScreen guiScreen) {
        return InvTweaksModCompatibility.is(guiScreen, "GuiAlchChest") || InvTweaksModCompatibility.is(guiScreen, "GuiMultiPageChest") || InvTweaksModCompatibility.is(guiScreen, "GUIChest") || InvTweaksModCompatibility.is(guiScreen, "FC_GuiChest");
    }

    public boolean isSpecialInventory(GuiScreen guiScreen) {
        if (InvTweaksModCompatibility.getInventoryGUIAnnotation(guiScreen.getClass()) != null) {
            return true;
        }
        try {
            return this.obf.getSlots(this.obf.getContainer(this.obf.asGuiContainer(guiScreen))).size() > 36 && !this.obf.isGuiInventoryCreative(guiScreen);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Map<ContainerSection, List<Slot>> getSpecialContainerSlots(GuiScreen guiScreen, Container container) {
        Object object;
        Class<?> clazz = guiScreen.getClass();
        if (InvTweaksModCompatibility.isAPIClass(clazz) && (object = InvTweaksModCompatibility.getAnnotatedMethod(clazz, new Class[]{ContainerGUI.ContainerSectionCallback.class, InventoryGUI.ContainerSectionCallback.class}, 0, Map.class)) != null) {
            try {
                return (Map)((Method)object).invoke((Object)guiScreen, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = new HashMap();
        List<?> list = this.obf.getSlots(container);
        if (InvTweaksModCompatibility.is(guiScreen, "GuiCondenser")) {
            object.put(ContainerSection.CHEST, list.subList(1, list.size() - 36));
        } else if (InvTweaksModCompatibility.is(guiScreen, "GuiAdvBench")) {
            object.put(ContainerSection.CRAFTING_IN_PERSISTENT, list.subList(0, 9));
            object.put(ContainerSection.CRAFTING_OUT, list.subList(10, 11));
            object.put(ContainerSection.CHEST, list.subList(11, 29));
        } else if (InvTweaksModCompatibility.is(guiScreen, "GuiArcaneWorkbench") || InvTweaksModCompatibility.is(guiScreen, "GuiInfusionWorkbench")) {
            object.put(ContainerSection.CRAFTING_OUT, list.subList(0, 1));
            object.put(ContainerSection.CRAFTING_IN_PERSISTENT, list.subList(2, 11));
        } else if (InvTweaksModCompatibility.isExact(guiScreen, "com.pahimar.ee3.client.gui.inventory.GuiPortableCrafting")) {
            object.put(ContainerSection.CRAFTING_OUT, list.subList(0, 1));
            object.put(ContainerSection.CRAFTING_IN, list.subList(1, 10));
        }
        return object;
    }

    private static boolean is(GuiScreen guiScreen, String string) {
        try {
            return guiScreen.getClass().getSimpleName().contains(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isExact(GuiScreen guiScreen, String string) {
        try {
            return guiScreen.getClass().getName().equals(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static ContainerGUI getContainerGUIAnnotation(Class<? extends GuiScreen> clazz) {
        return clazz.getAnnotation(ContainerGUI.class);
    }

    private static InventoryGUI getInventoryGUIAnnotation(Class<? extends GuiScreen> clazz) {
        return clazz.getAnnotation(InventoryGUI.class);
    }

    private static boolean isAPIClass(Class<? extends GuiScreen> clazz) {
        return InvTweaksModCompatibility.getContainerGUIAnnotation(clazz) != null || InvTweaksModCompatibility.getInventoryGUIAnnotation(clazz) != null;
    }

    private static Method getAnnotatedMethod(Class clazz, Class[] classArray, int n, Class clazz2) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            for (Class clazz3 : classArray) {
                if (method.getAnnotation(clazz3) == null || method.getParameterTypes().length != n || !clazz2.isAssignableFrom(method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }
}

