/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeCategory;
import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;

public class InvTweaksItemTree {
    public static final int MAX_CATEGORY_RANGE = 1000;
    public static final String UNKNOWN_ITEM = "unknown";
    private static final Logger log = InvTweaks.log;
    private Map<String, InvTweaksItemTreeCategory> categories = new HashMap<String, InvTweaksItemTreeCategory>();
    private Map<Integer, Vector<InvTweaksItemTreeItem>> itemsById = new HashMap<Integer, Vector<InvTweaksItemTreeItem>>(500);
    private static Vector<InvTweaksItemTreeItem> defaultItems = null;
    private Map<String, Vector<InvTweaksItemTreeItem>> itemsByName = new HashMap<String, Vector<InvTweaksItemTreeItem>>(500);
    private String rootCategory;
    private List<OreDictInfo> oresRegistered = new ArrayList<OreDictInfo>();

    public InvTweaksItemTree() {
        this.reset();
    }

    public void reset() {
        if (defaultItems == null) {
            defaultItems = new Vector();
            defaultItems.add(new InvTweaksItemTreeItem(UNKNOWN_ITEM, -1, Short.MAX_VALUE, Integer.MAX_VALUE));
        }
        this.categories.clear();
        this.itemsByName.clear();
        this.itemsById.clear();
    }

    public boolean matches(List<InvTweaksItemTreeItem> list, String string) {
        if (list == null) {
            return false;
        }
        for (InvTweaksItemTreeItem object : list) {
            if (object.getName() == null || !object.getName().equals(string)) continue;
            return true;
        }
        InvTweaksItemTreeCategory invTweaksItemTreeCategory = this.getCategory(string);
        if (invTweaksItemTreeCategory != null) {
            for (InvTweaksItemTreeItem invTweaksItemTreeItem : list) {
                if (!invTweaksItemTreeCategory.contains(invTweaksItemTreeItem)) continue;
                return true;
            }
        }
        return string.equals(this.rootCategory);
    }

    public int getKeywordDepth(String string) {
        try {
            return this.getRootCategory().findKeywordDepth(string);
        }
        catch (NullPointerException nullPointerException) {
            log.severe("The root category is missing: " + nullPointerException.getMessage());
            return 0;
        }
    }

    public int getKeywordOrder(String string) {
        List<InvTweaksItemTreeItem> list = this.getItems(string);
        if (list != null && list.size() != 0) {
            return list.get(0).getOrder();
        }
        try {
            return this.getRootCategory().findCategoryOrder(string);
        }
        catch (NullPointerException nullPointerException) {
            log.severe("The root category is missing: " + nullPointerException.getMessage());
            return -1;
        }
    }

    public boolean isKeywordValid(String string) {
        if (this.containsItem(string)) {
            return true;
        }
        InvTweaksItemTreeCategory invTweaksItemTreeCategory = this.getCategory(string);
        return invTweaksItemTreeCategory != null;
    }

    public Collection<InvTweaksItemTreeCategory> getAllCategories() {
        return this.categories.values();
    }

    public InvTweaksItemTreeCategory getRootCategory() {
        return this.categories.get(this.rootCategory);
    }

    public InvTweaksItemTreeCategory getCategory(String string) {
        return this.categories.get(string);
    }

    public boolean isItemUnknown(int n, int n2) {
        return this.itemsById.get(n) == null;
    }

    public List<InvTweaksItemTreeItem> getItems(int n, int n2) {
        Object object;
        List list = this.itemsById.get(n);
        ArrayList<InvTweaksItemTreeItem> arrayList = new ArrayList<InvTweaksItemTreeItem>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list != null && !list.isEmpty()) {
            for (InvTweaksItemTreeItem invTweaksItemTreeItem : list) {
                if (invTweaksItemTreeItem.getDamage() == Short.MAX_VALUE || invTweaksItemTreeItem.getDamage() == n2) continue;
                arrayList.remove(invTweaksItemTreeItem);
            }
        }
        if (arrayList.isEmpty()) {
            InvTweaksItemTreeItem invTweaksItemTreeItem;
            object = new InvTweaksItemTreeItem(String.format("%d-%d", n, n2), n, n2, 5000 + n * 16 + n2);
            invTweaksItemTreeItem = new InvTweaksItemTreeItem(Integer.toString(n), n, Short.MAX_VALUE, 5000 + n * 16);
            this.addItem(this.getRootCategory().getName(), (InvTweaksItemTreeItem)object);
            this.addItem(this.getRootCategory().getName(), invTweaksItemTreeItem);
            arrayList.add((InvTweaksItemTreeItem)object);
            arrayList.add(invTweaksItemTreeItem);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            object.remove();
        }
        return arrayList;
    }

    public List<InvTweaksItemTreeItem> getItems(String string) {
        return this.itemsByName.get(string);
    }

    public InvTweaksItemTreeItem getRandomItem(Random random) {
        return (InvTweaksItemTreeItem)this.itemsByName.values().toArray()[random.nextInt(this.itemsByName.size())];
    }

    public boolean containsItem(String string) {
        return this.itemsByName.containsKey(string);
    }

    public boolean containsCategory(String string) {
        return this.categories.containsKey(string);
    }

    public void setRootCategory(InvTweaksItemTreeCategory invTweaksItemTreeCategory) {
        this.rootCategory = invTweaksItemTreeCategory.getName();
        this.categories.put(this.rootCategory, invTweaksItemTreeCategory);
    }

    public void addCategory(String string, InvTweaksItemTreeCategory invTweaksItemTreeCategory) throws NullPointerException {
        this.categories.get(string.toLowerCase()).addCategory(invTweaksItemTreeCategory);
        this.categories.put(invTweaksItemTreeCategory.getName(), invTweaksItemTreeCategory);
    }

    public void addItem(String string, InvTweaksItemTreeItem invTweaksItemTreeItem) throws NullPointerException {
        Vector<InvTweaksItemTreeItem> vector;
        this.categories.get(string.toLowerCase()).addItem(invTweaksItemTreeItem);
        if (this.itemsByName.containsKey(invTweaksItemTreeItem.getName())) {
            this.itemsByName.get(invTweaksItemTreeItem.getName()).add(invTweaksItemTreeItem);
        } else {
            vector = new Vector<InvTweaksItemTreeItem>();
            vector.add(invTweaksItemTreeItem);
            this.itemsByName.put(invTweaksItemTreeItem.getName(), vector);
        }
        if (this.itemsById.containsKey(invTweaksItemTreeItem.getId())) {
            this.itemsById.get(invTweaksItemTreeItem.getId()).add(invTweaksItemTreeItem);
        } else {
            vector = new Vector();
            vector.add(invTweaksItemTreeItem);
            this.itemsById.put(invTweaksItemTreeItem.getId(), vector);
        }
    }

    private void log(InvTweaksItemTreeCategory invTweaksItemTreeCategory, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        log.info(string + invTweaksItemTreeCategory.getName());
        for (InvTweaksItemTreeCategory object : invTweaksItemTreeCategory.getSubCategories()) {
            this.log(object, n + 1);
        }
        for (List list : invTweaksItemTreeCategory.getItems()) {
            for (InvTweaksItemTreeItem invTweaksItemTreeItem : list) {
                log.info(string + "  " + invTweaksItemTreeItem + " " + invTweaksItemTreeItem.getId() + " " + invTweaksItemTreeItem.getDamage());
            }
        }
    }

    public void registerOre(String string, String string2, String string3, int n) {
        for (ItemStack itemStack : OreDictionary.getOres((String)string3)) {
            this.addItem(string, new InvTweaksItemTreeItem(string2, itemStack.field_77993_c, itemStack.func_77960_j(), n));
        }
        this.oresRegistered.add(new OreDictInfo(string, string2, string3, n));
    }

    @ForgeSubscribe
    public void oreRegistered(OreDictionary.OreRegisterEvent oreRegisterEvent) {
        for (OreDictInfo oreDictInfo : this.oresRegistered) {
            if (!oreDictInfo.oreName.equals(oreRegisterEvent.Name)) continue;
            this.addItem(oreDictInfo.category, new InvTweaksItemTreeItem(oreDictInfo.name, oreRegisterEvent.Ore.field_77993_c, oreRegisterEvent.Ore.func_77960_j(), oreDictInfo.order));
        }
    }

    private class OreDictInfo {
        String category;
        String name;
        String oreName;
        int order;

        OreDictInfo(String string, String string2, String string3, int n) {
            this.category = string;
            this.name = string2;
            this.oreName = string3;
            this.order = n;
        }
    }
}

