/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksObfuscation;
import invtweaks.api.ContainerSection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class InvTweaksContainerManager
extends InvTweaksObfuscation {
    public static final int DROP_SLOT = -999;
    public static final int INVENTORY_SIZE = 36;
    public static final int HOTBAR_SIZE = 9;
    public static final int ACTION_TIMEOUT = 500;
    public static final int POLLING_DELAY = 3;
    private GuiContainer guiContainer;
    private Container container;
    private Map<ContainerSection, List<Slot>> slotRefs = new HashMap<ContainerSection, List<Slot>>();
    private int clickDelay = 0;

    public InvTweaksContainerManager(Minecraft minecraft) {
        super(minecraft);
        GuiScreen guiScreen = this.getCurrentScreen();
        if (this.isGuiContainer(guiScreen)) {
            this.guiContainer = this.asGuiContainer(guiScreen);
            this.container = this.getContainer(this.guiContainer);
        } else {
            this.container = this.getPlayerContainer();
        }
        List<?> list = this.getSlots(this.container);
        int n = list.size();
        boolean bl = true;
        if (this.isContainerPlayer(this.container)) {
            this.slotRefs.put(ContainerSection.CRAFTING_OUT, list.subList(0, 1));
            this.slotRefs.put(ContainerSection.CRAFTING_IN, list.subList(1, 5));
            this.slotRefs.put(ContainerSection.ARMOR, list.subList(5, 9));
        } else if (this.isContainerCreative(this.container)) {
            this.slotRefs.put(ContainerSection.ARMOR, list.subList(5, 9));
            --n;
        } else if (this.isContainerChest(this.container) || this.isContainerDispenser(this.container)) {
            this.slotRefs.put(ContainerSection.CHEST, list.subList(0, n - 36));
        } else if (this.isContainerFurnace(this.container)) {
            this.slotRefs.put(ContainerSection.FURNACE_IN, list.subList(0, 1));
            this.slotRefs.put(ContainerSection.FURNACE_FUEL, list.subList(1, 2));
            this.slotRefs.put(ContainerSection.FURNACE_OUT, list.subList(2, 3));
        } else if (this.isContainerWorkbench(this.container)) {
            this.slotRefs.put(ContainerSection.CRAFTING_OUT, list.subList(0, 1));
            this.slotRefs.put(ContainerSection.CRAFTING_IN, list.subList(1, 10));
        } else if (this.isContainerEnchantmentTable(this.container)) {
            this.slotRefs.put(ContainerSection.ENCHANTMENT, list.subList(0, 1));
        } else if (this.isContainerBrewingStand(this.container)) {
            this.slotRefs.put(ContainerSection.BREWING_BOTTLES, list.subList(0, 3));
            this.slotRefs.put(ContainerSection.BREWING_INGREDIENT, list.subList(3, 4));
        } else {
            this.slotRefs = this.mods.getSpecialContainerSlots(guiScreen, this.container);
            if (this.slotRefs.isEmpty()) {
                if (n >= 36) {
                    this.slotRefs.put(ContainerSection.CHEST, list.subList(0, n - 36));
                } else {
                    bl = false;
                    this.slotRefs.put(ContainerSection.CHEST, list.subList(0, n));
                }
            }
        }
        if (bl && !this.slotRefs.containsKey((Object)ContainerSection.INVENTORY)) {
            this.slotRefs.put(ContainerSection.INVENTORY, list.subList(n - 36, n));
            this.slotRefs.put(ContainerSection.INVENTORY_NOT_HOTBAR, list.subList(n - 36, n - 9));
            this.slotRefs.put(ContainerSection.INVENTORY_HOTBAR, list.subList(n - 9, n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean move(ContainerSection containerSection, int n, ContainerSection containerSection2, int n2) {
        Slot slot;
        ItemStack itemStack = this.getItemStack(containerSection, n);
        ItemStack itemStack2 = this.getItemStack(containerSection2, n2);
        if (itemStack == null && n2 != -999) {
            return false;
        }
        if (containerSection == containerSection2 && n == n2) {
            return true;
        }
        if (n2 != -999 && !(slot = this.getSlot(containerSection2, n2)).func_75214_a(itemStack)) {
            return false;
        }
        if (this.getHeldStack() != null) {
            int n3 = this.getFirstEmptyIndex(ContainerSection.INVENTORY);
            if (n3 == -1) return false;
            this.leftClick(ContainerSection.INVENTORY, n3);
        }
        if (itemStack2 != null && this.getItemID(itemStack) == this.getItemID(itemStack2) && (this.getMaxStackSize(itemStack) == 1 || this.hasDataTags(itemStack) || this.hasDataTags(itemStack2))) {
            int n4 = this.getFirstEmptyUsableSlotNumber();
            ContainerSection containerSection3 = this.getSlotSection(n4);
            int n5 = this.getSlotIndex(n4);
            if (n5 == -1) return false;
            Slot slot2 = this.getSlot(containerSection3, n5);
            if (!slot2.func_75214_a(itemStack2)) {
                return false;
            }
            Slot slot3 = this.getSlot(containerSection, n);
            if (!slot3.func_75214_a(itemStack2)) {
                return false;
            }
            this.leftClick(containerSection2, n2);
            this.leftClick(containerSection3, n5);
            this.leftClick(containerSection, n);
            this.leftClick(containerSection2, n2);
            this.leftClick(containerSection3, n5);
            this.leftClick(containerSection, n);
            return true;
        } else {
            this.leftClick(containerSection, n);
            this.leftClick(containerSection2, n2);
            if (this.getHeldStack() == null) return true;
            this.leftClick(containerSection, n);
        }
        return true;
    }

    public boolean moveSome(ContainerSection containerSection, int n, ContainerSection containerSection2, int n2, int n3) {
        ItemStack itemStack = this.getItemStack(containerSection, n);
        if (itemStack == null || containerSection == containerSection2 && n == n2) {
            return true;
        }
        ItemStack itemStack2 = this.getItemStack(containerSection, n);
        int n4 = this.getStackSize(itemStack);
        int n5 = Math.min(n3, n4);
        if (itemStack2 == null || this.areItemStacksEqual(itemStack, itemStack2)) {
            this.leftClick(containerSection, n);
            for (int i = 0; i < n5; ++i) {
                this.rightClick(containerSection2, n2);
            }
            if (n5 < n4) {
                this.leftClick(containerSection, n);
            }
            return true;
        }
        return false;
    }

    public boolean drop(ContainerSection containerSection, int n) {
        return this.move(containerSection, n, null, -999);
    }

    public boolean dropSome(ContainerSection containerSection, int n, int n2) {
        return this.moveSome(containerSection, n, null, -999, n2);
    }

    public boolean putHoldItemDown(ContainerSection containerSection, int n) {
        ItemStack itemStack = this.getHeldStack();
        if (itemStack != null) {
            if (this.getItemStack(containerSection, n) == null) {
                this.click(containerSection, n, false);
                return true;
            }
            return false;
        }
        return true;
    }

    public void leftClick(ContainerSection containerSection, int n) {
        this.click(containerSection, n, false);
    }

    public void rightClick(ContainerSection containerSection, int n) {
        this.click(containerSection, n, true);
    }

    public void click(ContainerSection containerSection, int n, boolean bl) {
        int n2 = this.indexToSlot(containerSection, n);
        if (n2 != -1) {
            this.clickInventory(this.getPlayerController(), this.getWindowId(this.container), n2, bl ? 1 : 0, 0, this.getThePlayer());
        }
        if (this.clickDelay > 0) {
            try {
                Thread.sleep(this.clickDelay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public Slot getSlotAtMousePosition() {
        if (this.guiContainer != null) {
            int n = this.getMouseX();
            int n2 = this.getMouseY();
            for (int i = 0; i < this.getSlots(this.getContainer(this.guiContainer)).size(); ++i) {
                Slot slot = (Slot)this.getSlots(this.getContainer(this.guiContainer)).get(i);
                if (!this.getIsMouseOverSlot(slot, n, n2)) continue;
                return slot;
            }
            return null;
        }
        return null;
    }

    public boolean getIsMouseOverSlot(Slot slot) {
        return this.getIsMouseOverSlot(slot, this.getMouseX(), this.getMouseY());
    }

    private boolean getIsMouseOverSlot(Slot slot, int n, int n2) {
        if (this.guiContainer != null) {
            int n3 = (this.guiContainer.field_73880_f - this.getGuiWidth(this.guiContainer)) / 2;
            int n4 = (this.guiContainer.field_73881_g - this.getGuiHeight(this.guiContainer)) / 2;
            return (n -= n3) >= this.getXDisplayPosition(slot) - 1 && n < this.getXDisplayPosition(slot) + 16 + 1 && (n2 -= n4) >= this.getYDisplayPosition(slot) - 1 && n2 < this.getYDisplayPosition(slot) + 16 + 1;
        }
        return false;
    }

    private int getMouseX() {
        return Mouse.getEventX() * this.getWindowWidth((GuiScreen)this.guiContainer) / this.getDisplayWidth();
    }

    private int getMouseY() {
        return this.getWindowHeight((GuiScreen)this.guiContainer) - Mouse.getEventY() * this.getWindowHeight((GuiScreen)this.guiContainer) / this.getDisplayHeight() - 1;
    }

    public boolean hasSection(ContainerSection containerSection) {
        return this.slotRefs.containsKey((Object)containerSection);
    }

    public List<Slot> getSlots(ContainerSection containerSection) {
        return this.slotRefs.get((Object)containerSection);
    }

    public int getSize() {
        int n = 0;
        for (List<Slot> list : this.slotRefs.values()) {
            n += list.size();
        }
        return n;
    }

    public int getSize(ContainerSection containerSection) {
        if (this.hasSection(containerSection)) {
            return this.slotRefs.get((Object)containerSection).size();
        }
        return 0;
    }

    public int getFirstEmptyIndex(ContainerSection containerSection) {
        int n = 0;
        for (Slot slot : this.slotRefs.get((Object)containerSection)) {
            if (!this.hasStack(slot)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isSlotEmpty(ContainerSection containerSection, int n) {
        if (this.hasSection(containerSection)) {
            return this.getItemStack(containerSection, n) == null;
        }
        return false;
    }

    public Slot getSlot(ContainerSection containerSection, int n) {
        List<Slot> list = this.slotRefs.get((Object)containerSection);
        if (list != null) {
            return list.get(n);
        }
        return null;
    }

    public int getSlotIndex(int n) {
        return this.getSlotIndex(n, false);
    }

    public int getSlotIndex(int n, boolean bl) {
        for (ContainerSection containerSection : this.slotRefs.keySet()) {
            if ((bl || containerSection == ContainerSection.INVENTORY) && (!bl || containerSection == ContainerSection.INVENTORY_NOT_HOTBAR || containerSection == ContainerSection.INVENTORY_HOTBAR)) continue;
            int n2 = 0;
            for (Slot slot : this.slotRefs.get((Object)containerSection)) {
                if (this.getSlotNumber(slot) == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public ContainerSection getSlotSection(int n) {
        for (ContainerSection containerSection : this.slotRefs.keySet()) {
            if (containerSection == ContainerSection.INVENTORY) continue;
            for (Slot slot : this.slotRefs.get((Object)containerSection)) {
                if (this.getSlotNumber(slot) != n) continue;
                return containerSection;
            }
        }
        return null;
    }

    public ItemStack getItemStack(ContainerSection containerSection, int n) throws NullPointerException, IndexOutOfBoundsException {
        int n2 = this.indexToSlot(containerSection, n);
        if (n2 >= 0 && n2 < this.getSlots(this.container).size()) {
            return this.getSlotStack(this.container, n2);
        }
        return null;
    }

    public Container getContainer() {
        return this.container;
    }

    private int getFirstEmptyUsableSlotNumber() {
        for (ContainerSection containerSection : this.slotRefs.keySet()) {
            for (Slot slot : this.slotRefs.get((Object)containerSection)) {
                if (!this.isBasicSlot(slot) || this.hasStack(slot)) continue;
                return this.getSlotNumber(slot);
            }
        }
        return -1;
    }

    private int indexToSlot(ContainerSection containerSection, int n) {
        if (n == -999) {
            return -999;
        }
        if (this.hasSection(containerSection)) {
            Slot slot = this.slotRefs.get((Object)containerSection).get(n);
            if (slot != null) {
                return this.getSlotNumber(slot);
            }
            return -1;
        }
        return -1;
    }

    public void setClickDelay(int n) {
        this.clickDelay = n;
    }
}

