/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfigInventoryRuleset;
import invtweaks.InvTweaksConfigProperties;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeItem;
import invtweaks.InvTweaksItemTreeLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class InvTweaksConfig {
    private static final Logger log = Logger.getLogger("InvTweaks");
    public static final String PROP_VERSION = "version";
    public static final String PROP_ENABLE_MIDDLE_CLICK = "enableMiddleClick";
    public static final String PROP_SHOW_CHEST_BUTTONS = "showChestButtons";
    public static final String PROP_ENABLE_SORTING_ON_PICKUP = "enableSortingOnPickup";
    public static final String PROP_ENABLE_AUTO_EQUIP_ARMOR = "enableAutoEquipArmor";
    public static final String PROP_ENABLE_AUTO_REFILL = "enableAutoRefill";
    public static final String PROP_AUTO_REFILL_BEFORE_BREAK = "autoRefillBeforeBreak";
    public static final String PROP_AUTO_REFILL_DAMAGE_THRESHHOLD = "autoRefillDamageThreshhold";
    public static final String PROP_KEY_SORT_INVENTORY = "keySortInventory";
    public static final String PROP_ENABLE_SHORTCUTS = "enableShortcuts";
    public static final String PROP_SHORTCUT_PREFIX = "shortcutKey";
    public static final String PROP_SHORTCUT_ONE_ITEM = "shortcutKeyOneItem";
    public static final String PROP_OBSOLETE_SHORTCUT_ONE_STACK = "shortcutKeyOneStack";
    public static final String PROP_SHORTCUT_ALL_ITEMS = "shortcutKeyAllItems";
    public static final String PROP_SHORTCUT_EVERYTHING = "shortcutKeyEverything";
    public static final String PROP_SHORTCUT_DROP = "shortcutKeyDrop";
    public static final String PROP_SHORTCUT_UP = "shortcutKeyToUpperSection";
    public static final String PROP_SHORTCUT_DOWN = "shortcutKeyToLowerSection";
    public static final String PROP_ENABLE_SOUNDS = "enableSounds";
    public static final String PROP_OBSOLETE_ENABLE_SORTING_SOUND = "enableSortingSound";
    public static final String PROP_OBSOLETE_ENABLE_AUTO_REFILL_SOUND = "enableAutoRefillSound";
    public static final String PROP_ENABLE_FORGE_ITEMTREE = "enableForgeTreeAdditions";
    public static final String PROP_ENABLE_SERVER_ITEMSWAP = "enableServerItemSwap";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_CI_COMPATIBILITY = "convenientInventoryCompatibility";
    public static final String LOCKED = "locked";
    public static final String FROZEN = "frozen";
    public static final String AUTOREFILL = "autorefill";
    public static final String AUTOREFILL_NOTHING = "nothing";
    public static final String DEBUG = "debug";
    public static final boolean DEFAULT_AUTO_REFILL_BEHAVIOUR = true;
    private String rulesFile;
    private String treeFile;
    private InvTweaksConfigProperties properties;
    private InvTweaksItemTree tree;
    private Vector<InvTweaksConfigInventoryRuleset> rulesets;
    private int currentRuleset = 0;
    private String currentRulesetName = null;
    private Vector<String> invalidKeywords;
    private int sortKeyCode;
    private long storedConfigLastModified;

    public InvTweaksConfig(String string, String string2) {
        this.rulesFile = string;
        this.treeFile = string2;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        InvTweaksConfig invTweaksConfig = this;
        synchronized (invTweaksConfig) {
            this.reset();
            this.loadProperties();
            this.saveProperties();
            if (this.tree != null) {
                MinecraftForge.EVENT_BUS.unregister((Object)this.tree);
            }
            this.tree = InvTweaksItemTreeLoader.load(this.treeFile);
            File file = new File(this.rulesFile);
            char[] cArray = new char[(int)file.length()];
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                fileReader.read(cArray);
            }
            finally {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            String[] stringArray = String.valueOf(cArray).replace("\r\n", "\n").replace('\r', '\n').split("\n");
            InvTweaksConfigInventoryRuleset invTweaksConfigInventoryRuleset = new InvTweaksConfigInventoryRuleset(this.tree, "Default");
            boolean bl = true;
            boolean bl2 = true;
            for (String string : stringArray) {
                String string2 = string.trim();
                if (string2.isEmpty()) continue;
                if (string2.matches("^[\\w]*[\\s]*\\:$")) {
                    if (!bl || !bl2) {
                        invTweaksConfigInventoryRuleset.finalizeRules();
                        this.rulesets.add(invTweaksConfigInventoryRuleset);
                    }
                    invTweaksConfigInventoryRuleset = new InvTweaksConfigInventoryRuleset(this.tree, string2.substring(0, string2.length() - 1));
                    continue;
                }
                try {
                    String string3 = invTweaksConfigInventoryRuleset.registerLine(string2);
                    if (bl) {
                        bl2 = false;
                    }
                    if (string3 == null) continue;
                    this.invalidKeywords.add(string3);
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            invTweaksConfigInventoryRuleset.finalizeRules();
            this.rulesets.add(invTweaksConfigInventoryRuleset);
            this.currentRuleset = 0;
            if (this.currentRulesetName != null) {
                int n = 0;
                for (InvTweaksConfigInventoryRuleset invTweaksConfigInventoryRuleset2 : this.rulesets) {
                    if (invTweaksConfigInventoryRuleset2.getName().equals(this.currentRulesetName)) {
                        this.currentRuleset = n;
                        break;
                    }
                    ++n;
                }
            }
            if (this.currentRuleset == 0) {
                this.currentRulesetName = !this.rulesets.isEmpty() ? this.rulesets.get(this.currentRuleset).getName() : null;
            }
        }
    }

    public boolean refreshProperties() throws IOException {
        long l = new File(InvTweaksConst.CONFIG_PROPS_FILE).lastModified();
        if (this.storedConfigLastModified != l) {
            this.storedConfigLastModified = l;
            this.loadProperties();
            return true;
        }
        return false;
    }

    public void saveProperties() {
        File file = this.getPropertyFile();
        if (file.exists()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.properties.store(fileOutputStream, "Inventory Tweaks Configuration\n(Regarding shortcuts, all key names can be found at: http://www.lwjgl.org/javadoc/org/lwjgl/input/Keyboard.html)");
                fileOutputStream.flush();
                fileOutputStream.close();
                this.storedConfigLastModified = new File(InvTweaksConst.CONFIG_PROPS_FILE).lastModified();
            }
            catch (IOException iOException) {
                InvTweaks.logInGameStatic("Failed to save config file " + InvTweaksConst.CONFIG_PROPS_FILE);
            }
            this.sortKeyCode = Keyboard.getKeyIndex((String)this.getProperty(PROP_KEY_SORT_INVENTORY));
        }
    }

    public Map<String, String> getProperties(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : this.properties.keySet()) {
            String string2 = (String)object;
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2, this.properties.getProperty(string2));
        }
        return hashMap;
    }

    public String getProperty(String string) {
        String string2 = this.properties.getProperty(string);
        return string2 != null ? string2 : "";
    }

    public int getIntProperty(String string) {
        return Integer.parseInt(this.getProperty(string));
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, (Object)string2);
        this.saveProperties();
        if (string.equals(PROP_ENABLE_MIDDLE_CLICK)) {
            this.resolveConvenientInventoryConflicts();
        }
    }

    public InvTweaksItemTree getTree() {
        return this.tree;
    }

    public String getCurrentRulesetName() {
        return this.currentRulesetName;
    }

    public String switchConfig(int n) {
        if (!this.rulesets.isEmpty() && n < this.rulesets.size() && n != this.currentRuleset) {
            this.currentRuleset = n;
            this.currentRulesetName = this.rulesets.get(this.currentRuleset).getName();
            return this.currentRulesetName;
        }
        return null;
    }

    public String switchConfig() {
        if (this.currentRuleset == -1) {
            return this.switchConfig(0);
        }
        return this.switchConfig((this.currentRuleset + 1) % this.rulesets.size());
    }

    public Vector<InvTweaksConfigSortingRule> getRules() {
        return this.rulesets.get(this.currentRuleset).getRules();
    }

    public Vector<String> getInvalidKeywords() {
        return this.invalidKeywords;
    }

    public int[] getLockPriorities() {
        return this.rulesets.get(this.currentRuleset).getLockPriorities();
    }

    public boolean[] getFrozenSlots() {
        return this.rulesets.get(this.currentRuleset).getFrozenSlots();
    }

    public Vector<Integer> getLockedSlots() {
        return this.rulesets.get(this.currentRuleset).getLockedSlots();
    }

    public Level getLogLevel() {
        return this.rulesets.get(this.currentRuleset).isDebugEnabled() ? Level.INFO : Level.WARNING;
    }

    public boolean isAutoRefillEnabled(int n, int n2) {
        if (!this.getProperty(PROP_ENABLE_AUTO_REFILL).equals(VALUE_FALSE)) {
            List<InvTweaksItemTreeItem> list = this.tree.getItems(n, n2);
            Vector<String> vector = this.rulesets.get(this.currentRuleset).getAutoReplaceRules();
            boolean bl = false;
            for (String string : vector) {
                if (string.equals(AUTOREFILL_NOTHING)) {
                    return false;
                }
                if (!this.tree.matches(list, string)) continue;
                bl = true;
            }
            if (bl) {
                return true;
            }
            return vector.isEmpty();
        }
        return false;
    }

    public void resolveConvenientInventoryConflicts() {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        block14: {
            bl2 = false;
            bl = false;
            try {
                AccessibleObject accessibleObject;
                object2 = Class.forName("ConvenientInventory");
                bl2 = true;
                object = null;
                try {
                    object = ((Class)object2).getDeclaredField("middleClickEnabled");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (object != null) {
                    boolean bl3 = this.getProperty(PROP_ENABLE_MIDDLE_CLICK).equals(VALUE_TRUE);
                    ((Field)object).setAccessible(true);
                    ((Field)object).setBoolean(null, !bl3);
                    break block14;
                }
                Field field = ((Class)object2).getDeclaredField("initialized");
                field.setAccessible(true);
                Boolean bl4 = (Boolean)field.get(null);
                if (!bl4.booleanValue()) {
                    accessibleObject = ((Class)object2).getDeclaredMethod("initialize", new Class[0]);
                    ((Method)accessibleObject).setAccessible(true);
                    ((Method)accessibleObject).invoke(null, new Object[0]);
                }
                accessibleObject = ((Class)object2).getDeclaredField("actionMap");
                ((Field)accessibleObject).setAccessible(true);
                List[][] listArray = (List[][])((Field)accessibleObject).get(null);
                if (listArray == null || listArray[7] == null) break block14;
                for (List list : listArray[7]) {
                    if (list == null || list.size() != 1 || (Integer)list.get(0) != 2) continue;
                    bl = true;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                InvTweaks.logInGameErrorStatic("invtweaks.modcompat.ci.error", exception);
            }
        }
        object2 = this.getProperty(PROP_ENABLE_SHORTCUTS);
        if (bl2 && !((String)object2).equals(VALUE_CI_COMPATIBILITY)) {
            this.setProperty(PROP_ENABLE_SHORTCUTS, VALUE_CI_COMPATIBILITY);
        } else if (!bl2 && ((String)object2).equals(VALUE_CI_COMPATIBILITY)) {
            this.setProperty(PROP_ENABLE_SHORTCUTS, VALUE_TRUE);
        }
        object = this.getProperty(PROP_ENABLE_MIDDLE_CLICK);
        if (bl && !((String)object).equals(VALUE_CI_COMPATIBILITY)) {
            this.setProperty(PROP_ENABLE_MIDDLE_CLICK, VALUE_CI_COMPATIBILITY);
        } else if (!bl && ((String)object).equals(VALUE_CI_COMPATIBILITY)) {
            this.setProperty(PROP_ENABLE_MIDDLE_CLICK, VALUE_TRUE);
        }
    }

    private void reset() {
        this.rulesets = new Vector();
        this.currentRuleset = -1;
        this.properties = new InvTweaksConfigProperties();
        this.properties.put(PROP_ENABLE_MIDDLE_CLICK, (Object)VALUE_TRUE);
        this.properties.put(PROP_SHOW_CHEST_BUTTONS, (Object)VALUE_TRUE);
        this.properties.put(PROP_ENABLE_SORTING_ON_PICKUP, (Object)VALUE_FALSE);
        this.properties.put(PROP_ENABLE_AUTO_REFILL, (Object)VALUE_TRUE);
        this.properties.put(PROP_AUTO_REFILL_BEFORE_BREAK, (Object)VALUE_FALSE);
        this.properties.put(PROP_AUTO_REFILL_DAMAGE_THRESHHOLD, (Object)"5");
        this.properties.put(PROP_ENABLE_SOUNDS, (Object)VALUE_TRUE);
        this.properties.put(PROP_ENABLE_SHORTCUTS, (Object)VALUE_TRUE);
        this.properties.put(PROP_ENABLE_AUTO_EQUIP_ARMOR, (Object)VALUE_FALSE);
        this.properties.put(PROP_ENABLE_FORGE_ITEMTREE, (Object)VALUE_TRUE);
        this.properties.put(PROP_ENABLE_SERVER_ITEMSWAP, (Object)VALUE_TRUE);
        this.properties.put(PROP_KEY_SORT_INVENTORY, (Object)"R");
        this.properties.put(PROP_SHORTCUT_ALL_ITEMS, (Object)"LCONTROL+LSHIFT, RCONTROL+RSHIFT");
        this.properties.put(PROP_SHORTCUT_EVERYTHING, (Object)"SPACE");
        this.properties.put(PROP_SHORTCUT_ONE_ITEM, (Object)"LCONTROL, RCONTROL");
        this.properties.put(PROP_SHORTCUT_UP, (Object)"UP");
        this.properties.put(PROP_SHORTCUT_DOWN, (Object)"DOWN");
        this.properties.put(PROP_SHORTCUT_DROP, (Object)"LALT, RALT");
        this.properties.put(PROP_VERSION, (Object)"1.53".split(" ")[0]);
        this.invalidKeywords = new Vector();
    }

    private void loadProperties() throws IOException {
        File file = this.getPropertyFile();
        InvTweaksConfigProperties invTweaksConfigProperties = new InvTweaksConfigProperties();
        if (file != null) {
            FileInputStream fileInputStream = new FileInputStream(file);
            invTweaksConfigProperties.load(fileInputStream);
            fileInputStream.close();
            this.resolveConvenientInventoryConflicts();
        }
        invTweaksConfigProperties.sortKeys();
        invTweaksConfigProperties.remove(PROP_OBSOLETE_ENABLE_SORTING_SOUND);
        invTweaksConfigProperties.remove(PROP_OBSOLETE_ENABLE_AUTO_REFILL_SOUND);
        invTweaksConfigProperties.remove(PROP_OBSOLETE_SHORTCUT_ONE_STACK);
        if (invTweaksConfigProperties.get(PROP_VERSION) != null) {
            for (Map.Entry entry : invTweaksConfigProperties.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
            if (this.properties.contains("enableAutoreplaceSound")) {
                this.properties.put(PROP_OBSOLETE_ENABLE_AUTO_REFILL_SOUND, this.properties.get("enableAutoreplaceSound"));
                this.properties.remove("enableAutoreplaceSound");
            }
        }
    }

    private File getPropertyFile() {
        File file = new File(InvTweaksConst.CONFIG_PROPS_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                InvTweaks.logInGameStatic("invtweaks.propsfile.errors");
                return null;
            }
        }
        return file;
    }

    public int getSortKeyCode() {
        return this.sortKeyCode;
    }
}

