/*
 * Decompiled with CFR 0.152.
 */
package kes5219.utils.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import kes5219.utils.misc.Triple;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ObjLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadObjToDisplaylist(InputStream stream) {
        ArrayList<Triple> vertices = new ArrayList<Triple>();
        ArrayList<Triple> texCoords = new ArrayList<Triple>();
        ArrayList<Triple> normals = new ArrayList<Triple>();
        ArrayList<Triple> faceDef = new ArrayList<Triple>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                String[] splitStrings;
                String splitString1;
                String[] splitString;
                if (line.startsWith("#")) continue;
                if (line.startsWith("vt")) {
                    splitString = line.split("\\s+");
                    texCoords.add(new Triple(new Float(splitString[1]), new Float(splitString[2])));
                    continue;
                }
                if (line.startsWith("vn")) {
                    splitString = line.split("\\s+");
                    normals.add(new Triple(new Float(splitString[1]), new Float(splitString[2]), new Float(splitString[3])));
                    continue;
                }
                if (line.startsWith("v")) {
                    splitString = line.split("\\s+");
                    vertices.add(new Triple(new Float(splitString[1]), new Float(splitString[2]), new Float(splitString[3])));
                    continue;
                }
                if (!line.startsWith("f")) continue;
                splitString = line.split("\\s+");
                for (int count = 1; count < 4; ++count) {
                    splitString1 = splitString[count];
                    splitStrings = splitString1.split("/");
                    int vertexIndex = 0;
                    int texCoordIndex = 0;
                    int normalIndex = 0;
                    vertexIndex = Integer.parseInt(splitStrings[0]);
                    texCoordIndex = Integer.parseInt(splitStrings[1]);
                    normalIndex = Integer.parseInt(splitStrings[2]);
                    faceDef.add(new Triple(vertexIndex, texCoordIndex, normalIndex));
                }
                if (splitString.length != 5) continue;
                Triple firstVertex = (Triple)faceDef.get(faceDef.size() - 3);
                Triple lastVertex = (Triple)faceDef.get(faceDef.size() - 1);
                splitString1 = splitString[4];
                splitStrings = splitString1.split("/");
                int vertexIndex = 0;
                int texCoordIndex = 0;
                int normalIndex = 0;
                vertexIndex = Integer.parseInt(splitStrings[0]);
                texCoordIndex = Integer.parseInt(splitStrings[1]);
                normalIndex = Integer.parseInt(splitStrings[2]);
                Triple fourthVertex = new Triple(vertexIndex, texCoordIndex, normalIndex);
                faceDef.add(firstVertex);
                faceDef.add(lastVertex);
                faceDef.add(fourthVertex);
            }
        }
        catch (IOException e) {
            int splitString = 0;
            return splitString;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int splitString = 0;
            return splitString;
        }
        catch (NumberFormatException e) {
            int splitString = 0;
            return splitString;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int displayListIndex = GL11.glGenLists((int)1);
        if (displayListIndex == 0) {
            return 0;
        }
        int arraySize = faceDef.size();
        ArrayList vertexArrayList = new ArrayList();
        for (int i = 0; i < arraySize; ++i) {
            int index = (Integer)((Triple)faceDef.get((int)i)).first;
            vertexArrayList.add(vertices.get(index - 1));
        }
        float[] vertexArray = new float[vertexArrayList.size() * 3];
        for (int i = 0; i < vertexArrayList.size(); ++i) {
            vertexArray[i * 3] = ((Float)((Triple)vertexArrayList.get((int)i)).first).floatValue();
            vertexArray[i * 3 + 1] = ((Float)((Triple)vertexArrayList.get((int)i)).second).floatValue();
            vertexArray[i * 3 + 2] = ((Float)((Triple)vertexArrayList.get((int)i)).third).floatValue();
        }
        FloatBuffer vertexPointer = BufferUtils.createFloatBuffer((int)vertexArray.length);
        vertexPointer.put(vertexArray);
        vertexPointer.flip();
        ArrayList texCoordArrayList = new ArrayList();
        for (int i = 0; i < arraySize; ++i) {
            int index = (Integer)((Triple)faceDef.get((int)i)).second;
            texCoordArrayList.add(texCoords.get(index - 1));
        }
        float[] texCoordArray = new float[texCoordArrayList.size() * 2];
        for (int i = 0; i < texCoordArrayList.size(); ++i) {
            texCoordArray[i * 2] = ((Float)((Triple)texCoordArrayList.get((int)i)).first).floatValue() / 16.0f;
            texCoordArray[i * 2 + 1] = ((Float)((Triple)texCoordArrayList.get((int)i)).second).floatValue() / 16.0f;
        }
        FloatBuffer texCoordPointer = BufferUtils.createFloatBuffer((int)texCoordArray.length);
        texCoordPointer.put(texCoordArray);
        texCoordPointer.flip();
        ArrayList normalArrayList = new ArrayList();
        for (int i = 0; i < arraySize; ++i) {
            int index = (Integer)((Triple)faceDef.get((int)i)).third;
            normalArrayList.add(normals.get(index - 1));
        }
        float[] normalArray = new float[normalArrayList.size() * 3];
        for (int i = 0; i < normalArrayList.size(); ++i) {
            normalArray[i * 3] = ((Float)((Triple)normalArrayList.get((int)i)).first).floatValue();
            normalArray[i * 3 + 1] = ((Float)((Triple)normalArrayList.get((int)i)).second).floatValue();
            normalArray[i * 3 + 2] = ((Float)((Triple)normalArrayList.get((int)i)).third).floatValue();
        }
        FloatBuffer normalPointer = BufferUtils.createFloatBuffer((int)normalArray.length);
        normalPointer.put(normalArray);
        normalPointer.flip();
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)vertexPointer);
        GL11.glEnableClientState((int)32888);
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)texCoordPointer);
        GL11.glEnableClientState((int)32885);
        GL11.glNormalPointer((int)0, (FloatBuffer)normalPointer);
        GL11.glNewList((int)displayListIndex, (int)4864);
        GL11.glDrawArrays((int)4, (int)0, (int)arraySize);
        GL11.glEndList();
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32885);
        return displayListIndex;
    }
}

