package net.minecraft.src;

import net.minecraft.client.Minecraft;

public class mod_keepInventory extends BaseMod{
	
	//Version
	@Override
	public String getVersion() {
		return "SSP 1.0";
	}
	
	//Setting up the mod;
	public mod_keepInventory(){
		//Set the in game hooks for performing events...
		//OnTickInGui(...) and OnTickInGame(...)
		//On each frame update of the game (respectively when the player is looking at a menu/in a world)
		ModLoader.SetInGUIHook(this, true, false);
		ModLoader.SetInGameHook(this, true, false);
	}
	//Player's special inventory, doesn't drop items, when you die, and a record of it is kept for the Minecraft world;
    public InventoryPlayer_KeepItems playersSpecialInventory=null;
    
    
    //Perform this function, each update tick, that the player is in a menu.
    @Override
	public boolean OnTickInGUI(float f,Minecraft minecraft, GuiScreen guiscreen){
    	//If the player is in a single player world
    	if(minecraft!=null){
    		/*Perform a function which:
    		replaces the player's normal inventory with a special inventory that doesn't drop items
    		(if it hasn't been already);
    		*/
    		ensureInventoryKept(minecraft);

    	}
    	return true;
    }
    
    //On each game update tick, if the game isn't paused 
    @Override
	public boolean OnTickInGame(float f,Minecraft minecraft){
    	//Basically copy and paste of the code in the method above
       	if(minecraft!=null){
    		ensureInventoryKept(minecraft);
    	}
        return true;
    }
    
    /*NOTE: The reason the function ensureInventoryKept() is executed both in onTickInGame(...) and onTickInGUI();
    is to cover all possible states that the game is in.
    */
    
    
    
    /*HERE'S THE IMPORTANT FUNCTION.
     *It ensures that the player's inventory retains its item and is made persistent, when the player dies.
     */
    ISaveHandler prevSaveHandler=null;
    public void ensureInventoryKept(Minecraft minecraft){


    		//Get the current Minecraft world;
    		World world=minecraft.theWorld;
    		//Double check that the world and player exist;
    		if(minecraft!=null && world!=null){
    			//Can't perform this function UNLESS the world is in single player mode;
    			if(world.isRemote)
    				return;
    			//Get the current player
				EntityPlayerSP currentPlayer =minecraft.thePlayer;
				//Check the player exists, if not than return;
				if(minecraft.thePlayer==null){
					return;
				}
				//Check that the player's inventory (if it exists), is already an instance of the special inventory that doesn't drop items.
    			if(currentPlayer.inventory!=null && !(currentPlayer.inventory instanceof InventoryPlayer_KeepItems)){
    				//If the inventory, corresponding to this world's SaveHandler doesn't exist that create it.
    				
    				if(playersSpecialInventory==null || playersSpecialInventory.saveHandler!=world.saveHandler){
    					//Than create it:
    					playersSpecialInventory=new InventoryPlayer_KeepItems(currentPlayer.inventory,world.saveHandler);
    					/*NOTE: Minecraft actually creates a new world object each time the player switches dimensions (e.g. earth->Nether),
    					 * but they all share the same ISaveHandler object.
        				Hence why we use the SaveHandler instead of the world!*/
    				}
    				
    				
					//Replace the player's inventory, with a special inventory, tracked by the mod
    				//That won't lose items on death;
					currentPlayer.inventory=playersSpecialInventory;
					//Make sure the inventory slots and inventory crafting are updated too.
    				currentPlayer.inventorySlots = new ContainerPlayer(currentPlayer.inventory, !world.isRemote);
    				currentPlayer.craftingInventory=currentPlayer.inventorySlots;
    				playersSpecialInventory.player=currentPlayer;

    			}
    		}
    }

	@Override
	public void load() {
		//Nothing to do here, this was just to implement the abstract method of the super class.
	}
}
