

package net.minecraft.src;

//------CLASS PURPOSE: To provide a subtype of the InventoryPlayer class that doesn't lose items---- 
public class InventoryPlayer_KeepItems extends InventoryPlayer {
	//What world save-handler this inventory belongs to
	public ISaveHandler saveHandler=null;
	
	//Constructor method
	public InventoryPlayer_KeepItems(InventoryPlayer oldInventory,ISaveHandler saveHandler){
		//This inventory will belong to the inventory of the old player;
		super(oldInventory.player);
		//Copy over ALL the key data from the old player inventory
	    mainInventory=oldInventory.mainInventory;
	    armorInventory=oldInventory.armorInventory;
	    currentItem=oldInventory.currentItem;
	    setItemStack(oldInventory.getItemStack());
	    inventoryChanged=oldInventory.inventoryChanged;
	    //Set the save handler that this inventory belongs to; to the save handler of the current world
	    this.saveHandler=saveHandler;
	    
	}
	

	
	//Method from parent overridden so you can keep your items on death!
	@Override
    public void dropAllItems()
    {
		/*Now you can go back and exact vengeance, on that last group of skeleton archers/blaze gaurdians who murdered you,
		  WITHOUT the hassle of reorganizing your inventory;*/
    	return;
    }
	@Override
	public void decrementAnimations(){
		super.decrementAnimations();

	}

}
