/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.extendedWorkbench;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import naruto1310.extendedWorkbench.mod_ExtendedWorkbench;

public class EWConfig {
    private static final String fileName = "/config/ExtendedWorkbench.cfg";
    private static final File file = new File(mod_ExtendedWorkbench.proxy.getMinecraftDir() + "/config/ExtendedWorkbench.cfg");
    private static Map values;

    public static void load() {
        values = new TreeMap();
        try {
            Scanner scan = new Scanner(file);
            while (scan.hasNext()) {
                String s = scan.nextLine();
                if (s.startsWith("#") || s.isEmpty()) continue;
                if (s.contains("=")) {
                    s = s.replace(" ", "");
                    values.put(s.substring(0, s.indexOf("=")), s.substring(s.indexOf("=") + 1, s.length()));
                    continue;
                }
                System.out.println("Extended Workbench config found unexpected line: " + s);
            }
            scan.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Extended Workbench could not find config. Generating one.");
        }
    }

    public static void save() {
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            output.write("# Extended Workbench configuration file");
            output.newLine();
            output.write("#           mod by Naruto1310          ");
            output.newLine();
            for (int i = 0; i < values.size(); ++i) {
                String value = values.values().toArray()[i].toString();
                if (value.contains(":")) {
                    output.newLine();
                    output.write("# " + value.substring(value.indexOf(":") + 1));
                    output.newLine();
                    value = value.substring(0, value.indexOf(":"));
                }
                output.write(values.keySet().toArray()[i] + " = " + value);
                output.newLine();
            }
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getOrCreateValue(String key, Object defaultValue, String comment) {
        if (!values.containsKey(key)) {
            values.put(key, defaultValue.toString());
        }
        if (comment != null) {
            String value = (String)values.get(key);
            values.remove(key);
            values.put(key, value + ":" + comment);
            return value;
        }
        return (String)values.get(key);
    }

    public static String getOrCreateValue(String key, String defaultValue) {
        return EWConfig.getOrCreateValue(key, defaultValue, null);
    }
}

