package atomicstryker.kenshiro.common;

import atomicstryker.ForgePacketWrapper;
import atomicstryker.kenshiro.client.KenshiroClient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.NetHandler;
import net.minecraft.src.NetLoginHandler;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet1Login;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;

public class ConnectionHandler implements IConnectionHandler
{

    @Override
    public void playerLoggedIn(Player player, NetHandler netHandler, NetworkManager manager)
    {
        KenshiroServer.instance().setClientHasKenshiroInstalled(player, false);
    }

    @Override
    public String connectionReceived(NetLoginHandler netHandler, NetworkManager manager)
    {
        return null;
    }

    @Override
    public void connectionOpened(NetHandler netClientHandler, String server, int port, NetworkManager manager)
    {
    }

    @Override
    public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, NetworkManager manager)
    {
    }

    @Override
    public void connectionClosed(NetworkManager manager)
    {
    }

    @Override
    public void clientLoggedIn(NetHandler clientHandler, NetworkManager manager, Packet1Login login)
    {
        KenshiroClient.instance().setServerHasKenshiroInstalled(false);
        PacketDispatcher.sendPacketToServer(ForgePacketWrapper.createPacket("AS_KSM", PacketType.HANDSHAKE.ordinal(), null));
    }

}
