/*
 * Decompiled with CFR 0.152.
 */
package org.newthead.christmas;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraftforge.common.Configuration;
import org.newthead.christmas.ModSetup;
import org.newthead.christmas.PresentRecipe;
import org.newthead.christmas.blocks.BlockChristmasLight;
import org.newthead.christmas.blocks.BlockChristmasPresent;
import org.newthead.christmas.blocks.BlockChristmasStar;
import org.newthead.christmas.blocks.BlockChristmasStocking;
import org.newthead.christmas.blocks.BlockFruitcake;
import org.newthead.christmas.blocks.BlockOrnament;
import org.newthead.christmas.blocks.BlockTreestand;
import org.newthead.christmas.blocks.BlockWreath;
import org.newthead.christmas.entities.EntityCreeperClaus;
import org.newthead.christmas.entities.EntityEnderElf;
import org.newthead.christmas.items.ItemChristmas;
import org.newthead.christmas.items.ItemChristmasDrink;
import org.newthead.christmas.items.ItemChristmasFood;
import org.newthead.christmas.items.ItemChristmasLight;
import org.newthead.christmas.items.ItemChristmasPresent;
import org.newthead.christmas.items.ItemChristmasRecord;
import org.newthead.christmas.items.ItemChristmasStocking;
import org.newthead.christmas.items.ItemFruitcake;
import org.newthead.christmas.items.ItemOrnament;
import org.newthead.christmas.items.ItemTreestand;

@Mod(modid="ChristmasCraft", name="ChristmasCraft", version="2.0.3")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class ChristmasCraft {
    @Mod.Instance(value="ChristmasCraft")
    public static ChristmasCraft instance;
    public static Configuration config;
    private static boolean forceChristmasTime;
    private static boolean allowGiftception;
    private static Calendar calendar;
    @SidedProxy(clientSide="org.newthead.christmas.ClientModSetup", serverSide="org.newthead.christmas.ModSetup")
    public static ModSetup setup;
    public static final String TERRAIN_PNG = "/org/newthead/christmas/terrain.png";
    public static final String ITEM_PNG = "/org/newthead/christmas/items.png";
    private static int christmasLightOffBlockId;
    public static amj blockChristmasLightOff;
    private static int christmasLightOnBlockId;
    public static amj blockChristmasLightOn;
    private static int wreathBlockId;
    public static amj blockWreath;
    private static int fruitcakeBlockId;
    public static amj blockFruitcake;
    private static int stockingBlockId;
    public static amj blockStocking;
    private static int ornamentBlockId;
    public static amj blockOrnament;
    private static int treestandBlockId;
    public static amj blockTreestand;
    private static int presentBlockId;
    public static amj blockPresent;
    private static int christmasStarId;
    public static amj blockChristmasStar;
    private static int christmasSpiceId;
    public static uk itemChristmasSpice;
    private static int chocolateMilkId;
    public static uk itemChocolateMilk;
    private static int hotCocoaId;
    public static uk itemHotCocoa;
    private static int candycaneId;
    public static uk itemCandycane;
    private static int gingerbreadId;
    public static uk itemGingerbread;
    private static int eggnogId;
    public static uk itemEggnog;
    private static int fruitcakeId;
    public static uk itemFruitcake;
    private static int xmasDisc1Id;
    public static uk recordWish;
    private static int xmasDisc2Id;
    public static uk recordCarol;
    private static int xmasDisc3Id;
    public static uk recordJingle;
    private static Random random;
    public static um[] stockingPresents;
    public static um[] treePresents;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        this.loadConfiguration(event);
        setup.registerSounds();
    }

    private void loadConfiguration(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        forceChristmasTime = config.get("general", "forceChristmasTime", false).getBoolean(false);
        allowGiftception = config.get("general", "allowGiftsInsideGifts", false).getBoolean(false);
        christmasLightOffBlockId = config.getBlock("xmasLightOffBlockIndex", 1230).getInt();
        christmasLightOnBlockId = config.getBlock("xmasLightOnBlockIndex", 1231).getInt();
        wreathBlockId = config.getBlock("wreathBlockIndex", 1232).getInt();
        fruitcakeBlockId = config.getBlock("fruitcakeBlockIndex", 1233).getInt();
        stockingBlockId = config.getBlock("stockingBlockIndex", 1234).getInt();
        ornamentBlockId = config.getBlock("ornamentBlockIndex", 1235).getInt();
        treestandBlockId = config.getBlock("treestandBlockIndex", 1236).getInt();
        presentBlockId = config.getBlock("presentBlockIndex", 1237).getInt();
        christmasStarId = config.getBlock("christmasStarBlockIndex", 1238).getInt();
        christmasSpiceId = config.getItem("christmasSpiceItemIndex", 25120).getInt();
        chocolateMilkId = config.getItem("chocolateMilkItemIndex", 25121).getInt();
        hotCocoaId = config.getItem("hotCocoaItemIndex", 25122).getInt();
        candycaneId = config.getItem("candycaneItemIndex", 25123).getInt();
        gingerbreadId = config.getItem("gingerbreadItemIndex", 25124).getInt();
        eggnogId = config.getItem("eggnogItemIndex", 25125).getInt();
        fruitcakeId = config.getItem("fruitcakeItemIndex", 25126).getInt();
        xmasDisc1Id = config.getItem("recordWishIndex", 25128).getInt();
        xmasDisc2Id = config.getItem("recordCarolIndex", 25129).getInt();
        xmasDisc3Id = config.getItem("recordJingleIndex", 25130).getInt();
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        setup.registerTextures();
        this.createBlocks();
        GameRegistry.registerBlock((amj)blockChristmasLightOff, ItemChristmasLight.class);
        GameRegistry.registerBlock((amj)blockChristmasLightOn, ItemChristmasLight.class);
        GameRegistry.registerBlock((amj)blockWreath);
        GameRegistry.registerBlock((amj)blockFruitcake);
        GameRegistry.registerBlock((amj)blockStocking, ItemChristmasStocking.class);
        GameRegistry.registerBlock((amj)blockOrnament, ItemOrnament.class);
        GameRegistry.registerBlock((amj)blockTreestand, ItemTreestand.class);
        GameRegistry.registerBlock((amj)blockPresent, ItemChristmasPresent.class);
        GameRegistry.registerBlock((amj)blockChristmasStar);
        this.createItems();
        setup.registerTileEntities();
        setup.registerEntities();
        setup.registerCraftingRecipes();
        setup.registerRenderers();
        setup.registerItemNames();
        setup.registerTickHandlers();
    }

    private void createBlocks() {
        blockChristmasLightOff = new BlockChristmasLight(christmasLightOffBlockId, new int[]{51, 49, 48, 52, 50}, false).c(0.1f).b("xmasLight").a(th.d);
        blockChristmasLightOn = new BlockChristmasLight(christmasLightOnBlockId, new int[]{67, 65, 64, 68, 66}, true).c(0.1f).b("xmasLight").a(th.d);
        blockWreath = new BlockWreath(wreathBlockId, 13).c(0.2f).b("wreath").a(th.c);
        blockFruitcake = new BlockFruitcake(fruitcakeBlockId, 16).c(0.5f).a(amj.k).b("fruitcake");
        blockStocking = new BlockChristmasStocking(stockingBlockId, 20).r().b("stocking").a(th.c);
        blockOrnament = new BlockOrnament(ornamentBlockId, 14).c(0.1f).b("ornament").a(th.c);
        blockTreestand = new BlockTreestand(treestandBlockId, 25).c(2.0f).b(5.0f).b("treestand").a(th.c);
        blockPresent = new BlockChristmasPresent(presentBlockId, 0).c(2.0f).b(3.0f).b("xmasGift");
        blockChristmasStar = new BlockChristmasStar(christmasStarId, 12).b("xmasStar").a(th.c);
    }

    private void createItems() {
        itemChristmasSpice = new ItemChristmas(christmasSpiceId, 5).b("xmasSpice").a(th.h);
        itemChocolateMilk = new ItemChristmasDrink(chocolateMilkId, 1, 3, 0.3f).b("chocolateMilk").a(th.h);
        itemHotCocoa = new ItemChristmasDrink(hotCocoaId, 2, 8, 0.8f).b("hotCocoa").a(th.h);
        itemCandycane = new ItemChristmasFood(candycaneId, 0, 2, 0.6f).b("candycane").a(th.h);
        itemGingerbread = new ItemChristmasFood(gingerbreadId, 4, 1, 0.1f).b("gingerbread").a(th.h);
        itemEggnog = new ItemChristmasDrink(eggnogId, 3, 5, 0.6f).j().a(ll.k.H, 20, 0, 0.4f).b("eggnog").a(th.h);
        itemFruitcake = new ItemFruitcake(fruitcakeId).d(1).b("fruitcake").a(th.h);
        recordWish = new ItemChristmasRecord(xmasDisc1Id, "christmas.wish", "We Wish You a Merry Christmas").c(32).b("record").a(th.f);
        recordCarol = new ItemChristmasRecord(xmasDisc2Id, "christmas.carol", "Carol of the Bells").c(33).b("record").a(th.f);
        recordJingle = new ItemChristmasRecord(xmasDisc3Id, "christmas.jingle", "Jingle Bells").c(34).b("record").a(th.f);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        this.editWorldGen();
        this.populatePresentLists();
    }

    private void editWorldGen() {
        if (!ChristmasCraft.isChristmasTime()) {
            return;
        }
        for (int i = 0; i < yr.a.length; ++i) {
            if (yr.a[i] == null) continue;
            yr biome = yr.a[i];
            if (!(biome.F <= 1.0f) || biome instanceof zj || biome instanceof zf || biome instanceof zb || biome instanceof zl || biome instanceof ze || biome instanceof yq || biome instanceof zi) continue;
            biome.F = 0.0f;
            biome.b();
            EntityRegistry.addSpawn(EntityCreeperClaus.class, (int)5, (int)1, (int)1, (me)me.b, (yr[])new yr[]{biome});
            EntityRegistry.addSpawn(EntityEnderElf.class, (int)1, (int)1, (int)4, (me)me.a, (yr[])new yr[]{biome});
            EntityRegistry.removeSpawn(qd.class, (me)me.a, (yr[])new yr[]{biome});
        }
    }

    public static boolean isChristmasTime() {
        if (forceChristmasTime) {
            return true;
        }
        calendar.setTime(new Date());
        return calendar.get(2) == 11;
    }

    public static boolean isChristmasDay() {
        calendar.setTime(new Date());
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean canWrapGiftsInsideGifts() {
        return allowGiftception;
    }

    public static um getRandomStockingGift() {
        return PresentRecipe.createPresentFromItemStack(stockingPresents[random.nextInt(stockingPresents.length)]);
    }

    public static um getRandomTreeGift() {
        return PresentRecipe.createPresentFromItemStack(treePresents[random.nextInt(treePresents.length)]);
    }

    private void populatePresentLists() {
        stockingPresents = new um[]{new um(uk.j), new um(uk.aE), new um(uk.aL), new um(uk.U), new um(uk.m), new um(uk.aQ), new um(uk.aR), new um(uk.as), new um(uk.aS), new um(recordWish), new um(recordCarol), new um(recordJingle), new um(uk.aA), new um(uk.aM), new um(uk.bB), new um(itemCandycane), new um(itemGingerbread), new um(uk.h), new um(uk.ag), new um(uk.ad), new um(uk.P), new um(uk.af), new um(uk.g), new um(uk.ae), new um(uk.f), new um(uk.q), new um(uk.bH), new um(uk.bP)};
        treePresents = new um[]{new um(uk.at), new um(uk.C), new um(uk.ak), new um(uk.n), new um(uk.ah), new um(uk.Q), new um(uk.aj), new um(uk.B), new um(uk.ai), new um(uk.A), new um(uk.z), new um(uk.bB), new um(amj.Y), new um(amj.ak), new um(amj.al), new um(amj.bH), new um(uk.by), new um(uk.bo), new um(uk.bA), new um(blockFruitcake)};
    }

    static {
        forceChristmasTime = false;
        allowGiftception = false;
        calendar = Calendar.getInstance();
        random = new Random();
    }
}

