/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;

public class WorldGenAutumnTree
extends adj {
    private static apa trunkBlock = apa.N;
    private static int trunkMetadata = 1;
    private static wm brownLeaves;
    private static wm orangeLeaves;
    private static wm purpleLeaves;
    private static wm yellowLeaves;
    private static final int BASE_HEIGHT = 4;
    private static final int CANOPY_HEIGHT = 3;
    private static final int CANOPY_RADIUS_EXTRA_RADIUS = 0;
    private static final int MAX_VARIANCE_HEIGHT = 2;
    protected final AutumnTreeType type;

    private static boolean isBlockSuitableForGrowing(aab world, int x, int y, int z) {
        int id = world.a(x, y, z);
        return TreeSoilRegistry.isValidSoil(id);
    }

    private static boolean isRoomToGrow(aab world, int x, int y, int z, int height) {
        for (int i = y; i <= y + 1 + height; ++i) {
            if (i < 0 || i >= 256) {
                return false;
            }
            int radius = 1;
            if (i == y) {
                radius = 0;
            }
            if (i >= y + 1 + height - 2) {
                radius = 2;
            }
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    int id = world.a(x1, i, z1);
                    if (apa.r[id] == null || apa.r[id].isLeaves(world, x1, i, z1) || id == apa.y.cz || apa.r[id].isWood(world, x1, i, z1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void setTrunkBlock(apa block, int metadata) {
        trunkBlock = block;
        trunkMetadata = metadata;
    }

    public WorldGenAutumnTree(boolean doBlockNotify, AutumnTreeType type) {
        super(doBlockNotify);
        this.type = type;
    }

    public boolean a(aab world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(3) + 4;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        if (!WorldGenAutumnTree.isBlockSuitableForGrowing(world, x, y - 1, z)) {
            return false;
        }
        if (!WorldGenAutumnTree.isRoomToGrow(world, x, y, z, height)) {
            return false;
        }
        world.c(x, y - 1, z, apa.z.cz);
        this.growLeaves(world, rand, x, y, z, height, this.type.getID(), this.type.getMetadata());
        this.growTrunk(world, x, y, z, height, WorldGenAutumnTree.trunkBlock.cz, trunkMetadata);
        return true;
    }

    private void growLeaves(aab world, Random rand, int x, int y, int z, int height, int leafID, int leafMeta) {
        for (int y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int canopyRow = y1 - (y + height);
            int radius = 1 - canopyRow / 2;
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                int xDistanceFromTrunk = x1 - x;
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    int zDistanceFromTrunk = z1 - z;
                    apa block = apa.r[world.a(x1, y1, z1)];
                    if (Math.abs(xDistanceFromTrunk) == radius && Math.abs(zDistanceFromTrunk) == radius && (rand.nextInt(2) == 0 || canopyRow == 0) || block != null && !block.canBeReplacedByLeaves(world, x1, y1, z1)) continue;
                    this.a(world, x1, y1, z1, leafID, leafMeta);
                }
            }
        }
    }

    private void growTrunk(aab world, int x, int y, int z, int height, int woodID, int woodMeta) {
        for (int y1 = 0; y1 < height; ++y1) {
            int id = world.a(x, y + y1, z);
            if (apa.r[id] != null && !apa.r[id].isLeaves(world, x, y + y1, z)) continue;
            this.a(world, x, y + y1, z, woodID, woodMeta);
        }
    }

    static {
        orangeLeaves = brownLeaves = new wm((apa)apa.O);
        purpleLeaves = brownLeaves;
        yellowLeaves = brownLeaves;
    }

    public static enum AutumnTreeType {
        BROWN,
        ORANGE,
        PURPLE,
        YELLOW;

        private wm leaves = new wm((apa)apa.O);
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_AUTUMN_BROWN.isPresent()) {
                AutumnTreeType.BROWN.leaves = Element.LEAVES_AUTUMN_BROWN.get();
            }
            if (Element.LEAVES_AUTUMN_ORANGE.isPresent()) {
                AutumnTreeType.ORANGE.leaves = Element.LEAVES_AUTUMN_ORANGE.get();
            }
            if (Element.LEAVES_AUTUMN_PURPLE.isPresent()) {
                AutumnTreeType.PURPLE.leaves = Element.LEAVES_AUTUMN_PURPLE.get();
            }
            if (Element.LEAVES_AUTUMN_YELLOW.isPresent()) {
                AutumnTreeType.YELLOW.leaves = Element.LEAVES_AUTUMN_YELLOW.get();
            }
            loadedCustomBlocks = true;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                AutumnTreeType.loadCustomBlocks();
            }
            return this.leaves.c;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                AutumnTreeType.loadCustomBlocks();
            }
            return this.leaves.k();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

