/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.fabrica.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.fabrica.block.BlockCustomStairs;
import extrabiomes.module.fabrica.block.BlockCustomWall;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import extrabiomes.module.fabrica.block.BlockCustomWoodSlab;
import extrabiomes.module.fabrica.block.BlockRedRockSlab;
import extrabiomes.module.fabrica.block.BlockWoodStairs;
import extrabiomes.module.fabrica.block.FuelHandlerWoodSlabs;
import extrabiomes.module.fabrica.block.ItemRedRockSlab;
import extrabiomes.module.fabrica.block.ItemWoodSlab;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.MultiItemBlock;

public enum BlockManager {
    PLANKS{

        @Override
        protected void create() {
            Stuff.planks = Optional.of((Object)((Object)new BlockCustomWood(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.PLANKS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.planks.get();
            thisBlock.c("extrabiomes.planks");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class);
            for (BlockCustomWood.BlockType type : BlockCustomWood.BlockType.values()) {
                FacadeHelper.addBuildcraftFacade(thisBlock.cz, type.metadata());
            }
            proxy.registerOre("plankWood", new wm(thisBlock, 1, -1));
            Extrabiomes.postInitEvent(new BlockActiveEvent.PlankActiveEvent(thisBlock));
        }
    }
    ,
    WOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWood = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.slabWood.get();
            thisBlock.c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock.cz));
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEWOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWoodDouble = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.slabWoodDouble.get();
            thisBlock.c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemWoodSlab.setSlabs((amr)Stuff.slabWood.get(), (amr)Stuff.slabWoodDouble.get());
            proxy.registerBlock((apa)Stuff.slabWood.get(), ItemWoodSlab.class);
            proxy.registerBlock(thisBlock, ItemWoodSlab.class);
            proxy.registerOre("slabWood", new wm((apa)Stuff.slabWood.get(), 1, -1));
            new wm((apa)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.FIR.metadata());
            new wm((apa)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.REDWOOD.metadata());
            new wm((apa)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.ACACIA.metadata());
        }
    }
    ,
    REDWOODSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedwood = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (apa)Stuff.planks.get(), BlockCustomWood.BlockType.REDWOOD.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDWOODSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.stairsRedwood.get();
            thisBlock.c("extrabiomes.stairs.redwood");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedwoodStairsActiveEvent(thisBlock));
        }
    }
    ,
    FIRSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsFir = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (apa)Stuff.planks.get(), BlockCustomWood.BlockType.FIR.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.FIRSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.stairsFir.get();
            thisBlock.c("extrabiomes.stairs.fir");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.FirStairsActiveEvent(thisBlock));
        }
    }
    ,
    ACACIASTAIRS{

        @Override
        protected void create() {
            Stuff.stairsAcacia = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (apa)Stuff.planks.get(), BlockCustomWood.BlockType.ACACIA.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.ACACIASTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.stairsAcacia.get();
            thisBlock.c("extrabiomes.stairs.acacia");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AcaciaStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRock = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.slabRedRock.get();
            thisBlock.c("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEREDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRockDouble = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEREDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.slabRedRockDouble.get();
            thisBlock.c("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            ItemRedRockSlab.setSlabs((amr)Stuff.slabRedRock.get(), (amr)Stuff.slabRedRockDouble.get());
            proxy.registerBlock((apa)Stuff.slabRedRock.get(), ItemRedRockSlab.class);
            proxy.registerBlock(thisBlock, ItemRedRockSlab.class);
        }
    }
    ,
    REDCOBBLESTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedCobble = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), apa.r[Element.RED_COBBLE.get().c], Element.RED_COBBLE.get().k())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDCOBBLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.stairsRedCobble.get();
            thisBlock.c("extrabiomes.stairs.redcobble");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedCobbleStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKBRICKSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedRockBrick = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), apa.r[Element.RED_ROCK_BRICK.get().c], Element.RED_ROCK_BRICK.get().k())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKBRICKSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.stairsRedRockBrick.get();
            thisBlock.c("extrabiomes.stairs.redrockbrick");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockBrickStairsActiveEvent(thisBlock));
        }
    }
    ,
    WALL{

        @Override
        protected void create() {
            Stuff.wall = Optional.of((Object)((Object)new BlockCustomWall(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WALL;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.wall.get();
            thisBlock.c("extrabiomes.wall");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class);
            Extrabiomes.postInitEvent(new BlockActiveEvent.WallActiveEvent(thisBlock));
        }
    };

    private boolean blockCreated = false;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BlockManager() {
    }

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (block.getSettings().getID() <= 0) continue;
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
    }

    protected abstract void create();

    protected abstract BlockSettings getSettings();

    protected abstract void prepare();

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BlockManager(1 x0) {
        this((String)x0, (int)x1);
        void x1;
    }
}

