/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.cautia.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.lib.BlockSettings;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.cautia.block.BlockQuicksand;
import extrabiomes.module.cautia.worldgen.QuicksandGenerator;
import extrabiomes.proxy.CommonProxy;

public enum BlockManager {
    QUICKSAND{

        @Override
        protected void create() {
            Stuff.quickSand = Optional.of((Object)((Object)new BlockQuicksand(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.QUICKSAND;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            apa thisBlock = (apa)Stuff.quickSand.get();
            thisBlock.c("extrabiomes.quicksand");
            proxy.setBlockHarvestLevel(thisBlock, "shovel", 0);
            proxy.registerBlock(thisBlock);
            FacadeHelper.addBuildcraftFacade(thisBlock.cz);
            proxy.registerWorldGenerator(new QuicksandGenerator(thisBlock.cz));
        }
    };

    private boolean blockCreated = false;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BlockManager() {
    }

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (block.getSettings().getID() <= 0) continue;
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
    }

    protected abstract void create();

    protected abstract BlockSettings getSettings();

    protected abstract void prepare();

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BlockManager(1 x0) {
        this((String)x0, (int)x1);
        void x1;
    }
}

