/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.forestry;

import com.google.common.base.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import extrabiomes.Extrabiomes;
import extrabiomes.api.PluginEvent;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.amica.forestry.CropProviderSapling;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidStack;

public class ForestryPlugin {
    private Object fermenterManager;
    private Object carpenterManager;
    private static boolean enabled = true;
    private ArrayList arborealCrops;
    private ArrayList plainFlowers;
    private ArrayList leafBlockIds;
    private ArrayList[] backpackItems;
    public static ArrayList loggerWindfall;
    private Optional carpenterAddRecipe = Optional.absent();
    private Optional fermenterAddRecipe = Optional.absent();
    private Optional getForestryItem = Optional.absent();
    private static Optional getForestryBlock;
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;

    static wm getBlock(String name) {
        try {
            return (wm)((Method)getForestryBlock.get()).invoke(null, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addBackPackItems() {
        Collection items = ForestryModHelper.getForesterBackPackItems();
        for (wm item : items) {
            this.backpackItems[2].add(item);
        }
        items = ForestryModHelper.getDiggerBackPackItems();
        for (wm item : items) {
            this.backpackItems[1].add(item);
        }
        if (Stuff.quickSand.isPresent()) {
            this.backpackItems[1].add(new wm((apa)Stuff.quickSand.get()));
        }
    }

    private void addBasicFlowers() {
        for (wm flower : ForestryModHelper.getBasicFlowers()) {
            this.plainFlowers.add(flower);
        }
    }

    private void addFermenterRecipeSapling(wm resource) throws Exception {
        ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 800, Float.valueOf(1.0f), this.getLiquidStack("liquidBiomass"), new LiquidStack(apa.F.cz, 1, 0));
        ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 800, Float.valueOf(1.5f), this.getLiquidStack("liquidBiomass"), this.getLiquidStack("liquidJuice"));
        ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 800, Float.valueOf(1.5f), this.getLiquidStack("liquidBiomass"), this.getLiquidStack("liquidHoney"));
    }

    private void addGlobals() {
        Collection items = ForestryModHelper.getLeaves();
        for (wm item : items) {
            this.leafBlockIds.add(item.c);
        }
    }

    private void addRecipes() throws Exception {
        if (this.fermenterAddRecipe.isPresent() && this.getForestryItem.isPresent()) {
            for (wm sapling : ForestryModHelper.getSaplings()) {
                this.addFermenterRecipeSapling(sapling);
            }
        }
        if (this.carpenterAddRecipe.isPresent() && Element.RED_COBBLE.isPresent()) {
            ((Method)this.carpenterAddRecipe.get()).invoke(this.carpenterManager, 10, new LiquidStack(apa.F.cz, 3000, 0), null, new wm(wk.aJ, 4), new Object[]{"#", Character.valueOf('#'), Element.RED_COBBLE.get()});
        }
    }

    private void addSaplings() {
        Optional soil = Optional.fromNullable((Object)ForestryPlugin.getBlock("soil"));
        if (soil.isPresent()) {
            TreeSoilRegistry.addValidSoil(apa.r[((wm)soil.get()).c]);
            BlockCustomSapling.setForestrySoilID(((wm)soil.get()).c);
        }
        this.arborealCrops.add(new CropProviderSapling());
        for (wm sapling : ForestryModHelper.getSaplings()) {
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.%s", sapling.c, sapling.k()));
        }
    }

    private LiquidStack getLiquidStack(String name) throws Exception {
        wm itemStack = (wm)((Method)this.getForestryItem.get()).invoke(null, name);
        return new LiquidStack(itemStack.c, 1, itemStack.k());
    }

    @ForgeSubscribe
    public void init(PluginEvent.Init event) throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.addSaplings();
        this.addBasicFlowers();
        this.addGlobals();
        this.addBackPackItems();
        this.addRecipes();
    }

    private boolean isEnabled() {
        return enabled && Extrabiomes.proxy.isModLoaded("Forestry");
    }

    @ForgeSubscribe
    public void preInit(PluginEvent.Pre event) {
        if (!this.isEnabled()) {
            return;
        }
        LogHelper.fine(Extrabiomes.proxy.getStringLocalization("log.message.plugin.init"), "Forestry");
        try {
            Class<?> cls = Class.forName("forestry.api.core.ItemInterface");
            this.getForestryItem = Optional.fromNullable((Object)cls.getMethod("getItem", String.class));
            cls = Class.forName("forestry.api.core.BlockInterface");
            getForestryBlock = Optional.fromNullable((Object)cls.getMethod("getBlock", String.class));
            cls = Class.forName("forestry.api.recipes.RecipeManagers");
            Field fld = cls.getField("fermenterManager");
            this.fermenterManager = fld.get(null);
            fld = cls.getField("carpenterManager");
            this.carpenterManager = fld.get(null);
            cls = Class.forName("forestry.api.core.ForestryAPI");
            fld = cls.getField("loggerWindfall");
            loggerWindfall = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.cultivation.CropProviders");
            fld = cls.getField("arborealCrops");
            this.arborealCrops = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.apiculture.FlowerManager");
            fld = cls.getField("plainFlowers");
            this.plainFlowers = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.core.GlobalManager");
            fld = cls.getField("leafBlockIds");
            this.leafBlockIds = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.storage.BackpackManager");
            fld = cls.getField("backpackItems");
            this.backpackItems = (ArrayList[])fld.get(null);
            cls = Class.forName("forestry.api.recipes.IFermenterManager");
            this.fermenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", wm.class, Integer.TYPE, Float.TYPE, LiquidStack.class, LiquidStack.class));
            cls = Class.forName("forestry.api.recipes.ICarpenterManager");
            this.carpenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", Integer.TYPE, LiquidStack.class, wm.class, wm.class, Object[].class));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogHelper.fine(Extrabiomes.proxy.getStringLocalization("log.message.plugin.error"), "Forestry");
            enabled = false;
        }
    }

    static {
        getForestryBlock = Optional.absent();
    }
}

