/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.helpers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.DiscoverWorldTypesEvent;
import extrabiomes.lib.BiomeSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.Event;

public abstract class BiomeHelper {
    private static final Set worldTypes = new HashSet();
    private static Optional activeBiomes = Optional.absent();

    public static void addTerrainBlockstoBiome(BiomeSettings biome, int topBlockID, int fillerBlockID) {
        if (!biome.getBiome().isPresent()) {
            return;
        }
        aav baseBiome = (aav)biome.getBiome().get();
        baseBiome.A = (byte)topBlockID;
        baseBiome.B = (byte)fillerBlockID;
    }

    public static void createBiome(BiomeSettings setting) throws Exception {
        if (aav.a[setting.getID()] != null) {
            throw new IllegalArgumentException(String.format("Biome id %d is already in use by %s when adding %s. Please review the configuration file.", setting.getID(), aav.a[setting.getID()].y, setting.toString()));
        }
        setting.createBiome();
    }

    public static Set discoverWorldTypes() {
        if (worldTypes.isEmpty()) {
            worldTypes.add(aal.b);
            worldTypes.add(aal.d);
            DiscoverWorldTypesEvent event = new DiscoverWorldTypesEvent(worldTypes);
            Api.getExtrabiomesXLEventBus().post((Event)event);
        }
        return ImmutableSet.copyOf((Collection)worldTypes);
    }

    public static void enableBiome(Set worldTypes, aav biome) {
        Extrabiomes.proxy.addBiome(worldTypes, biome);
        BiomeManager.addSpawnBiome((aav)biome);
        BiomeManager.addStrongholdBiome((aav)biome);
    }

    public static Collection getActiveBiomes() {
        if (!activeBiomes.isPresent()) {
            activeBiomes = Optional.of(new ArrayList(BiomeSettings.values().length));
            for (BiomeSettings setting : BiomeSettings.values()) {
                if (!setting.getBiome().isPresent() || setting.isVanilla()) continue;
                ((ArrayList)activeBiomes.get()).add(setting.getBiome().get());
            }
            ((ArrayList)activeBiomes.get()).trimToSize();
        }
        return ImmutableSet.copyOf((Collection)((Collection)activeBiomes.get()));
    }

    public static aav settingToBiomeGenBase(BiomeSettings setting) {
        switch (setting) {
            case DESERT: {
                return aav.d;
            }
            case EXTREMEHILLS: {
                return aav.e;
            }
            case FOREST: {
                return aav.f;
            }
            case JUNGLE: {
                return aav.w;
            }
            case SWAMPLAND: {
                return aav.h;
            }
            case TAIGA: {
                return aav.g;
            }
            case PLAINS: {
                return aav.c;
            }
        }
        return (aav)setting.getBiome().get();
    }

    public static void addWeightedGrassGen(Optional biome, adj grassGen, int weight) {
        if (!biome.isPresent()) {
            return;
        }
        extrabiomes.api.BiomeManager.addWeightedGrassGenForBiome((aav)biome.get(), grassGen, weight);
    }
}

