/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.IShearable;

public class BlockGreenLeaves
extends api
implements IShearable {
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;
    int[] adjacentTreeBlocks;
    private lx[] textures = new lx[]{null, null, null, null, null, null, null, null};

    private static int calcSmoothedBiomeFoliageColor(aak iBlockAccess, int x, int z) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int z1 = -1; z1 <= 1; ++z1) {
            for (int x1 = -1; x1 <= 1; ++x1) {
                int foliageColor = iBlockAccess.a(x + x1, z + z1).l();
                red += (foliageColor & 0xFF0000) >> 16;
                green += (foliageColor & 0xFF00) >> 8;
                blue += foliageColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    private static int setDecayOnMetadata(int metadata) {
        return metadata | 8;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 3;
    }

    public BlockGreenLeaves(int id, aif material, boolean useFastGraphics) {
        super(id, material, useFastGraphics);
    }

    @SideOnly(value=Side.CLIENT)
    public void a(ly iconRegister) {
        this.textures[0] = iconRegister.a("ExtrabiomesXL:leavesfirfancy");
        this.textures[1] = iconRegister.a("ExtrabiomesXL:leavesfirfast");
        this.textures[2] = iconRegister.a("ExtrabiomesXL:leavesredwoodfancy");
        this.textures[3] = iconRegister.a("ExtrabiomesXL:leavesredwoodfast");
        this.textures[4] = iconRegister.a("ExtrabiomesXL:leavesacaciafancy");
        this.textures[5] = iconRegister.a("ExtrabiomesXL:leavesacaciafast");
    }

    public void beginLeavesDecay(aab world, int x, int y, int z) {
        world.b(x, y, z, BlockGreenLeaves.setDecayOnMetadata(world.h(x, y, z)), 3);
    }

    public void a(aab world, int x, int y, int z, int BlockID, int metadata) {
        boolean leafDecayRadius = true;
        int chuckCheckRadius = 2;
        if (!world.e(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            return;
        }
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -1; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    int id = world.a(x + x1, y + y1, z + z1);
                    if (apa.r[id] == null) continue;
                    apa.r[id].beginLeavesDecay(world, x + x1, y + y1, z + z1);
                }
            }
        }
    }

    public int c(aak iBlockAccess, int x, int y, int z) {
        int metadata = BlockGreenLeaves.unmarkedMetadata(iBlockAccess.h(x, y, z));
        if (metadata != BlockType.REDWOOD.metadata()) {
            return this.b(metadata);
        }
        return BlockGreenLeaves.calcSmoothedBiomeFoliageColor(iBlockAccess, x, z);
    }

    public int a(int metadata) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingMetadata() : 0;
    }

    private void doSaplingDrop(aab world, int x, int y, int z, int metadata, int par7) {
        int idDropped = this.a(metadata, world.s, par7);
        int damageDropped = this.a(metadata);
        this.b(world, x, y, z, new wm(idDropped, 1, damageDropped));
    }

    public void a(aab world, int x, int y, int z, int metadata, float chance, int par7) {
        if (world.I) {
            return;
        }
        if (world.s.nextInt(20) == 0) {
            this.doSaplingDrop(world, x, y, z, metadata, par7);
        }
    }

    public int o() {
        return zx.a((double)0.5, (double)1.0);
    }

    public lx a(int side, int metadata) {
        if ((metadata = BlockGreenLeaves.unmarkedMetadata(metadata)) > 2) {
            metadata = 0;
        }
        return this.textures[BlockGreenLeaves.unmarkedMetadata(metadata) * 2 + (!this.c() ? 0 : 1)];
    }

    @SideOnly(value=Side.CLIENT)
    public int h(aab world, int x, int y, int z) {
        return BlockGreenLeaves.unmarkedMetadata(world.h(x, y, z));
    }

    public int b(int metadata) {
        return (metadata = BlockGreenLeaves.unmarkedMetadata(metadata)) == 0 ? zx.a() : (metadata == 1 ? zx.c() : zx.a((double)0.9f, (double)0.1f));
    }

    @SideOnly(value=Side.CLIENT)
    public void a(int id, ve tab, List itemList) {
        if (tab == Extrabiomes.tabsEBXL) {
            for (BlockType blockType : BlockType.values()) {
                itemList.add(new wm((apa)this, 1, blockType.metadata()));
            }
        }
    }

    public void a(aab world, sq player, int x, int y, int z, int md) {
        super.a(world, player, x, y, z, md);
    }

    public int a(int metadata, Random rand, int par3) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingID() : apa.C.cz;
    }

    public boolean isLeaves(aab world, int x, int y, int z) {
        return true;
    }

    public boolean c() {
        return apa.O.c();
    }

    public boolean isShearable(wm item, aab world, int x, int y, int z) {
        return true;
    }

    public void b(aab world, int x, int y, int z, mp entity) {
        this.beginLeavesDecay(world, x, y, z);
    }

    public ArrayList onSheared(wm item, aab world, int x, int y, int z, int fortune) {
        ArrayList<wm> ret = new ArrayList<wm>();
        ret.add(new wm((apa)this, 1, BlockGreenLeaves.unmarkedMetadata(world.h(x, y, z))));
        return ret;
    }

    public int a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    private void removeLeaves(aab world, int x, int y, int z) {
        this.c(world, x, y, z, world.h(x, y, z), 0);
        world.f(x, y, z, 0, 0, 2);
    }

    public boolean a(aak par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.d = !apa.O.c();
        return super.a(par1iBlockAccess, par2, par3, par4, par5);
    }

    public void a(aab world, int x, int y, int z, Random rand) {
        if (world.I) {
            return;
        }
        int metadata = world.h(x, y, z);
        if (BlockGreenLeaves.isUserPlaced(metadata) || !BlockGreenLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = 6;
        int rangeCheckChunk = 7;
        int var9 = 32;
        int var10 = 1024;
        int var11 = 16;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[32768];
        }
        if (world.e(x - 7, y - 7, z - 7, x + 7, y + 7, z + 7)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -6; var12 <= 6; ++var12) {
                for (var13 = -6; var13 <= 6; ++var13) {
                    for (var14 = -6; var14 <= 6; ++var14) {
                        int id = world.a(x + var12, y + var13, z + var14);
                        apa block = apa.r[id];
                        this.adjacentTreeBlocks[(var12 + 16) * 1024 + (var13 + 16) * 32 + var14 + 16] = block != null && block.canSustainLeaves(world, x + var12, y + var13, z + var14) ? 0 : (block != null && block.isLeaves(world, x + var12, y + var13, z + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= 4; ++var12) {
                for (var13 = -6; var13 <= 6; ++var13) {
                    for (var14 = -6; var14 <= 6; ++var14) {
                        for (int var15 = -6; var15 <= 6; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[16912] >= 0) {
            world.b(x, y, z, BlockGreenLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(world, x, y, z);
        }
    }

    public static enum BlockType {
        FIR(0),
        REDWOOD(1),
        ACACIA(2);

        private final int metadata;
        private wm sapling = new wm(apa.C);
        private static boolean loadedCustomBlocks;

        static BlockType fromMetadata(int metadata) {
            metadata = BlockGreenLeaves.unmarkedMetadata(metadata);
            for (BlockType type : BlockType.values()) {
                if (type.metadata() != metadata) continue;
                return type;
            }
            return null;
        }

        private static void loadCustomBlocks() {
            if (Element.SAPLING_FIR.isPresent()) {
                BlockType.FIR.sapling = Element.SAPLING_FIR.get();
            }
            if (Element.SAPLING_REDWOOD.isPresent()) {
                BlockType.REDWOOD.sapling = Element.SAPLING_REDWOOD.get();
            }
            if (Element.SAPLING_ACACIA.isPresent()) {
                BlockType.ACACIA.sapling = Element.SAPLING_ACACIA.get();
            }
            loadedCustomBlocks = true;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private BlockType() {
            void metadata;
            this.metadata = metadata;
        }

        int getSaplingID() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.c;
        }

        int getSaplingMetadata() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.k();
        }

        public int metadata() {
            return this.metadata;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

