/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.biomes;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import extrabiomes.api.BiomeManager;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.biome.WeightedRandomChooser;
import extrabiomes.module.summa.biome.WeightedWorldGenerator;
import extrabiomes.module.summa.worldgen.WorldGenAcacia;
import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenBigAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenCustomSwamp;
import extrabiomes.module.summa.worldgen.WorldGenFirTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTreeHuge;
import extrabiomes.module.summa.worldgen.WorldGenRedwood;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;

public class BiomeManagerImpl
extends BiomeManager {
    private static final adj ACACIA_TREE_GEN = new WorldGenAcacia(false);
    private static final adj ALT_TAIGA_GEN = new aec(false);
    private static final adj BIG_FIR_TREE_GEN = new WorldGenFirTreeHuge(false);
    private static final adj BIG_OAK_TREE_GEN = new adb(false);
    private static final adj BIRCH_TREE_GEN = new adc(false);
    private static final adj CUSTOM_SWAMP_TREE_GEN = new WorldGenCustomSwamp();
    private static final adj FERN_GEN = new aee(apa.ab.cz, 2);
    private static final adj FIR_TREE_GEN = new WorldGenFirTree(false);
    private static final adj GRASS_GEN = new aee(apa.ab.cz, 1);
    private static final adj OAK_TREE_GEN = new aef(false);
    private static final adj REDWOOD_TREE_GEN = new WorldGenRedwood(false);
    private static final adj SHRUB_GEN = new adl(3, 0);
    private static final adj SWAMP_TREE_GEN = new aed();
    private static final adj TAIGA_GEN = new adw();
    private static final Collection disableDefaultGrassBiomes = new ArrayList();
    private static final Map weightedChoices = new EnumMap(BiomeManager.GenType.class);

    private static void addAlpineTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void addAutumnTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_OAK_TREE_GEN, 10);
    }

    private static void addBirchForestTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), OAK_TREE_GEN, 99);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIRCH_TREE_GEN, 9900);
    }

    private static void addDefaultTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_OAK_TREE_GEN, 10);
    }

    private static void addExtremeJungleTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_OAK_TREE_GEN, 2);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), SHRUB_GEN, 9);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new adj(){

            public boolean a(aab world, Random rand, int x, int y, int z) {
                adt worldGen = new adt(false, 10 + rand.nextInt(20), 3, 3);
                return worldGen.a(world, rand, x, y, z);
            }
        }, 3);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new adj(){

            public boolean a(aab world, Random rand, int x, int y, int z) {
                aef worldGen = new aef(false, 4 + rand.nextInt(7), 3, 3, true);
                return worldGen.a(world, rand, x, y, z);
            }
        }, 6);
    }

    private static void addGrass(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        if (!disableDefaultGrassBiomes.contains(biome.get())) {
            BiomeManagerImpl.addWeightedGrassGenForBiome((aav)biome.get(), GRASS_GEN, 100);
        }
    }

    private static void addGrassandFerns(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedGrassGenForBiome((aav)biome.get(), FERN_GEN, 25);
        BiomeManagerImpl.addWeightedGrassGenForBiome((aav)biome.get(), GRASS_GEN, 75);
    }

    private static void addGreenSwampTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), SWAMP_TREE_GEN, 20);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), CUSTOM_SWAMP_TREE_GEN, 80);
    }

    private static void addMiniJungleTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), SWAMP_TREE_GEN, 100);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_OAK_TREE_GEN, 99);
    }

    private static void addRainforestTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIRCH_TREE_GEN, 2);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_OAK_TREE_GEN, 49999);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), OAK_TREE_GEN, 149997);
    }

    private static void addRedwoodForestTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), REDWOOD_TREE_GEN, 100);
    }

    private static void addRedwoodLushTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), REDWOOD_TREE_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), FIR_TREE_GEN, 50);
    }

    private static void addSavannaTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), ACACIA_TREE_GEN, 100);
    }

    private static void addShrublandTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new adj(){

            public boolean a(aab world, Random rand, int x, int y, int z) {
                adl worldGen = new adl(3, rand.nextInt(3));
                return worldGen.a(world, rand, x, y, z);
            }
        }, 200);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), new adj(){

            public boolean a(aab world, Random rand, int x, int y, int z) {
                return false;
            }
        }, 100);
    }

    private static void addTaigaTrees(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), TAIGA_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), ALT_TAIGA_GEN, 100);
    }

    private static void addTemporateRainforest(Optional biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), BIG_FIR_TREE_GEN, 200);
        BiomeManagerImpl.addWeightedTreeGenForBiome((aav)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void buildWeightedBiomeGrassList() {
        BiomeManagerImpl.addGrass(alpine);
        BiomeManagerImpl.addGrass(autumnwoods);
        BiomeManagerImpl.addGrass(birchforest);
        BiomeManagerImpl.addGrassandFerns(extremejungle);
        BiomeManagerImpl.addGrass(forestedhills);
        BiomeManagerImpl.addGrass(forestedisland);
        BiomeManagerImpl.addGrass(glacier);
        BiomeManagerImpl.addGrass(greenhills);
        BiomeManagerImpl.addGrass(greenswamp);
        BiomeManagerImpl.addGrass(icewasteland);
        BiomeManagerImpl.addGrass(marsh);
        BiomeManagerImpl.addGrass(meadow);
        BiomeManagerImpl.addGrassandFerns(minijungle);
        BiomeManagerImpl.addGrass(mountaindesert);
        BiomeManagerImpl.addGrass(mountainridge);
        BiomeManagerImpl.addGrass(mountaintaiga);
        BiomeManagerImpl.addGrass(pineforest);
        BiomeManagerImpl.addGrassandFerns(rainforest);
        BiomeManagerImpl.addGrassandFerns(redwoodforest);
        BiomeManagerImpl.addGrassandFerns(redwoodlush);
        BiomeManagerImpl.addGrass(savanna);
        BiomeManagerImpl.addGrass(shrubland);
        BiomeManagerImpl.addGrass(snowforest);
        BiomeManagerImpl.addGrass(snowyrainforest);
        BiomeManagerImpl.addGrassandFerns(temperaterainforest);
        BiomeManagerImpl.addGrass(tundra);
        BiomeManagerImpl.addGrass(wasteland);
        BiomeManagerImpl.addGrass(woodlands);
    }

    private static void buildWeightedBiomeTreeList() {
        BiomeManagerImpl.addAlpineTrees(alpine);
        BiomeManagerImpl.addAutumnTrees(autumnwoods);
        BiomeManagerImpl.addBirchForestTrees(birchforest);
        BiomeManagerImpl.addExtremeJungleTrees(extremejungle);
        BiomeManagerImpl.addDefaultTrees(forestedhills);
        BiomeManagerImpl.addDefaultTrees(forestedisland);
        BiomeManagerImpl.addDefaultTrees(glacier);
        BiomeManagerImpl.addDefaultTrees(greenhills);
        BiomeManagerImpl.addGreenSwampTrees(greenswamp);
        BiomeManagerImpl.addDefaultTrees(icewasteland);
        BiomeManagerImpl.addDefaultTrees(marsh);
        BiomeManagerImpl.addDefaultTrees(meadow);
        BiomeManagerImpl.addMiniJungleTrees(minijungle);
        BiomeManagerImpl.addDefaultTrees(mountaindesert);
        BiomeManagerImpl.addDefaultTrees(mountainridge);
        BiomeManagerImpl.addTaigaTrees(mountaintaiga);
        BiomeManagerImpl.addTaigaTrees(pineforest);
        BiomeManagerImpl.addRainforestTrees(rainforest);
        BiomeManagerImpl.addRedwoodForestTrees(redwoodforest);
        BiomeManagerImpl.addRedwoodLushTrees(redwoodlush);
        BiomeManagerImpl.addSavannaTrees(savanna);
        BiomeManagerImpl.addShrublandTrees(shrubland);
        BiomeManagerImpl.addDefaultTrees(snowforest);
        BiomeManagerImpl.addTemporateRainforest(snowyrainforest);
        BiomeManagerImpl.addTemporateRainforest(temperaterainforest);
        BiomeManagerImpl.addDefaultTrees(tundra);
        BiomeManagerImpl.addDefaultTrees(wasteland);
        BiomeManagerImpl.addDefaultTrees(woodlands);
    }

    public static void disableDefaultGrassforBiomes(Collection biomes) {
        disableDefaultGrassBiomes.addAll(biomes);
    }

    public static void populateAPIBiomes() {
        alpine = BiomeSettings.ALPINE.getBiome();
        autumnwoods = BiomeSettings.AUTUMNWOODS.getBiome();
        birchforest = BiomeSettings.BIRCHFOREST.getBiome();
        extremejungle = BiomeSettings.EXTREMEJUNGLE.getBiome();
        forestedhills = BiomeSettings.FORESTEDHILLS.getBiome();
        forestedisland = BiomeSettings.FORESTEDISLAND.getBiome();
        glacier = BiomeSettings.GLACIER.getBiome();
        greenhills = BiomeSettings.GREENHILLS.getBiome();
        greenswamp = BiomeSettings.GREENSWAMP.getBiome();
        icewasteland = BiomeSettings.ICEWASTELAND.getBiome();
        marsh = BiomeSettings.MARSH.getBiome();
        meadow = BiomeSettings.MEADOW.getBiome();
        minijungle = BiomeSettings.MINIJUNGLE.getBiome();
        mountaindesert = BiomeSettings.MOUNTAINDESERT.getBiome();
        mountainridge = BiomeSettings.MOUNTAINRIDGE.getBiome();
        mountaintaiga = BiomeSettings.MOUNTAINTAIGA.getBiome();
        pineforest = BiomeSettings.PINEFOREST.getBiome();
        rainforest = BiomeSettings.RAINFOREST.getBiome();
        redwoodforest = BiomeSettings.REDWOODFOREST.getBiome();
        redwoodlush = BiomeSettings.REDWOODLUSH.getBiome();
        savanna = BiomeSettings.SAVANNA.getBiome();
        shrubland = BiomeSettings.SHRUBLAND.getBiome();
        snowforest = BiomeSettings.SNOWYFOREST.getBiome();
        snowyrainforest = BiomeSettings.SNOWYRAINFOREST.getBiome();
        temperaterainforest = BiomeSettings.TEMPORATERAINFOREST.getBiome();
        tundra = BiomeSettings.TUNDRA.getBiome();
        wasteland = BiomeSettings.WASTELAND.getBiome();
        woodlands = BiomeSettings.WOODLANDS.getBiome();
    }

    public BiomeManagerImpl() {
        ArrayListMultimap tree = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.TREE, tree);
        ArrayListMultimap grass = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.GRASS, grass);
        instance = Optional.of((Object)this);
    }

    @Override
    protected void addBiomeGen(BiomeManager.GenType genType, aav biome, adj treeGen, int weight) {
        Multimap choices = (Multimap)weightedChoices.get((Object)genType);
        choices.put((Object)biome, (Object)new WeightedWorldGenerator(treeGen, weight));
    }

    public static void buildWeightedFloraLists() {
        BiomeManagerImpl.buildWeightedBiomeTreeList();
        BiomeManagerImpl.buildWeightedBiomeGrassList();
    }

    @Override
    protected Optional chooseBiomeRandomGen(BiomeManager.GenType genType, Random rand, aav biome) {
        Collection choicesForBiome;
        Optional randomItem;
        Optional choicesForGenType = Optional.fromNullable(weightedChoices.get((Object)genType));
        if (choicesForGenType.isPresent() && (randomItem = WeightedRandomChooser.getRandomItem(rand, choicesForBiome = ((Multimap)choicesForGenType.get()).get((Object)biome))).isPresent()) {
            return Optional.of((Object)((WeightedWorldGenerator)((Object)randomItem.get())).getWorldGen());
        }
        return Optional.absent();
    }

    @Override
    protected Collection getBiomeCollection() {
        return ImmutableSet.copyOf((Collection)BiomeHelper.getActiveBiomes());
    }

    @Override
    protected int getBiomeTotalWeight(BiomeManager.GenType genType, aav biome) {
        return WeightedRandomChooser.getTotalWeight(((Multimap)weightedChoices.get((Object)genType)).get((Object)biome));
    }
}

