/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes;

import com.google.common.base.Optional;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import extrabiomes.Module;
import extrabiomes.PluginManager;
import extrabiomes.biomes.BiomeManagerImpl;
import extrabiomes.events.ModuleEvent;
import extrabiomes.events.ModulePreInitEvent;
import extrabiomes.handlers.BiomeHandler;
import extrabiomes.handlers.BlockHandler;
import extrabiomes.handlers.ConfigurationHandler;
import extrabiomes.handlers.ItemHandler;
import extrabiomes.handlers.RecipeHandler;
import extrabiomes.helpers.LogHelper;
import extrabiomes.localization.LocalizationHandler;
import extrabiomes.module.fabrica.recipe.RecipeManager;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.CreativeTab;
import java.io.File;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventBus;

@Mod(modid="ExtrabiomesXL", name="ExtrabiomesXL", version="3.12.1")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class Extrabiomes {
    @Mod.Instance(value="ExtrabiomesXL")
    public static Extrabiomes instance;
    @SidedProxy(clientSide="extrabiomes.proxy.ClientProxy", serverSide="extrabiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final ve tabsEBXL;
    private static final String LOG_MESSAGE_INITIALIZING = "log.message.initializing";
    private static final String LOG_MESSAGE_LOAD_SUCCESS = "log.message.load.success";
    public static final String TEXTURE_PATH = "ExtrabiomesXL:";
    private static Optional initBus;

    @Mod.Init
    public static void init(FMLInitializationEvent event) throws InstantiationException, IllegalAccessException {
        proxy.registerRenderInformation();
        Module.postEvent(new ModuleEvent.ModuleInitEvent());
    }

    @Mod.PostInit
    public static void postInit(FMLPostInitializationEvent event) {
        PluginManager.activatePlugins();
        RecipeHandler.init();
        initBus = Optional.absent();
        Module.releaseStaticResources();
        LogHelper.info(proxy.getStringLocalization(LOG_MESSAGE_LOAD_SUCCESS), new Object[0]);
    }

    public static boolean postInitEvent(Event event) {
        return initBus.isPresent() ? ((EventBus)initBus.get()).post(event) : false;
    }

    @Mod.PreInit
    public static void preInit(FMLPreInitializationEvent event) throws Exception {
        LogHelper.info(proxy.getStringLocalization(LOG_MESSAGE_INITIALIZING), new Object[0]);
        LocalizationHandler.loadLanguages();
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "/extrabiomes/extrabiomes.cfg"));
        BiomeHandler.init();
        BiomeManagerImpl.populateAPIBiomes();
        new BiomeManagerImpl();
        Extrabiomes.registerInitEventHandler(new RecipeManager());
        BlockHandler.createBlocks();
        ItemHandler.createItems();
        BiomeHandler.registerWorldGenerators();
        BiomeHandler.enableBiomes();
        BiomeManagerImpl.buildWeightedFloraLists();
        Module.registerModules();
        Module.postEvent(new ModulePreInitEvent());
        proxy.addStringLocalization("itemGroup.extrabiomesTab", "en_US", "ExtrabiomesXL");
    }

    public static void registerInitEventHandler(Object target) {
        if (initBus.isPresent()) {
            ((EventBus)initBus.get()).register(target);
        }
    }

    static {
        tabsEBXL = new CreativeTab(ve.a.length, "extrabiomesTab");
        initBus = Optional.of((Object)new EventBus());
    }
}

