/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.kr4mer.p.Uberjump;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class UberJumpSession {
    long lasts_ticks;
    int lasts_seconds;
    long start_time;
    int height_boost;
    Player player;
    String player_name;
    boolean wasStopped;
    int maxHeight = 50;

    public UberJumpSession(Player player, long ticks, int height) {
        this.player = player;
        this.lasts_ticks = ticks;
        this.start_time = this.getTime();
        this.lasts_seconds = (int)ticks / 20;
        this.player_name = player.getPlayerListName();
        this.height_boost = height;
        this.wasStopped = false;
        this.startSession();
        this.hasEffect();
    }

    private void startSession() {
        PotionEffect potEffect = new PotionEffect(PotionEffectType.getByName((String)"JUMP"), (int)this.lasts_ticks, this.height_boost);
        this.player.addPotionEffect(potEffect, true);
    }

    public boolean hasEnded() {
        return !this.hasEffect() || this.getRemainingTicks() <= 0;
    }

    private boolean hasEffect() {
        Object[] Effects = this.player.getActivePotionEffects().toArray();
        int x = 0;
        while (x < Effects.length) {
            PotionEffect Effect = (PotionEffect)Effects[x];
            if ("JUMP" == Effect.getType().getName()) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public int getRemainingTicks() {
        Object[] Effects = this.player.getActivePotionEffects().toArray();
        int x = 0;
        while (x < Effects.length) {
            PotionEffect Effect = (PotionEffect)Effects[x];
            if ("JUMP" == Effect.getType().getName()) {
                return Effect.getDuration();
            }
            ++x;
        }
        return 0;
    }

    public boolean endSession(boolean forced) {
        if (!this.wasStopped) {
            try {
                this.player.removePotionEffect(PotionEffectType.getByName((String)"JUMP"));
                this.player.sendMessage(ChatColor.RED + "The Uberjump effect has been disabled.");
                this.wasStopped = true;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean endSession() {
        if (!this.wasStopped) {
            try {
                this.player.removePotionEffect(PotionEffectType.getByName((String)"JUMP"));
                this.player.sendMessage(ChatColor.RED + "The Uberjump effect has worn off.");
                this.wasStopped = true;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private long getTime() {
        long time = System.currentTimeMillis() / 1000L;
        return time;
    }
}

