package Teken.XPBank;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetServerHandler;
import net.minecraft.src.BaseMod;
import net.minecraft.src.ModLoader;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.PacketDispatcher;

@Mod(modid = "XPBank", name = "XPBank")
@NetworkMod(clientSideRequired = true, serverSideRequired = false,
channels={"XPBank"}, packetHandler = ExpPacketHandler.class)
public class mod_XPBank extends BaseMod{
	private static int XPBank_blockId = configurationProperties();
	private static int XPExchange_blockId;
	private static boolean updateCheckerEnabled;

	public static Block XPBank;
	public static Block XPExchange;
	public static int blockRenderID = 0;
	public ExpBankRender bren;
	public ExpExchangeRender eren;

	public final static int XPBank_texture_amount = 2;
	public final static int XPExchange_texture_amount = 2;
	
	private double version = 5.3;

	@Override
	public void load() {
		bren = new ExpBankRender();
		eren = new ExpExchangeRender();
		initBlocks();
		registerBlocks();
		addRecipes();
		addNames();

		if (updateCheckerEnabled == true)
		{
			Teken.TekensAPI.VersionCheckerAPI.checkerXMLSSP("XP Bank", version, "http://teken.host22.com/minecraft/Versions.xml", "http://adf.ly/4iTmm", ModLoader.getMinecraftInstance());
		}
		else
		{
			System.out.println("Update Check Skipped");
		}
		blockRenderID = ModLoader.getUniqueBlockModelID(this, true);
	}
	
	public static int configurationProperties()
	{
		Teken.TekensAPI.PropertiesAPI.initialiseProperties("\\config", "\\XPBank.cfg", "XP Bank");
        XPBank_blockId = Teken.TekensAPI.PropertiesAPI.propertieInt("XPBank_block", "155");
        XPExchange_blockId = Teken.TekensAPI.PropertiesAPI.propertieInt("XPExchange_block", "156");
        updateCheckerEnabled = Teken.TekensAPI.PropertiesAPI.propertieBoolean("Update_Checker_Enabled", "True");
        Teken.TekensAPI.PropertiesAPI.finaliseProperties();
		return XPBank_blockId;
	}

	private boolean AreBlocksAdded;

	public void initBlocks()
	{
		XPBank = new ExpBankBlock(XPBank_blockId).setResistance(1F).setBlockName("XPBank").setHardness(0.8f);
		XPExchange = new ExpExchangeBlock(XPExchange_blockId).setResistance(1F).setBlockName("XPExchange").setHardness(0.8f);
	}

	public void addRenderer(Map var1)
	{
		ModLoader.registerTileEntity(ExpBankTileEntity.class, "XPBankTileEntity", bren);
		ModLoader.registerTileEntity(ExpExchangeTileEntity.class, "XPExchangeTileEntity", eren);
	}

	public void registerBlocks()
	{
		ModLoader.registerBlock(XPBank);
		ModLoader.registerBlock(XPExchange);
	}

	public void addRecipes()
	{
		ModLoader.addRecipe(new ItemStack(XPBank, 1), new Object[]
				{
			"zxz", "xyx", "zxz", 'x', Item.diamond, 'y', Block.chest, 'z', Item.ingotIron
				});
		ModLoader.addRecipe(new ItemStack(XPExchange, 1), new Object[]
				{
			"zzz", " z ", " x ", 'x', XPBank, 'z', Item.ingotIron
				});
	}

	public void addNames()
	{
		ModLoader.addName(XPBank, "XPBank");
		ModLoader.addName(XPExchange, "XPExchange");
	}

	public void renderInvBlock(RenderBlocks renderblocks, Block block, int i, int j)
	{
		if (block instanceof ExpBankBlock)
		{
			ExpBankItemRenderHelper.instance.func_35609_a(block, i, j);
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);
		}

		if (block instanceof ExpExchangeBlock)
		{
			ExpExchangeItemRenderHelper.instance.func_35609_a(block, i, j);
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);
		}
	}
	
	public String getAuthor()
	{
		return "Teken";
	}

	public String getName()
	{
		return "XP Bank";
	}

	public String getVersion()
	{
		return Double.toString(version);
	}
}
