package Teken.XPBank;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.src.ModLoader;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;

public class ExpPacketHandler implements IPacketHandler {

        @Override
        public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player playerEntity) {
        	 if (packet.channel.equals("XPBank")) {
                 handleRandom(packet);
         }
        }
        
		private void handleRandom(Packet250CustomPayload packet) {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
            
            int levelsToSend = 0;
            String playerName = "";
            
            try {
                    levelsToSend = inputStream.readInt();                  
                    playerName = inputStream.readLine().replaceAll(".(.)", "$1");
            } catch (IOException e) {
                    e.printStackTrace();
                    return;
            }
            
            EntityPlayer player = ModLoader.getMinecraftInstance().thePlayer;
            if(player.username.equals(playerName)){
            	player.addExperienceLevel(levelsToSend);
            	player.addChatMessage("You have been given "+levelsToSend+" xp");
            }
            
            System.out.println(playerName+ " has recivied "+levelsToSend+" xp");
    }

}