package Teken.XPBank;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.tileentity.TileEntity;

import org.lwjgl.opengl.GL11;

public class ExpExchangeRender extends ExpCoreTileEntitySpecialRenderer
{
	private ExpExchangeModel aModel;

	public ExpExchangeRender()
	{
		aModel = new ExpExchangeModel();
	}

	public void renderAModelAt(ExpExchangeTileEntity tileentity1, double d, double d1, double d2, float f)
	{
		aModel = tileentity1.aModel;
		int i;

		if (tileentity1.worldObj == null)
		{
			i = 0;
		}
		else
		{
			Block block = tileentity1.getBlockType();
			i = tileentity1.getBlockMetadata();

			if (block != null && i == 0)
			{
				i = tileentity1.getBlockMetadata();
			}
		}



		int j = 0;
		if (i == 2)j = 0;
		if (i == 3)j = 180;
		if (i == 4)j = 90;
		if (i == 5)j = -90;

		GL11.glPushMatrix();
		GL11.glTranslatef((float)d + 0.5F, (float)d1 + 1.5F, (float)d2 + 0.5F);
		GL11.glRotatef(j, 0.0F, 1.0F, 0.0F);
		GL11.glRotatef(180f, 0f, 0f, 1f);
		bindTextureByName("/Teken/XPBank/Images/Exchange" + tileentity1.XPExchange_texture + ".png");
		GL11.glPushMatrix();
		aModel.renderModel(0.0625F);
		GL11.glPopMatrix();
		GL11.glPopMatrix();

		if (tileentity1.worldObj == null)
		{
			i = 0;
		}
		else
		{
			if(tileentity1.locked == false)
			{
				rotateArm(tileentity1,aModel);
			}
			else if(tileentity1.locked == true)
			{
				renderLock(tileentity1, d, d1, d2, 32);
				//icon = "/XPBank/locked.png";
			}
		}
	}

	public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f)
	{
		renderAModelAt((ExpExchangeTileEntity)tileentity, d, d1, d2, f);
	}
	public void renderLock(ExpExchangeTileEntity tileentity1, double par3, double par5, double par7, int par9)
	{
		if(tileentity1.locked == false)
		{
			return;
		}
		float f = tileentity1.getDistanceToEntity(RenderManager.instance.livingPlayer);
		if (f > (float)par9)
		{
			return;
		}
		GL11.glPushMatrix();
		GL11.glTranslatef((float)par3 + 0.5F, (float)par5 + 0.3F, (float)par7 + 0.5F);
		GL11.glRotatef(-RenderManager.instance.playerViewY, 0.0F, 1.0F, 0.0F);
		GL11.glRotatef(RenderManager.instance.playerViewX, 1.0F, 0.0F, 0.0F);
		//bindTextureByName(icon);
		GL11.glPushMatrix();
		if (tileentity1.worldObj != null)
		{
			//lock.renderModel(0.0625F);
		}
		GL11.glPopMatrix();
		GL11.glPopMatrix();
		if (tileentity1.worldObj != null)
		{
			renderLockBox(tileentity1, f, par3 + 0.05, par5 + 0.01, par7 + 0.05, par3 + 0.95, par5 + 1.6, par7 + 0.95);
		}

	}

	public void rotateArm(ExpExchangeTileEntity tileentity1, ExpExchangeModel aModel)
	{
		double q = 0.5;

		aModel.pole.rotateAngleY += Math.toRadians(q);
		aModel.arm.rotateAngleY += Math.toRadians(q);
		aModel.mainplate.rotateAngleY += Math.toRadians(q);
		aModel.plateup.rotateAngleY += Math.toRadians(q);
		aModel.platedown.rotateAngleY += Math.toRadians(q);

		if(aModel.pole.rotateAngleY >= Math.toRadians(360))aModel.pole.rotateAngleY=0;
		if(aModel.arm.rotateAngleY >= Math.toRadians(360))aModel.arm.rotateAngleY=0;
		if(aModel.mainplate.rotateAngleY >= Math.toRadians(360))aModel.mainplate.rotateAngleY=0;
		if(aModel.plateup.rotateAngleY >= Math.toRadians(360))aModel.plateup.rotateAngleY=0;
		if(aModel.platedown.rotateAngleY >= Math.toRadians(360))aModel.platedown.rotateAngleY=0;
	}
}