package Teken.XPBank;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;

public class ExpExchangeModel extends ModelBase
{
    //fields

	public ModelRenderer base;
	public ModelRenderer pole;
	public ModelRenderer arm;
	public ModelRenderer mainplate;
	public ModelRenderer plateup;
	public ModelRenderer platedown;
	public ModelRenderer plateleft;
	public ModelRenderer plateright;

    public ExpExchangeModel()
    {
        textureWidth = 64;
        textureHeight = 32;
        base = new ModelRenderer(this, 0, 0);
        base.addBox(-7F, -5F, -7F, 14, 9, 14);
        base.setRotationPoint(0F, 20F, 0F);
        base.setTextureSize(64, 32);
        base.mirror = true;
        setRotation(base, 0F, 0F, 0F);
        pole = new ModelRenderer(this, 0, 4);
        pole.addBox(-1F, 0F, -1F, 2, 5, 2);
        pole.setRotationPoint(0F, 10F, 0F);
        pole.setTextureSize(64, 32);
        pole.mirror = true;
        setRotation(pole, 0F, 0F, 0F);
        arm = new ModelRenderer(this, 0, 4);
        arm.addBox(-1F, -5F, -1F, 2, 5, 2);
        arm.setRotationPoint(0F, 10F, 0F);
        arm.setTextureSize(64, 32);
        arm.mirror = true;
        setRotation(arm, (float)Math.toRadians(30), 0F, 0F);
        mainplate = new ModelRenderer(this, 0, 23);
        mainplate.addBox(-4F, -6F, -4F, 8, 1, 8);
        mainplate.setRotationPoint(0F, 10F, 0F);
        mainplate.setTextureSize(64, 32);
        mainplate.mirror = true;
        setRotation(mainplate, (float)Math.toRadians(30), 0F, 0F);
        plateup = new ModelRenderer(this, 0, 0);
        plateup.addBox(-3F, -10F, 0F, 6, 3, 1);
        plateup.setRotationPoint(0F, 10F, 0F);
        plateup.setTextureSize(64, 32);
        plateup.mirror = true;
        setRotation(plateup, 0F, 0F, 0F);
        platedown = new ModelRenderer(this, 0, 0);
        platedown.addBox(-3F, -10F, -1F, 6, 3, 1);
        platedown.setRotationPoint(0F, 10F, 0F);
        platedown.setTextureSize(64, 32);
        platedown.mirror = true;
        setRotation(platedown, (float)Math.toRadians(60), 0F, 0F);
        plateleft = new ModelRenderer(this, 0, 0);
        plateleft.addBox(-3F, -10F, -1F, 6, 3, 1);
        plateleft.setRotationPoint(0F, 10F, 0F);
        plateleft.setTextureSize(64, 32);
        plateleft.mirror = true;
        setRotation(plateleft, (float)Math.toRadians(30), (float)Math.toRadians(90), (float)Math.toRadians(30));
        plateright = new ModelRenderer(this, 0, 0);
        plateright.addBox(-3F, -10F, 0F, 6, 3, 1);
        plateright.setRotationPoint(0F, 10F, 0F);
        plateright.setTextureSize(64, 32);
        plateright.mirror = true;
        setRotation(plateright, (float)Math.toRadians(330), (float)Math.toRadians(90), (float)Math.toRadians(30));
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
    {
        super.render(entity, f, f1, f2, f3, f4, f5);
        setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        base.render(f5);
        pole.render(f5);
        arm.render(f5);
        mainplate.render(f5);
        plateup.render(f5);
        platedown.render(f5);
        //plateleft.render(f5);
        //plateright.render(f5);
    }

    public void renderModel(float f5)
    {
        base.render(f5);
        pole.render(f5);
        arm.render(f5);
        mainplate.render(f5);
        plateup.render(f5);
        platedown.render(f5);
        //plateleft.render(f5);
        //plateright.render(f5);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z)
    {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity)
    {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    }
}
