package Teken.XPBank;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Random;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.src.ModLoader;

import org.lwjgl.opengl.GL11;

import com.google.common.primitives.Bytes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;

public class ExpExchangeGUI extends GuiScreen
{
	public ExpExchangeTileEntity tile;
	public EntityPlayer player;
	public ExpExchangeBlock ExpExchange;
	private int page = 0;
	private int value = 0;
	private BufferedImage img;
	private BufferedImage checkImg;
	private int imgID = 1000;

	private float levelsToSend = 0;

	public GuiScreen parentGui;
	private ExpCoreGUISlotPlayer playerList;

	private static ExpCoreEnumOptions relevantOptions[];
	private ExpCoreGameSettings options;

	public ExpExchangeGUI(ExpExchangeTileEntity entity, EntityPlayer entityplayer, ExpExchangeBlock block, ExpCoreGameSettings settings)
	{
		allowUserInput = true;
		tile = entity;
		player = entityplayer;
		ExpExchange = block;
		options = settings;
	}

	public void initGui()
	{
		try
		{
			img = ModLoader.loadImage(mc.renderEngine, "/Teken/XPBank/Images/background.png");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		controlList.clear();
		controlList.add(new GuiButton(0, width / 2 - 100, height /  2 + 40, "Back"));
		controlList.add(new GuiButton(10, width / 2 - 52, height /  2 + 64, 20, 20, "<<"));
		controlList.add(new GuiButton(11, width / 2 - 30, height /  2 + 64, 60, 20, "Texture: " + tile.XPExchange_texture));
		controlList.add(new GuiButton(12, width / 2 + 32, height /  2 + 64, 20, 20, ">>"));
		//drawPlayer();
		/*ExpCoreEnumOptions aoptions[] = relevantOptions;
		int len = aoptions.length;
		for (int l = 0; l < len; l++)
		{
			ExpCoreEnumOptions option = aoptions[l];
			controlList.add(new ExpCoreGuiSlider(option.returnEnumOrdinal(), width / 2 - 75, height / 2 + 80, option, options.getKeyBinding(option), options.getOptionFloatValue(option), 150, options,0,player.experienceLevel,true));
		}*/
		controlList.add(new GuiButton(7, width / 2 - 72, height /  2 + 20, 20, 20, "<<"));
		controlList.add(new GuiButton(8, width / 2 - 50, height /  2 + 20, 100, 20, "Levels to Send: " + (int)levelsToSend));
		controlList.add(new GuiButton(9, width / 2 + 52, height /  2 + 20, 20, 20, ">>"));
		playerList = new ExpCoreGUISlotPlayer(this);
		playerList.registerScrollButtons(controlList, controlList.size()+1, controlList.size()+2);
	}

	public void actionPerformed(GuiButton button)
	{
		if (button.id == 0)
		{
			ModLoader.openGUI(player, new ExpExchangeGUI(tile, player, ExpExchange, options));
		}

		if (button.id == 7)
		{
			if (levelsToSend != 0)
			{
				levelsToSend -= 1;
				initGui();
			}
		}
		
		if (button.id == 8)
		{
			if (levelsToSend == player.experienceLevel)
			{
				levelsToSend = 0;
				initGui();
			}
			if (levelsToSend < player.experienceLevel)
			{
				levelsToSend += 1;
				initGui();
			}
		}

		if (button.id == 9)
		{
			if (levelsToSend < player.experienceLevel)
			{
				levelsToSend += 1;
				initGui();
			}
		}

		if (button.id == 10)
		{
			if (tile.XPExchange_texture != 0)
			{
				tile.XPExchange_texture -= 1;
				initGui();
			}
		}

		if (button.id == 12)
		{
			if (tile.XPExchange_texture < mod_XPBank.XPExchange_texture_amount - 1)
			{
				tile.XPExchange_texture += 1;
				initGui();
			}
		}
	}

	public void drawScreen(int i, int j, float f)
	{
        try
        {
            int k = mc.renderEngine.getTexture("/Teken/XPBank/Images/background.png");
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            mc.renderEngine.bindTexture(k);
            drawTexturedModalRect(width / 2  - 127, height / 2 - 90, 0, 0, 256, 166);
        }
        finally
        {
        }
		
		drawRect(width / 2 - 120, height /  2 - 80, width / 2 + 122, height /  2 + 20, -2039584);
		playerList.drawScreen(i-120, j, f);
		super.drawScreen(i, j, f);
	}

	public boolean doesGuiPauseGame()
	{
		return false;
	}

	private void drawPlayer()
	{
		int type = 0;
		NetClientHandler netclienthandler = ((EntityClientPlayerMP)player).sendQueue;
		List list = netclienthandler.playerInfoList;
		int i4 = netclienthandler.currentServerMaxPlayers;

		for (int i8 = 0; i8 < i4; i8++)
		{
			if (i8 >= list.size())
			{
				continue;
			}

			GuiPlayerInfo guiplayerinfo = (GuiPlayerInfo)list.get(i8);
			int i2 = 20 * i8;

			if ((i8 < 4) || (i8 >= 8))
			{
				controlList.add(new GuiButton(1, width / 2 - 120, height /  2 - 80 + i2, 78, 20, guiplayerinfo.name));
			}
			else if ((i8 < 8) || (i8 >= 16))
			{
				controlList.add(new GuiButton(1, width / 2 - 38, height /  2 - 80 + (i2 - 120), 78, 20, guiplayerinfo.name));
			}
			else
			{
				controlList.add(new GuiButton(1, width / 2 + 44, height /  2 - 80 + (i2 - 240), 78, 20, guiplayerinfo.name));
			}
		}
	}

	public void sendXP(String sendToPlayer){
		if (!sendToPlayer.equals(ModLoader.getMinecraftInstance().thePlayer.username))
		{
			if(player.experienceLevel > 0){
				sendXPPacket(player, (int)levelsToSend, sendToPlayer);
				ModLoader.getMinecraftInstance().thePlayer.addExperienceLevel(-(int)levelsToSend);
				player.addChatMessage("You have sent " + (int)levelsToSend + " XP levels to " + sendToPlayer);
				levelsToSend = 0;
				initGui();
			}else{
				player.addChatMessage("You have no XP levels to send");
			}
		}
		else
		{
			player.addChatMessage("Stop sending XP to your self");
		}
	}
	
	public static void sendXPPacket(EntityPlayer playerEntity, int levelsToSend, String sendToPlayer) {
		System.out.println("XPBANK: sending "+levelsToSend+" xp from "+playerEntity.username+" to "+sendToPlayer);
        
		byte[] b = null;
		try {
			b = sendToPlayer.getBytes("UTF-8");
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4+b.length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
		        outputStream.writeInt(levelsToSend);
		        outputStream.writeChars(sendToPlayer);
		        
        } catch (Exception ex) {
                ex.printStackTrace();
        }

		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "XPBank";
		packet.data = bos.toByteArray();
		packet.length = bos.size();
		
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
                // We are on the server side.
                EntityPlayerMP player = (EntityPlayerMP) playerEntity;
        } else if (side == Side.CLIENT) {
                // We are on the client side.
                EntityClientPlayerMP player = (EntityClientPlayerMP) playerEntity;
                PacketDispatcher.sendPacketToAllPlayers(packet);
        } else {
                // We are on the Bukkit server.
        }
	}
	
	protected void mouseClicked(int par1, int par2, int par3)
	{
		super.mouseClicked(par1, par2, par3);
	}

	protected void mouseMovedOrUp(int par1, int par2, int par3)
	{
		super.mouseMovedOrUp(par1, par2, par3);
	}

	static
	{
		relevantOptions = (new ExpCoreEnumOptions[]
				{
				ExpCoreEnumOptions.levels
				});
	}
}