package Teken.XPBank;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Random;

import org.lwjgl.opengl.GL11;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExpExchangeBlock extends BlockContainer
{
    static ExpExchangeTileEntity entity;

    protected ExpExchangeBlock(int i)
    {
        super(i, Material.iron);
        setBlockBounds(0.05f, 0f, 0.05f, 0.95f, 1.6f, 0.95f);
        setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.tabMisc);
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving)
    {
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        byte byte0 = 0;
        int i1 = MathHelper.floor_double((double)((par5EntityLiving.rotationYaw * 4F) / 360F) + 0.5D) & 3;

        if (i1 == 0)
        {
            byte0 = 2;
        }

        if (i1 == 1)
        {
            byte0 = 5;
        }

        if (i1 == 2)
        {
            byte0 = 3;
        }

        if (i1 == 3)
        {
            byte0 = 4;
        }

        if (i != blockID && j != blockID && k != blockID && l != blockID)
        {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
        }
        else
        {
            if ((i == blockID || j == blockID) && (byte0 == 4 || byte0 == 5))
            {
                if (i == blockID)
                {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4 - 1, byte0);
                }
                else
                {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4 + 1, byte0);
                }

                par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
            }

            if ((k == blockID || l == blockID) && (byte0 == 2 || byte0 == 3))
            {
                if (k == blockID)
                {
                    par1World.setBlockMetadataWithNotify(par2 - 1, par3, par4, byte0);
                }
                else
                {
                    par1World.setBlockMetadataWithNotify(par2 + 1, par3, par4, byte0);
                }

                par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
            }
        }
    }

    public int idDropped(int i, Random random)
    {
        return mod_XPBank.XPExchange.blockID;
    }

    public int quanityDropped(Random random)
    {
        return 1;
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer player, int par6, float par7, float par8, float par9)
    {
        if (world.isBlockIndirectlyGettingPowered(i, j, k))
        {
            world.spawnEntityInWorld(new EntityLightningBolt(world, i + 2, j, k));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i + 1, j, k + 1));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i + 1, j, k - 1));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i, j, k + 2));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i, j, k - 2));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i - 1, j, k + 1));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i - 1, j, k - 1));
            world.spawnEntityInWorld(new EntityLightningBolt(world, i - 2, j, k));
            player.addChatMessage("This Exchange is Locked");
            return true;
        }
        else
        {
            Object obj = (ExpExchangeTileEntity)world.getBlockTileEntity(i, j, k);

            if (obj == null)
            {
                return true;
            }
            else
            {
            	ExpCoreGameSettings settings = new ExpCoreGameSettings(ModLoader.getMinecraftInstance());
                ModLoader.openGUI(player, new ExpExchangeGUI((ExpExchangeTileEntity)(obj), player, this, settings));
                return true;
            }
        }
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l)
    {
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    public int getRenderType()
    {
        return mod_XPBank.blockRenderID;
    }

    public boolean isOpaqueCube()
    {
        return false;
    }

    public boolean renderAsNormalBlock()
    {
        return false;
    }
    public void randomDisplayTick(World world, int i, int j, int k, Random random)
    {
    	ExpExchangeTileEntity tile = (ExpExchangeTileEntity)world.getBlockTileEntity(i, j, k);
        if (world.isBlockIndirectlyGettingPowered(i, j, k))
        {
        	tile.locked = true;
        }else{
        	tile.locked = false;
        }
        if(tile.locked == false){
        particlIn(world, i, j, k, random);
        }
        super.randomDisplayTick(world, i, j, k, random);
    }

    public void particlIn(World par1World, int par2, int par3, int par4, Random par5Random)
    {
        for (int i = par2 - 2; i <= par2 + 2; i++)
        {
            for (int j = par4 - 2; j <= par4 + 2; j++)
            {
                if (i > par2 - 2 && i < par2 + 2 && j == par4 - 1)
                {
                    j = par4 + 2;
                }

                for (int k = par3; k <= par3 + 1; k++)
                {
                    if (!par1World.isAirBlock((i - par2) / 2 + par2, k, (j - par4) / 2 + par4))
                    {
                        break;
                    }

                    par1World.spawnParticle("enchantmenttable", (double)par2 + 0.5D, (double)par3 + 2.4D, (double)par4 + 0.5D, (double)((float)(i - par2) + par5Random.nextFloat()) - 0.5D, (float)(k - par3) - par5Random.nextFloat() + 3.0F, (double)((float)(j - par4) + par5Random.nextFloat()) - 0.5D);
                }
            }
        }
    }

	@Override
	public TileEntity createNewTileEntity(World var1) {
		return new ExpExchangeTileEntity();
	}
}