package Teken.XPBank;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public class ExpCoreTileEntity extends TileEntity
{
	public int numUsingPlayers;
    public boolean locked;

    public ExpCoreTileEntity()
    {}
    
    public boolean isUseableByPlayer(EntityPlayer entityplayer)
    {
        if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this)
        {
            return false;
        }

        return entityplayer.getDistanceSq((double)xCoord + 0.5D, (double)yCoord + 0.5D, (double)zCoord + 0.5D) <= 64D;
    }
    
    public float getDistanceToEntity(Entity par1Entity)
    {
        float f = (float)(xCoord - par1Entity.posX);
        float f1 = (float)(yCoord - par1Entity.posY);
        float f2 = (float)(zCoord - par1Entity.posZ);
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }
    
    public boolean canEntityBeSeenByPlayer(Entity par1Entity)
	{
		EntityPlayer p = ModLoader.getMinecraftInstance().thePlayer;
		return this.worldObj.rayTraceBlocks(this.worldObj.getWorldVec3Pool().getVecFromPool(p.posX, p.posY, p.posZ), this.worldObj.getWorldVec3Pool().getVecFromPool(par1Entity.posX, par1Entity.posY + (double)par1Entity.getEyeHeight(), par1Entity.posZ)) == null;
	}
}
