package Teken.XPBank;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

import org.lwjgl.opengl.GL11;

public class ExpCoreGuiSlider extends GuiButton
{
	public float sliderValue;
	public static boolean dragging;
	private ExpCoreEnumOptions idFloat;
	private ExpCoreGameSettings sgame;

	private float minValue;
	private float maxValue;
	private boolean customValues;

	public ExpCoreGuiSlider(int i, int j, int k, ExpCoreEnumOptions options, String s, float f,int size)
	{
		super(i, j, k, size, 20, s);
		sliderValue = 1.0F;
		dragging = false;
		idFloat = null;
		idFloat = options;
		sliderValue = f;
	}

	public ExpCoreGuiSlider(int i, int j, int k, ExpCoreEnumOptions options, String s, float f, int size,ExpCoreGameSettings settings)
	{
		super(i, j, k, size, 20, s);
		sliderValue = 1.0F;
		dragging = false;
		idFloat = null;
		idFloat = options;
		sliderValue = f;
		sgame = settings;
	}

	public ExpCoreGuiSlider(int i, int j, int k, ExpCoreEnumOptions options, String s, float f, int size, ExpCoreGameSettings settings, float minV, float maxV,boolean customValues)
	{
		super(i, j, k, size, 20, s);
		sliderValue = 1.0F;
		dragging = false;
		idFloat = null;
		idFloat = options;
		sliderValue = f;
		sgame = settings;
		minValue = minV;
		maxValue = maxV;
		this.customValues = customValues;
	}

	/**
	 * Returns 0 if the button is disabled, 1 if the mouse is NOT hovering over this button and 2 if it IS hovering over
	 * this button.
	 */
	protected int getHoverState(boolean flag)
	{
		return 0;
	}

	/**
	 * Fired when the mouse button is dragged. Equivalent of MouseListener.mouseDragged(MouseEvent e).
	 */
	protected void mouseDragged(Minecraft minecraft, int i, int j)
	{
		if (!drawButton)
		{
			return;
		}

		if (dragging)
		{
			if(customValues == true){
				sliderValue = (float)(i - (xPosition + 4)) / (float)(width - 8)*maxValue;
			}else{
				sliderValue = (float)(i - (xPosition + 4)) / (float)(width - 8);
			}
			valueCheck();
			sgame.setOptionFloatValue(idFloat, sliderValue);
			displayString = sgame.getKeyBinding(idFloat);
		}
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		if(customValues == true){
			drawTexturedModalRect((int)(xPosition + (int)((sliderValue * (float)(width - 8))/maxValue)), yPosition, 0, 66, 4, 20);
			drawTexturedModalRect((int)(xPosition + (int)(((sliderValue * (float)(width - 8))/maxValue) + 4)), yPosition, 196, 66, 4, 20);
		}else{
			drawTexturedModalRect(xPosition + (int)(sliderValue * (float)(width - 8)), yPosition, 0, 66, 4, 20);
			drawTexturedModalRect(xPosition + (int)(sliderValue * (float)(width - 8)) + 4, yPosition, 196, 66, 4, 20);
		}
	}

	/**
	 * Returns true if the mouse has been pressed on this control. Equivalent of MouseListener.mousePressed(MouseEvent
	 * e).
	 */
	public boolean mousePressed(Minecraft minecraft, int i, int j)
	{
		if (super.mousePressed(minecraft, i, j))
		{
			if(customValues == true){
				sliderValue = (float)(i - (xPosition + 4)) / (float)(width - 8)*maxValue;
			}else{
				sliderValue = (float)(i - (xPosition + 4)) / (float)(width - 8);
			}
			valueCheck();
			sgame.setOptionFloatValue(idFloat, sliderValue);
			displayString = sgame.getKeyBinding(idFloat);
			dragging = true;
			return true;
		}
		else
		{
			return false;
		}
	}

	/**
	 * Fired when the mouse button is released. Equivalent of MouseListener.mouseReleased(MouseEvent e).
	 */
	public void mouseReleased(int i, int j)
	{
		dragging = false;
	}

	private void valueCheck(){
		if(customValues == true){
			if (sliderValue < minValue)
			{
				sliderValue = minValue;
			}

			if (sliderValue > maxValue)
			{
				sliderValue = maxValue;
			}
		}else{
			if (sliderValue < 0.0F)
			{
				sliderValue = 0.0F;
			}

			if (sliderValue > 1.0F)
			{
				sliderValue = 1.0F;
			}
		}
	}
}
