package Teken.XPBank;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ModLoader;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;

import org.lwjgl.input.Keyboard;

public class ExpCoreGameSettings
{
	protected Minecraft mc;
	private File optionsFile;
	public float xp;
	public float level;

	public ExpCoreGameSettings(Minecraft minecraft)
	{
		xp = 1.0F;
		level = 0.0F;
		mc = minecraft;
	}

	public static String getKeyDisplayString(int i)
	{
		if (i < 0)
		{
			return StatCollector.translateToLocalFormatted("key.mouseButton", new Object[]
					{
					Integer.valueOf(i + 101)
					});
		}
		else
		{
			return Keyboard.getKeyName(i);
		}
	}

	public void setOptionFloatValue(ExpCoreEnumOptions option, float f)
	{
		if (option == ExpCoreEnumOptions.XP)
		{
			xp = f;
		}
		if (option == ExpCoreEnumOptions.levels)
		{
			level = f;
		}
	}

	public float getOptionFloatValue(ExpCoreEnumOptions option)
	{
		if (option == ExpCoreEnumOptions.XP)
		{
			return xp;
		}
		else if (option == ExpCoreEnumOptions.levels)
		{
			return level;
		}
		else
		{
			return 0.0F;
		}
	}

	private static String func_48571_a(String as[], int i)
	{
		if (i < 0 || i >= as.length)
		{
			i = 0;
		}

		StringTranslate stringtranslate = StringTranslate.getInstance();
		return stringtranslate.translateKey(as[i]);
	}

	public String getKeyBinding(ExpCoreEnumOptions option)
	{
		StringTranslate stringtranslate = StringTranslate.getInstance();

		if (option.getEnumFloat())
		{
			float f = getOptionFloatValue(option);

			if (option == ExpCoreEnumOptions.XP)
			{
				String s = (new StringBuilder()).append(stringtranslate.translateKey(option.getEnumString())).append(": ").toString();
				if (f == 0.0F)
				{
					return (new StringBuilder()).append(s).append(stringtranslate.translateKey("None")).toString();
				}

				if (f == 1.0F)
				{
					return (new StringBuilder()).append(s).append(stringtranslate.translateKey("All")).toString();
				}
				else
				{
					return (new StringBuilder()).append(s).append((int)(f * 100F)).append("%").toString();
				}
			}

			if (option == ExpCoreEnumOptions.levels)
			{
				String s = (new StringBuilder()).append(stringtranslate.translateKey(option.getEnumString())).toString();
				if (f == 0.0F)
				{
					return (new StringBuilder()).append(s).append(stringtranslate.translateKey("No Levels")).toString();
				}

				if (f == ModLoader.getMinecraftInstance().thePlayer.experienceLevel)
				{
					return (new StringBuilder()).append(s).append(stringtranslate.translateKey("All Levels")).toString();
				}
				else
				{
					return (new StringBuilder()).append(s).append((int)(f)).append(" Levels to send").toString();
				}
			}else{
				String s = (new StringBuilder()).append(stringtranslate.translateKey(option.getEnumString())).append(": ").toString();
				if (f == 0.0F)
				{
					return (new StringBuilder()).append(s).append(stringtranslate.translateKey("options.off")).toString();
				}
				else
				{
					return (new StringBuilder()).append(s).append((int)(f * 100F)).append("%").toString();
				}
			}
		}
		else
		{
			return (new StringBuilder()).append(stringtranslate.translateKey(option.getEnumString())).append(": ").toString();
		}
	}

	private float parseFloat(String s)
	{
		if (s.equals("true"))
		{
			return 1.0F;
		}

		if (s.equals("false"))
		{
			return 0.0F;
		}
		else
		{
			return Float.parseFloat(s);
		}
	}
}
