package Teken.XPBank;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.src.ModLoader;

import org.lwjgl.opengl.GL11;

public class ExpBankTileEntity extends ExpCoreTileEntity
{
	public static int level;
	public static int total;
	public static float current;

	public int level_local;
	public int total_local;
	public float current_local;

	public boolean networked = true;
	public static int XPBank_texture;
	public String lable;
	
	EntityPlayer player = ModLoader.getMinecraftInstance().thePlayer;
	
	public ExpBankTileEntity(){
		updateLabel();
	}

	public void writeToNBT(NBTTagCompound nbttagcompound)
	{
		super.writeToNBT(nbttagcompound);
		nbttagcompound.setInteger("total", total);
		nbttagcompound.setInteger("level", level);
		nbttagcompound.setFloat("current", current);

		nbttagcompound.setInteger("total_local", total_local);
		nbttagcompound.setInteger("level_local", level_local);
		nbttagcompound.setFloat("current_local", current_local);

		nbttagcompound.setInteger("XPBank_texture",XPBank_texture);
		nbttagcompound.setBoolean("networked", networked);
	}

	public void readFromNBT(NBTTagCompound nbttagcompound)
	{
		super.readFromNBT(nbttagcompound);
		total = nbttagcompound.getInteger("total");
		level = nbttagcompound.getInteger("level");
		current = nbttagcompound.getFloat("current");

		total_local = nbttagcompound.getInteger("total_local");
		level_local = nbttagcompound.getInteger("level_local");
		current_local = nbttagcompound.getFloat("current_local");

		XPBank_texture = nbttagcompound.getInteger("XPBank_texture");
		networked = nbttagcompound.getBoolean("networked");
	}

	public void collectAll()
	{
		if(networked){
			addExperienceSimple(level);
			current = 0;
			level = 0;
			total = 0;
		}else{
			addExperienceSimple(level_local);
			current_local = 0;
			level_local = 0;
			total_local = 0;
		}
	}

	public void bankAll()
	{
		if(networked){
			level += player.experienceLevel;
			total += player.experienceTotal;
			current += player.experience;
			player.addExperienceLevel(-player.experienceLevel);
		}else{
			level_local += player.experienceLevel;
			total_local += player.experienceTotal;
			current_local += player.experience;
			player.addExperienceLevel(-player.experienceLevel);
		}
	}

	public void collectXp(float percent)
	{
		if(networked){
			player.experienceLevel += fixIntFromFloat(getPartFromPercent(level,percent));
			player.experienceTotal += fixIntFromFloat(getPartFromPercent(total,percent));
			player.experience += getPartFromPercent(current,percent);
			current -= getPartFromPercent(current,percent);
			level -= fixIntFromFloat(getPartFromPercent(level,percent));
			total -= fixIntFromFloat(getPartFromPercent(total,percent));
		}else{
			player.experienceLevel += fixIntFromFloat(getPartFromPercent(level_local,percent));
			player.experienceTotal += fixIntFromFloat(getPartFromPercent(total_local,percent));
			player.experience += getPartFromPercent(current_local,percent);
			current_local -= getPartFromPercent(current_local,percent);
			level_local -= fixIntFromFloat(getPartFromPercent(level_local,percent));
			total_local -= fixIntFromFloat(getPartFromPercent(total_local,percent));
		}
		check();
	}

	public void bankXp(float percent)
	{
		if(networked){
			level += fixIntFromFloat(getPartFromPercent(player.experienceLevel,percent));
			total += fixIntFromFloat(getPartFromPercent(player.experienceTotal,percent));
			current += getPartFromPercent(player.experience,percent);
		}else{
			level_local += fixIntFromFloat(getPartFromPercent(player.experienceLevel,percent));
			total_local += fixIntFromFloat(getPartFromPercent(player.experienceTotal,percent));
			current_local += getPartFromPercent(player.experience,percent);	
		}
		player.experience -= getPartFromPercent(player.experience,percent);
		player.experienceLevel -= fixIntFromFloat(getPartFromPercent(player.experienceLevel,percent));
		player.experienceTotal -= fixIntFromFloat(getPartFromPercent(player.experienceTotal,percent));
		check();
	}

	private float getPartFromPercent(float whole, float percent){
		return whole*percent;
	}

	private void check(){
		if(level<0)level=0;
		if(total<0)total=0;
		if(level_local<0)level_local=0;
		if(total_local<0)total_local=0;
		if(player.experienceLevel<0)player.experienceLevel=0;
		if(player.experienceTotal<0)player.experienceTotal=0;
	}

	public int fixIntFromFloat(float value)
	{
		return round(value, RoundingMode.HALF_DOWN, 0);
	}

	private int round(float value, RoundingMode mode, int numDecimalPoints)
	{
		BigDecimal number = new BigDecimal(value);
		MathContext context = new MathContext((number.precision() - number.scale() + numDecimalPoints), mode);
		try
		{
			BigDecimal result = number.round(context);
			return result.intValue();
		}
		catch (ArithmeticException ae)
		{
			return 0;
		}
	}

	public void addExperienceSimple(int par1)
	{
		player.experienceLevel += par1;

		if (player.experienceLevel < 0)
		{
			player.experienceLevel = 0;
		}
	}
	
	public void invertMode(){
		networked = !networked;
		/*if(networked)
			changeToPrivateMode();
		else
			changeToNetworkedMode();*/
	}
	
	public void changeToPrivateMode(){
		networked = false;
	}
	
	public void changeToNetworkedMode(){
		networked = true;
		level += level_local;
		total += total_local;
		current += current_local;
		
		level_local = 0;
		total_local = 0;
		current_local = 0;
	}

	public void updateLabel(){
		lable = (networked?"Global":"Local")+"Levels Stored: "+(networked?level:level_local);
	}
}
