package Teken.XPBank;

import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;

import org.lwjgl.opengl.GL11;

public class ExpBankRender extends ExpCoreTileEntitySpecialRenderer
{
	private ExpBankModel aModel;

	public ExpBankRender()
	{
		aModel = new ExpBankModel();
	}

	public void renderAModelAt(ExpBankTileEntity tileentity1, double d, double d1, double d2, float f)
	{

		ExpBankModel bank;
		bank = aModel;
		int i;
		if (tileentity1.worldObj == null)
		{
			i = 0;
		}
		else
		{
			Block block = tileentity1.getBlockType();
			i = tileentity1.getBlockMetadata();
			if (block != null && i == 0)
			{
				i = tileentity1.getBlockMetadata();
			}
		}

		int j = 0;
        if (i == 2)j = 0;
        if (i == 3)j = 180;
        if (i == 4)j = 90;
        if (i == 5)j = -90;

		GL11.glPushMatrix();
		GL11.glTranslatef((float)d + 0.5F, (float)d1 + 1.5F, (float)d2 + 0.5F);
		GL11.glRotatef(j, 0.0F, 1.0F, 0.0F);
		GL11.glRotatef(180f, 0f, 0f, 1f);
		bindTextureByName("/Teken/XPBank/Images/XPBank" + tileentity1.XPBank_texture + ".png");
		GL11.glPushMatrix();
		aModel.renderModel(0.0625F);
		GL11.glPopMatrix();
		GL11.glPopMatrix();
		if (tileentity1.worldObj == null)
		{
			i = 0;
		}
		else
		{
			if(tileentity1.locked == false)
			{
				renderLabel(tileentity1, tileentity1.lable, d, d1, d2, 8);
			}
			else if(tileentity1.locked == true)
			{
				renderLock(tileentity1, d, d1, d2, 32);
			}
		}
	}

	public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f)
	{
		renderAModelAt((ExpBankTileEntity)tileentity, d, d1, d2, f);
	}
	public void renderLabel(ExpBankTileEntity tileentity1, String par2Str, double par3, double par5, double par7, int par9)
	{
		float f = tileentity1.getDistanceToEntity(RenderManager.instance.livingPlayer);
		if (f > (float)par9)
		{
			return;
		}
		FontRenderer fontrenderer = ModLoader.getMinecraftInstance().fontRenderer;
		float f2 = 0.01166656f;// 0.02666656f;
		GL11.glPushMatrix();
		GL11.glTranslatef((float)par3 + 0.5F, (float)par5 + 1.1F, (float)par7 + 0.5F);
		GL11.glNormal3f(0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-RenderManager.instance.playerViewY, 0.0F, 1.0F, 0.0F);
		GL11.glRotatef(RenderManager.instance.playerViewX, 1.0F, 0.0F, 0.0F);
		GL11.glScalef(-f2, -f2, f2);
		GL11.glDisable(GL11.GL_LIGHTING);
		GL11.glDepthMask(false);
		GL11.glDisable(GL11.GL_DEPTH_TEST);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		Tessellator tessellator = Tessellator.instance;
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		tessellator.startDrawingQuads();
		int i = fontrenderer.getStringWidth(par2Str) / 2;
		tessellator.setColorRGBA_F(0.0F, 0.0F, 0.0F, 0.25F);
		tessellator.addVertex(-i - 1, -1 + 0, 0.0D);
		tessellator.addVertex(-i - 1, 8 + 0, 0.0D);
		tessellator.addVertex(i + 1, 8 + 0, 0.0D);
		tessellator.addVertex(i + 1, -1 + 0, 0.0D);
		tessellator.draw();
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		fontrenderer.drawString(par2Str, -fontrenderer.getStringWidth(par2Str) / 2, 0, 0x20ffffff);
		GL11.glEnable(GL11.GL_DEPTH_TEST);
		GL11.glDepthMask(true);
		fontrenderer.drawString(par2Str, -fontrenderer.getStringWidth(par2Str) / 2, 0, -1);
		GL11.glEnable(GL11.GL_LIGHTING);
		GL11.glDisable(GL11.GL_BLEND);
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		GL11.glPopMatrix();
	}

	public void renderLock(ExpBankTileEntity tileentity1, double par3, double par5, double par7, int par9)
	{
		if(tileentity1.locked == false)
		{
			return;
		}
		float f = tileentity1.getDistanceToEntity(RenderManager.instance.livingPlayer);
		if (f > (float)par9)
		{
			return;
		}
		GL11.glPushMatrix();
		GL11.glTranslatef((float)par3 + 0.5F, (float)par5 + 0.3F, (float)par7 + 0.5F);
		GL11.glRotatef(-RenderManager.instance.playerViewY, 0.0F, 1.0F, 0.0F);
		GL11.glRotatef(RenderManager.instance.playerViewX, 1.0F, 0.0F, 0.0F);
		GL11.glPushMatrix();
		if (tileentity1.worldObj != null)
		{
			//lock.renderModel(0.0625F);
		}
		GL11.glPopMatrix();
		GL11.glPopMatrix();
		if (tileentity1.worldObj != null)
		{
			renderLockBox(tileentity1, f,par3, par5 + 0.01, par7, par3 + 1.0, par5 + 1.0, par7 + 1.0);
		}
	}
}