package Teken.XPBank;

import java.awt.image.BufferedImage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSmallButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.src.ModLoader;

import org.lwjgl.opengl.GL11;

public class ExpBankGUI extends GuiScreen
{
    public ExpBankTileEntity tile;
    public EntityPlayer player;
    public ExpBankBlock ExpBank;
    private int page = 0;
    private int value = 0;

    private BufferedImage img;
    private BufferedImage checkImg;
    private int imgID = 1000;

    public float xp;

    private static ExpCoreEnumOptions relevantOptions[];
    private ExpCoreGameSettings options;

    public ExpBankGUI(ExpBankTileEntity entity, EntityPlayer entityplayer, ExpBankBlock expbankblock, ExpCoreGameSettings settings)
    {
        xp = 1.0F;
        allowUserInput = true;
        tile = entity;
        player = entityplayer;
        ExpBank = expbankblock;
        options = settings;
    }
    public void initGui()
    {
    	tile.updateLabel();
        super.initGui();

        try
        {
            img = ModLoader.loadImage(mc.renderEngine, "/Teken/XPBank/Images/background.png");
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        controlList.clear();

        switch (page)
        {
            case 0:
            	String networked = tile.networked?"Global":"Local";
                controlList.add(new GuiButton(4, width / 2 - 100, height / 2 + 40, "Leave Bank"));
                controlList.add(new GuiButton(3, width / 2 - 100, height / 2 + 16, "Specific Amounts"));
                controlList.add(new GuiButton(2, width / 2 + 2, height / 2 - 8, 98, 20, "Bank All XP"));
                controlList.add(new GuiButton(1, width / 2 - 100, height / 2 - 8, 98, 20, "Collect All XP"));
                controlList.add(new GuiSmallButton(5, width / 2 - 124, height / 2 - 87, 50, 20, networked));
                break;

            case 1:
                ExpCoreEnumOptions aoptions[] = relevantOptions;
                int len = aoptions.length;
                for (int l = 0; l < len; l++)
                {
                	ExpCoreEnumOptions option = aoptions[l];
                	controlList.add(new ExpCoreGuiSlider(option.returnEnumOrdinal(), width / 2 - 100, height / 2 - 8, option, options.getKeyBinding(option), options.getOptionFloatValue(option), 200, options));
                }
                controlList.add(new GuiButton(6, width / 2 + 2, height / 2 + 16, 98, 20, "Collect"));
                controlList.add(new GuiButton(7, width / 2 - 100, height / 2 + 16, 98, 20, "Bank"));
                controlList.add(new GuiButton(9, width / 2 - 100, height / 2 + 40, "Back"));
                break;
        }
        controlList.add(new GuiButton(10, width / 2 - 52, height / 2  + 64, 20, 20, "<<"));
        controlList.add(new GuiButton(11, width / 2 - 30, height / 2  + 64, 60, 20, "Texture: " + tile.XPBank_texture));
        controlList.add(new GuiButton(12, width / 2 + 32, height / 2  + 64, 20, 20, ">>"));
    }
    public void actionPerformed(GuiButton button)
    {
        if (button.id == 1)
        {
        	player.xpCooldown = 2;
            tile.collectAll();
            initGui();
        }

        if (button.id == 2)
        {
        	player.xpCooldown = 2;
            tile.bankAll();
            initGui();
        }

        if (button.id == 3)
        {
            page = 1;
            initGui();
        }

        if (button.id == 4)
        {
            mc.displayGuiScreen(null);
        }
        
        if (button.id == 5)
        {
        	tile.invertMode();
        	initGui();
        }

        if (button.id == 6 && options.xp > 0.0F)
        {
        	player.xpCooldown = 2;
            tile.collectXp(options.xp);
            initGui();
        }

        if (button.id == 7 && options.xp > 0.0F)
        {
        	player.xpCooldown = 2;
            tile.bankXp(options.xp);
            initGui();
        }

        if (button.id == 9)
        {
            page = 0;
            initGui();
        }

        if (button.id == 10)
        {
            if (tile.XPBank_texture != 0)
            {
            	tile.XPBank_texture--;
                initGui();
            }
        }

        if (button.id == 12)
        {
            if (tile.XPBank_texture < mod_XPBank.XPBank_texture_amount - 1)
            {
            	tile.XPBank_texture++;
                initGui();
            }
        }
    }

    public void drawScreen(int i, int j, float f)
    {
        int tcolour = 0xffffff;
        drawDefaultBackground();

        try
        {
            int k = mc.renderEngine.getTexture("/Teken/XPBank/Images/background.png");
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            mc.renderEngine.bindTexture(k);
            drawTexturedModalRect(width / 2  - 127, height / 2 - 90, 0, 0, 256, 166);
        }
        finally
        {
        }

        GL11.glPushMatrix();
        GL11.glScalef(2.0F, 2.0F, 2.0F);
        drawCenteredString(fontRenderer, "Xp Bank", width / 4 , height / 4 - 40, tcolour);
        GL11.glPopMatrix();
        drawString(fontRenderer, "Banked", width / 2 - 100, height / 2 - 50, tcolour);
        drawString(fontRenderer, (new StringBuilder()).append("XP Level: ").append(tile.networked ? tile.level : tile.level_local).toString(), width / 2 - 100, height / 2 - 40, tcolour);
        //drawString(fontRenderer, (new StringBuilder()).append("XP Total: ").append(tile.networked ? tile.total : tile.total_local).toString(), width / 2 - 100, height / 2 - 30, tcolour);
        drawString(fontRenderer, "On Person", width / 2 + 2, height / 2 - 50, tcolour);
        drawString(fontRenderer, (new StringBuilder()).append("XP Level: ").append(player.experienceLevel).toString(), width / 2 + 2, height / 2 - 40, tcolour);
        //drawString(fontRenderer, (new StringBuilder()).append("XP Total: ").append(player.experienceTotal).toString(), width / 2 + 2, height / 2 - 30, tcolour);
        drawString(fontRenderer, "XPBank made by: TEKEN", 0, 0, 0xFFFFFF);
        super.drawScreen(i, j, f);
    }

    public boolean doesGuiPauseGame()
    {
        return false;
    }
    static
    {
        relevantOptions = (new ExpCoreEnumOptions[]
                {
        		ExpCoreEnumOptions.XP
                });
    }
}